/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claymobspawn;

import java.util.List;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.entity.soldier.AdditionalSoldierData;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.BrickedItemHolder;
import net.bumblebee.claysoldiers.item.claymobspawn.MultiSpawnItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;
import net.minecraft.class_5253;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class ClaySoldierSpawnItem
extends MultiSpawnItem<ClaySoldierEntity>
implements BrickedItemHolder {
    public static final class_2960 TEXTURE_LOCATION = class_2960.method_60655((String)"csr", (String)"item/clay_soldier");
    public static final String DESCRIPTION_ID_PREFIX = ".with_prefix";
    public static final String PLAYER_LANG = "item.csr.clay_soldier.player";

    public ClaySoldierSpawnItem(class_1792.class_1793 props) {
        super(props.method_57349(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)ClayMobTeamManger.DEFAULT_TYPE));
    }

    @Override
    public class_1299<ClaySoldierEntity> getType() {
        return ModEntityTypes.CLAY_SOLDIER_ENTITY.get();
    }

    @Override
    public class_1799 getBrickedItem(class_1799 original) {
        return original.method_60503((class_1935)ModItems.BRICKED_CLAY_SOLDIER.get());
    }

    public void method_7851(class_1799 pStack, class_1792.class_9635 pContext, List<class_2561> pTooltipComponents, class_1836 pTooltipFlag) {
        ClayMobTeam team;
        List<String> list;
        class_2960 teamKey = (class_2960)pStack.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        if (pTooltipFlag.method_8035()) {
            AdditionalSoldierData type;
            if (teamKey != null) {
                pTooltipComponents.add((class_2561)class_5244.method_48320().method_27693(teamKey.toString()).method_27692(class_124.field_1063));
            }
            if ((type = (AdditionalSoldierData)pStack.method_57824(ModDataComponents.CLAY_SOLDIER_ADDITIONAL_DATA.get())) != null) {
                pTooltipComponents.add((class_2561)class_5244.method_48320().method_10852(type.displayName()).method_27692(class_124.field_1063));
            }
        }
        if (!(list = (team = ClayMobTeamManger.getFromKeyOrError(teamKey, pContext.method_59527())).getPlayerNames()).isEmpty()) {
            if (list.size() == 1) {
                pTooltipComponents.add((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43469((String)PLAYER_LANG, (Object[])new Object[]{list.getFirst()})).method_27692(class_124.field_1063));
            } else {
                pTooltipComponents.add((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43469((String)PLAYER_LANG, (Object[])new Object[]{list.toString()})).method_27692(class_124.field_1063));
            }
        }
    }

    @Override
    public Consumer<ClaySoldierEntity> modifyBeforeSpawn(class_1799 stack) {
        return claySoldier -> {
            claySoldier.setClayTeamType((class_2960)stack.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()));
            claySoldier.setSpawnedFrom(stack, true);
            AdditionalSoldierData additionalSoldierData = (AdditionalSoldierData)stack.method_57824(ModDataComponents.CLAY_SOLDIER_ADDITIONAL_DATA.get());
            if (additionalSoldierData != null) {
                additionalSoldierData.convert(claySoldier);
            }
        };
    }

    public static void setClayMobTeam(class_1799 stack, class_2960 teamId, class_7225.class_7874 registries) {
        ClayMobTeam team = ClayMobTeamManger.getFromKeyOrError(teamId, registries);
        stack.method_57379(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)teamId);
        if (!ClayMobTeamManger.DEFAULT_TYPE.equals((Object)teamId)) {
            stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43469((String)(ModItems.CLAY_SOLDIER.get().method_7876() + DESCRIPTION_ID_PREFIX), (Object[])new Object[]{team.getDisplayName()}));
        }
    }

    @Override
    protected boolean isValid(class_1799 stack, class_1937 level, class_1657 player) {
        class_2960 key = (class_2960)stack.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        if (key == null) {
            return false;
        }
        ClayMobTeam team = ClayMobTeamManger.getFromKey(key, level.method_30349());
        if (team == null) {
            return false;
        }
        return team.canBeUsed(player);
    }

    @Override
    public int getPouchColor(class_9323 stack, class_1309 viewing) {
        return ClaySoldierSpawnItem.getColorFromTeam((class_2960)stack.method_57829(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()), viewing);
    }

    @Override
    public class_9323 requiredForPouch(class_1799 stack) {
        class_2960 team = (class_2960)stack.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        class_9323.class_9324 builder = class_9323.method_57827().method_57840(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)team);
        return builder.method_57838();
    }

    @Override
    public class_1799 recreateStackFromPouch(class_9323 data, class_7225.class_7874 registries) {
        class_1799 stack = new class_1799((class_1935)this);
        ClaySoldierSpawnItem.setClayMobTeam(stack, (class_2960)data.method_57829(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()), registries);
        return stack;
    }

    public static int getColorFromTeam(class_2960 team, class_1309 player) {
        int color = ClayMobTeamManger.getFromKeyOrError(team, (class_7225.class_7874)player.method_56673()).getColor(player, 0.0f);
        if (color == -1) {
            return -6182991;
        }
        return class_5253.class_5254.method_57174((int)color);
    }
}

