/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claymobspawn;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.variant.NameableVariant;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7988;
import net.minecraft.class_8959;
import net.minecraft.class_9323;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiSpawnItem<T extends class_1297>
extends class_1792 {
    public MultiSpawnItem(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public static <V extends NameableVariant, T extends ClayMobEntity> MultiSpawnItem<T> createClayMob(final Supplier<class_1299<T>> entityType, final V variant, class_1792.class_1793 properties) {
        return new MultiSpawnItem<T>(properties){

            @Override
            public class_1299<T> getType() {
                return (class_1299)entityType.get();
            }

            @Override
            public Consumer<T> modifyBeforeSpawn(class_1799 stack) {
                return clayMob -> {
                    clayMob.setSpawnedFrom(stack, true);
                    ((class_7988)clayMob).method_47826((Object)variant);
                };
            }

            @Override
            public int getPouchColor(class_9323 data, class_1309 viewing) {
                return variant.getPouchColor();
            }
        };
    }

    @NotNull
    public class_1269 method_7884(class_1838 pContext) {
        int res;
        class_1657 player = pContext.method_8036();
        int stackCount = pContext.method_8041().method_7947();
        if (player != null && player.method_5715()) {
            stackCount = 1;
        }
        if ((res = this.spawnWithCount(pContext.method_8041(), pContext, stackCount)) > 0) {
            pContext.method_8041().method_7934(res);
            return class_1269.field_21466;
        }
        return res == -1 ? class_1269.field_5814 : class_1269.field_5812;
    }

    public int spawnWithCount(class_1799 doll, class_1838 pContext, int count) {
        if (!this.isValid(doll, pContext.method_8045(), pContext.method_8036()) || count <= 0) {
            return -1;
        }
        class_1937 level = pContext.method_8045();
        if (!(level instanceof class_3218)) {
            return 0;
        }
        class_2338 blockpos = pContext.method_8037();
        class_2350 direction = pContext.method_8038();
        class_2680 blockstate = level.method_8320(blockpos);
        class_2586 blockEntity = level.method_8321(blockpos);
        if (blockEntity instanceof class_8959) {
            class_8959 spawner = (class_8959)blockEntity;
            spawner.method_46408(this.getType(), level.method_8409());
            level.method_8413(blockpos, blockstate, blockstate, 3);
            level.method_33596((class_1297)pContext.method_8036(), (class_6880)class_5712.field_28733, blockpos);
            return 1;
        }
        class_2338 updatedBlockPos = blockstate.method_26220((class_1922)level, blockpos).method_1110() ? blockpos : blockpos.method_10093(direction);
        class_1299<T> entitytype = this.getType();
        for (int i = 0; i < count; ++i) {
            if (entitytype.method_5899((class_3218)level, this.modifyBeforeSpawn(doll.method_46651(1)), updatedBlockPos, class_3730.field_16465, true, !Objects.equals(blockpos, updatedBlockPos) && direction == class_2350.field_11036) == null) continue;
            level.method_33596((class_1297)pContext.method_8036(), (class_6880)class_5712.field_28738, blockpos);
        }
        return count;
    }

    protected boolean isValid(class_1799 stack, class_1937 level, @Nullable class_1657 player) {
        return true;
    }

    public abstract class_1299<T> getType();

    public abstract Consumer<T> modifyBeforeSpawn(class_1799 var1);

    public class_9323 requiredForPouch(class_1799 stack) {
        return class_9323.field_49584;
    }

    public abstract int getPouchColor(class_9323 var1, class_1309 var2);

    public class_1799 recreateStackFromPouch(class_9323 data, class_7225.class_7874 registries) {
        return this.method_7854();
    }
}

