/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claypouch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.item.claymobspawn.MultiSpawnItem;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_5321;
import net.minecraft.class_5632;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class ClayPouchContent
implements class_5632 {
    public static final int MAX_CAPACITY = 256;
    public static final Codec<ClayPouchContent> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_7923.field_41178.method_39673().fieldOf("doll").forGetter(s -> s.item), (App)Codec.intRange((int)0, (int)256).fieldOf("count").forGetter(s -> s.count), (App)class_9323.field_50234.optionalFieldOf("data", (Object)class_9323.field_49584).forGetter(s -> s.data)).apply((Applicative)in, ClayPouchContent::createUnsafe));
    public static final class_9139<class_9129, ClayPouchContent> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), s -> s.item, (class_9139)class_9135.field_48550, s -> s.count, (class_9139)class_9135.method_56382((class_9139)class_9135.method_56368((Codec)class_9323.field_50234)), ClayPouchContent::dataComponents, (item, count, opt) -> ClayPouchContent.createUnsafe(item, count, opt.orElse(class_9323.field_49584)));
    private final MultiSpawnItem<?> item;
    private final int count;
    private final class_9323 data;

    public ClayPouchContent(MultiSpawnItem<?> item, int count, class_9323 map) {
        this.item = item;
        this.count = count;
        this.data = map;
    }

    private static ClayPouchContent createUnsafe(class_1792 item, int count, class_9323 map) {
        try {
            return new ClayPouchContent((MultiSpawnItem)item, count, map);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("%s does not extend %s".formatted(item, MultiSpawnItem.class.getSimpleName()));
        }
    }

    public int getColor(class_1309 player) {
        return this.item.getPouchColor(this.data, player);
    }

    public int maxRemaining() {
        return 256 - this.count;
    }

    public int getFillPercent() {
        return (int)Math.clamp((float)this.count * 13.0f / 256.0f, 1.0f, 13.0f);
    }

    public int getCount() {
        return this.count;
    }

    public ClayPouchContent increment(int grow) {
        return new ClayPouchContent(this.item, this.count + grow, this.data);
    }

    @Nullable
    public ClayPouchContent shrink(int amount) {
        if (amount >= this.count) {
            return null;
        }
        return this.increment(-amount);
    }

    public boolean isFor(class_1799 stack) {
        if (stack.method_7909() != this.item) {
            return false;
        }
        return this.data.method_57833().allMatch(type -> type.comp_2444().equals(stack.method_57824(type.comp_2443())));
    }

    public MultiSpawnItem<?> getItem() {
        return this.item;
    }

    @Nullable
    public ClayPouchContent takeStack(Consumer<class_1799> taken, class_7225.class_7874 registries) {
        int used = Math.min(this.count, this.item.method_7882());
        class_1799 stack = this.createStack(registries);
        stack.method_7939(used);
        this.dataComponents().ifPresent(arg_0 -> ((class_1799)stack).method_57365(arg_0));
        taken.accept(stack);
        return this.shrink(used);
    }

    public class_1799 createStack(class_7225.class_7874 registries) {
        return this.item.recreateStackFromPouch(this.data, registries);
    }

    public void insert(class_1799 stack, BiConsumer<ClayPouchContent, Integer> onSuccess) {
        if (this.isFor(stack)) {
            int inserted = Math.min(stack.method_7947(), this.maxRemaining());
            onSuccess.accept(this.increment(inserted), inserted);
        }
    }

    public Iterable<class_1799> copyItems() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        BlueprintUtil.addItemStackToList(stacks, this.item, this.count);
        return stacks;
    }

    public Optional<class_9323> dataComponents() {
        return this.data == class_9323.field_49584 ? Optional.empty() : Optional.of(this.data);
    }

    public static boolean onPouch(class_1799 stack, UnaryOperator<ClayPouchContent> operation) {
        ClayPouchContent content = (ClayPouchContent)stack.method_57824(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content != null) {
            stack.method_57379(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)((ClayPouchContent)operation.apply(content)));
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClayPouchContent content = (ClayPouchContent)o;
        return this.count == content.count && Objects.equals(this.item, content.item) && Objects.equals(this.data, content.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.item, this.count, this.data});
    }

    public String toString() {
        return "PouchContent(%s: %d)".formatted(new Object[]{this.item, this.count});
    }
}

