/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claystaff;

import java.util.function.Predicate;
import net.bumblebee.claysoldiers.entity.boss.ClayBlockProjectileEntity;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEnchantments;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.claypouch.ClayPouchContent;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ClayStaffItem
extends class_1792 {
    private static final int MIN_BLOCK_SIZE = 1;
    private static final int MAX_BLOCK_SIZE = 5;
    private static final Predicate<class_1799> PROJECTILE_PREDICATE = stack -> stack.method_31574(class_1802.field_8696);
    public static final Predicate<class_1799> SOLDIER_PREDICATE = stack -> {
        if (ModItems.CLAY_SOLDIER.is((class_1799)stack)) {
            return true;
        }
        ClayPouchContent pouchContent = (ClayPouchContent)stack.method_57824(ModDataComponents.CLAY_POUCH_CONTENT.get());
        return pouchContent != null && pouchContent.getItem() == ModItems.CLAY_SOLDIER.get() && pouchContent.getCount() > 0;
    };
    public static final int MAX_HOLD_DURATION = 72000;

    public ClayStaffItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public boolean method_7885(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        return !player.method_7337();
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 72000;
    }

    public void method_7840(class_1799 stack, class_1937 level, class_1309 livingEntity, int timeRemaining) {
        class_1657 player;
        block8: {
            block7: {
                if (!(livingEntity instanceof class_1657)) break block7;
                player = (class_1657)livingEntity;
                if (!level.field_9236) break block8;
            }
            return;
        }
        boolean infiniteMaterials = livingEntity.method_56992();
        class_1799 ammo = null;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 ammoSlot = player.method_31548().method_5438(i);
            Predicate<class_1799> ammoPredicate = ClayStaffItem.getAmmoPredicate(stack, level.method_30349());
            if (!ammoPredicate.test(ammoSlot)) continue;
            ClayPouchContent content = (ClayPouchContent)ammoSlot.method_57824(ModDataComponents.CLAY_POUCH_CONTENT.get());
            ammo = content != null ? content.createStack((class_7225.class_7874)level.method_30349()) : ammoSlot;
            if (infiniteMaterials) break;
            if (content == null) {
                player.method_31548().method_5434(i, 1);
                break;
            }
            ammoSlot.method_57379(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)content.shrink(1));
            break;
        }
        if (ammo == null && infiniteMaterials) {
            class_1799 class_17992 = ammo = ClayStaffItem.getEnchantmentLevel(stack, ModEnchantments.SOLDIER_PROJECTILE, level.method_30349()) > 0 ? ModItems.CLAY_SOLDIER.get().method_7854() : class_1802.field_8696.method_7854();
        }
        if (ammo != null) {
            this.shootBlock(livingEntity, level, stack, timeRemaining, (class_2960)ammo.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get()));
        }
    }

    public static class_1799 getClayStaffAmmo(Predicate<class_1799> ammoPredicate, class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 ammoSlot = player.method_31548().method_5438(i);
            if (!ammoPredicate.test(ammoSlot)) continue;
            ClayPouchContent content = (ClayPouchContent)ammoSlot.method_57824(ModDataComponents.CLAY_POUCH_CONTENT.get());
            class_1799 ammo = content != null ? content.createStack((class_7225.class_7874)player.method_56673()) : ammoSlot;
            return ammo;
        }
        return null;
    }

    protected void shootBlock(class_1309 shooter, class_1937 level, class_1799 stack, int timeRemaining, @Nullable class_2960 clayTeam) {
        int pierce = ClayStaffItem.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9132, level.method_30349());
        float blockSize = (float)(72000 - timeRemaining) * 3.0f / (float)ClayStaffItem.getMaxPower(stack, level.method_30349());
        blockSize = class_3532.method_15363((float)(blockSize + 1.0f), (float)1.0f, (float)5.0f);
        this.shootBlock(shooter, level, blockSize, 0.0f, pierce, clayTeam);
        if (ClayStaffItem.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9108, level.method_30349()) > 0) {
            this.shootBlock(shooter, level, blockSize, -15.0f, pierce, clayTeam);
            this.shootBlock(shooter, level, blockSize, 15.0f, pierce, clayTeam);
        }
    }

    protected void shootBlock(class_1309 shooter, class_1937 level, float blockSize, float yAngleOffset, int pierce, @Nullable class_2960 clayTeam) {
        ClayBlockProjectileEntity clayBlock = new ClayBlockProjectileEntity(level, shooter, shooter.method_5751());
        clayBlock.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454() + yAngleOffset, 0.0f, blockSize / 2.0f, 1.0f);
        if (clayTeam != null) {
            clayBlock.setClayTeam(clayTeam);
        } else {
            clayBlock.setBlockSize(blockSize);
        }
        clayBlock.setPierceCount(pierce);
        level.method_8649((class_1297)clayBlock);
    }

    public static int getMaxPower(class_1799 stack, class_5455 registryAccess) {
        return switch (ClayStaffItem.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9098, registryAccess)) {
            case 0 -> 40;
            case 1 -> 30;
            case 2 -> 20;
            default -> 10;
        };
    }

    public static int getEnchantmentLevel(class_1799 stack, class_5321<class_1887> key, class_5455 registries) {
        return registries.method_33310(class_7924.field_41265).map(r -> r.method_40264(key).map(h -> stack.method_58657().method_57536((class_6880)h)).orElse(0)).orElse(0);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 itemInHand = player.method_5998(usedHand);
        Predicate<class_1799> ammoPredicate = ClayStaffItem.getAmmoPredicate(itemInHand, player.method_56673());
        if (player.method_56992() || player.method_31548().method_55753(ammoPredicate)) {
            player.method_6019(usedHand);
            return class_1271.method_22428((Object)itemInHand);
        }
        return class_1271.method_22431((Object)itemInHand);
    }

    private static Predicate<class_1799> getAmmoPredicate(class_1799 stack, class_5455 registries) {
        return ClayStaffItem.getEnchantmentLevel(stack, ModEnchantments.SOLDIER_PROJECTILE, registries) > 0 ? SOLDIER_PREDICATE : PROJECTILE_PREDICATE;
    }

    public int method_7837() {
        return 1;
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }
}

