/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.disruptor;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.ClayMobContainer;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4153;
import net.minecraft.class_5575;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class DisruptorKillRange {
    private static final int MAX_RANGE = 64;
    public static final Codec<DisruptorKillRange> CODEC = Codec.either((Codec)Codec.floatRange((float)1.0f, (float)64.0f), (Codec)Codec.STRING).comapFlatMap(DisruptorKillRange::getFromEither, DisruptorKillRange::createEither);
    public static final class_9139<ByteBuf, DisruptorKillRange> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48552, d -> Float.valueOf(d.range), (class_9139)class_9135.field_48547, d -> d.unlimited, DisruptorKillRange::new);
    private static final String UNLIMITED_RANGE = "unlimited";
    private final float range;
    private final boolean unlimited;

    private DisruptorKillRange(float range, boolean unlimited) {
        this.range = range;
        this.unlimited = unlimited;
    }

    public static DisruptorKillRange unlimited() {
        return new DisruptorKillRange(0.0f, true);
    }

    public static DisruptorKillRange range(float range) {
        return new DisruptorKillRange(range, false);
    }

    public class_2561 appendRangeToComponent(String rangedKey, String unlimitedKey) {
        return this.unlimited ? class_2561.method_43469((String)rangedKey, (Object[])new Object[]{class_2561.method_43471((String)unlimitedKey)}) : class_2561.method_43469((String)rangedKey, (Object[])new Object[]{Float.valueOf(this.range)});
    }

    public List<? extends ClayMobEntity> getEntitiesInRange(class_3218 level, class_2338 center) {
        List clayMobs = this.unlimited ? level.method_18198(class_5575.method_31795(ClayMobEntity.class), ClayMobEntity::canBeKilledByItem) : (this.range >= 1.0f ? level.method_8390(ClayMobEntity.class, new class_238(center).method_1014((double)this.range), ClayMobEntity::canBeKilledByItem) : List.of());
        return clayMobs;
    }

    public List<ClayMobContainer> getClaySoldierContainers(class_3218 level, class_2338 center) {
        int range = this.unlimited ? 64 : Math.max(64, (int)this.range);
        return level.method_19494().method_22383(h -> h.method_40220(ModTags.PoiTypes.SOLDIER_CONTAINER), center, range, class_4153.class_4155.field_18488).map(p -> DisruptorKillRange.getClayMobContainer(level, p.method_19141())).filter(Objects::nonNull).toList();
    }

    @Nullable
    private static ClayMobContainer getClayMobContainer(class_3218 level, class_2338 pos) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof ClayMobContainer) {
            ClayMobContainer clayMobContainer = (ClayMobContainer)class_25862;
            return clayMobContainer;
        }
        ClaySoldiersCommon.LOGGER.error("ClayMobContainerPoi({}) does not implement {}", (Object)pos.method_23854(), (Object)HamsterWheelBlockEntity.class.getSimpleName());
        return null;
    }

    private static DataResult<DisruptorKillRange> getFromEither(Either<Float, String> either) {
        if (either.left().isPresent()) {
            return DataResult.success((Object)DisruptorKillRange.range(((Float)either.left().orElseThrow()).floatValue()));
        }
        String range = either.right().orElse("");
        if (range.equals(UNLIMITED_RANGE)) {
            return DataResult.success((Object)DisruptorKillRange.unlimited());
        }
        return DataResult.error(() -> "Cannot parse range %s".formatted(range), (Object)new DisruptorKillRange(0.0f, false));
    }

    private Either<Float, String> createEither() {
        if (this.unlimited) {
            return Either.right((Object)UNLIMITED_RANGE);
        }
        return Either.left((Object)Float.valueOf(this.range));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisruptorKillRange that = (DisruptorKillRange)o;
        return Float.compare(this.range, that.range) == 0 && this.unlimited == that.unlimited;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.range), this.unlimited);
    }
}

