/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.menu.AbstractClayMenuSlot;
import net.bumblebee.claysoldiers.menu.AbstractClayMobMenu;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_9334;

public abstract class AbstractClayMobScreen<C extends ClayMobEntity, T extends AbstractClayMobMenu<C>>
extends class_465<T> {
    public static final String CLAY_TEAM_LABEL = "gui.label.csr.clay_team";
    public static final String CLAY_TEAM_LOYAL_LABEL = "gui.label.csr.clay_team_loyalty";
    public static final String SLOT_LABEL = "gui.label.csr.slot";
    protected static final int GRAY_COLOR = 0x404040;
    protected int teamPropertiesY = 6;
    protected int teamPropertiesX = 104;

    public AbstractClayMobScreen(T pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    protected void method_2388(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        ArrayList<Label> labels = new ArrayList<Label>();
        this.queLabels(labels);
        int labelY = this.teamPropertiesY;
        for (Label label : labels) {
            label.render(pGuiGraphics, this.field_22793, this.teamPropertiesX, labelY);
            labelY += label.height;
        }
    }

    protected class_2561 getTeamLabel(ClayMobEntity clayMob) {
        return class_2561.method_43469((String)CLAY_TEAM_LABEL, (Object[])new Object[]{clayMob.getClayTeam().getDisplayName()});
    }

    protected void queLabels(List<Label> labels) {
        ((AbstractClayMobMenu)this.field_2797).forSourceIfPresent(clayMob -> {
            if (!clayMob.method_5864().method_20210(ModTags.EntityTypes.CLAY_BOSS)) {
                labels.add(new Label(this.getTeamLabel((ClayMobEntity)clayMob), clayMob.method_22861()));
            }
            if (clayMob.hasClayTeamOwner()) {
                labels.add(new Label((class_2561)class_2561.method_43469((String)CLAY_TEAM_LOYAL_LABEL, (Object[])new Object[]{clayMob.getOwnerDisplayName()}), 0x404040, 0.75f, 1));
            }
        });
    }

    protected void renderSource(class_332 guiGraphics, int x1, int y1, int x2, int y2, int scale, float yOffset, int mouseX, int mouseY) {
        ((AbstractClayMobMenu)this.field_2797).forSourceIfPresent(clayMob -> class_490.method_2486((class_332)guiGraphics, (int)x1, (int)y1, (int)x2, (int)y2, (int)scale, (float)yOffset, (float)mouseX, (float)mouseY, (class_1309)clayMob));
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.method_2378(8, 84 + ((AbstractClayMobMenu)this.field_2797).inventoryYOffset, 161, 75, mouseX, mouseY)) {
            super.method_2380(guiGraphics, mouseX, mouseY);
            return;
        }
        if (!((AbstractClayMobMenu)this.field_2797).method_34255().method_7960() || this.field_2787 == null) {
            return;
        }
        if (this.field_2787.method_7681()) {
            class_1799 itemstack = this.field_2787.method_7677();
            this.renderSpecialTooltip(guiGraphics, itemstack, mouseX, mouseY);
        } else {
            class_1735 class_17352 = this.field_2787;
            if (class_17352 instanceof AbstractClayMenuSlot) {
                AbstractClayMenuSlot clayMenuSlot = (AbstractClayMenuSlot)class_17352;
                guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)SLOT_LABEL, (Object[])new Object[]{clayMenuSlot.getDisplayName()}).method_27692(class_124.field_1080), mouseX, mouseY);
            }
        }
    }

    protected abstract void renderSpecialTooltip(class_332 var1, class_1799 var2, int var3, int var4);

    protected void addItemName(List<class_2561> tooltip, class_1799 stack) {
        class_5250 itemName = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().method_58413());
        if (stack.method_57826(class_9334.field_49631)) {
            itemName.method_27692(class_124.field_1056);
        }
        tooltip.add((class_2561)itemName);
    }

    protected void addSlotName(List<class_2561> tooltip) {
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof AbstractClayMenuSlot) {
            AbstractClayMenuSlot slot = (AbstractClayMenuSlot)class_17352;
            tooltip.add((class_2561)class_2561.method_43469((String)SLOT_LABEL, (Object[])new Object[]{slot.getDisplayName()}).method_27692(class_124.field_1080));
        }
    }

    public record Label(class_2561 text, int color, float scale, int height) {
        public Label(class_2561 text, int color) {
            this(text, color, 1.0f, 10);
        }

        public void render(class_332 guiGraphics, class_327 font, int x, int y) {
            if (this.scale != 1.0f) {
                class_4587 pose = guiGraphics.method_51448();
                pose.method_22903();
                pose.method_22905(this.scale, this.scale, 1.0f);
                guiGraphics.method_51439(font, this.text, (int)((float)x / this.scale), (int)((float)y / this.scale), this.color, false);
                pose.method_22909();
            } else {
                guiGraphics.method_51439(font, this.text, x, y, this.color, false);
            }
        }
    }
}

