/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu.soldier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.ZombieClaySoldierEntity;
import net.bumblebee.claysoldiers.menu.AbstractClayMobScreen;
import net.bumblebee.claysoldiers.menu.soldier.ClaySoldierMenu;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class ClaySoldierScreen
extends AbstractClayMobScreen<AbstractClaySoldierEntity, ClaySoldierMenu> {
    public static final String PREVIOUS_CLAY_TEAM_LABEL = "gui.label.csr.previous_clay_team";
    public static final String REVIVE_TYPE_COOLDOWN = "gui.label.csr.revive_type_cooldown";
    public static final String REVIVE_TYPE_COOLDOWN_ENTRY = "gui.label.csr.revive_type_cooldown_entry";
    public static final String SOLDIER_PROPERTIES = "gui.label.csr.soldier_properties";
    public static final float REVIVE_SCALE = 0.75f;
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"csr", (String)"textures/gui/container/clay_soldier_inventory.png");

    public ClaySoldierScreen(ClaySoldierMenu pMenu, class_1661 pPlayerInventory, class_2561 pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.field_2779 = 192;
        this.teamPropertiesY = 16;
    }

    protected void method_2389(class_332 guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25302(TEXTURE, x, y, 0, 0, this.field_2792, this.field_2779 + 2);
        this.renderSource(guiGraphics, x + 26, y + 18, x + 75, y + 78, 60, 0.0625f, pMouseX, pMouseY);
    }

    public void method_25394(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.method_2378(24, 16, 50, 70, pMouseX, pMouseY)) {
            ((ClaySoldierMenu)this.field_2797).forSourceIfPresent(soldier -> this.renderProperties(pGuiGraphics, soldier.allProperties(), pMouseX, pMouseY));
        }
        this.method_2380(pGuiGraphics, pMouseX, pMouseY);
    }

    @Override
    protected void renderSpecialTooltip(class_332 pGuiGraphics, class_1799 stack, int mouseX, int mouseY) {
        SoldierHoldableEffect soldierProperties = ClaySoldiersCommon.DATA_MAP.getEffect(stack);
        if (soldierProperties == null) {
            return;
        }
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.addItemName(tooltip, stack);
        this.addSlotName(tooltip);
        class_2561 predicateDisplayName = soldierProperties.predicate().getDisplayName();
        ((ClaySoldierMenu)this.field_2797).forSourceIfPresent(soldier -> {
            ComponentFormating.formatProperties(tooltip, soldierProperties.properties(), List.of(), soldier);
            if (predicateDisplayName != null) {
                tooltip.add(predicateDisplayName);
            }
            pGuiGraphics.method_51437(this.field_22793, tooltip, stack.method_32347(), mouseX, mouseY);
        });
    }

    public void renderProperties(class_332 guiGraphics, SoldierPropertyMapReader properties, int pX, int pY) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add((class_2561)class_2561.method_43471((String)SOLDIER_PROPERTIES).method_27692(class_124.field_1063));
        ComponentFormating.formatProperties(tooltip, properties, List.of(SoldierPropertyTypes.ATTACK_TYPE.get()), ((ClaySoldierMenu)this.field_2797).getSource().orElse(null));
        guiGraphics.method_51434(this.field_22793, tooltip, pX, pY);
    }

    @Override
    protected void method_2388(class_332 pGuiGraphics, int pMouseX, int pMouseY) {
        super.method_2388(pGuiGraphics, pMouseX, pMouseY);
    }

    @Override
    protected void queLabels(List<AbstractClayMobScreen.Label> labels) {
        super.queLabels(labels);
        ((ClaySoldierMenu)this.field_2797).forSourceIfPresent(claySoldier -> {
            Set<Map.Entry<ReviveType, Integer>> entrySet;
            if (claySoldier instanceof ZombieClaySoldierEntity) {
                ZombieClaySoldierEntity zombie = (ZombieClaySoldierEntity)claySoldier;
                labels.add(1, new AbstractClayMobScreen.Label(ClaySoldierScreen.getZombieTeamLabel(zombie), 0x404040, 0.75f, 6));
            }
            if (!(entrySet = claySoldier.getReviveTypeCooldown().entrySet()).isEmpty()) {
                labels.add(new AbstractClayMobScreen.Label((class_2561)class_2561.method_43471((String)REVIVE_TYPE_COOLDOWN), 0x404040));
                for (Map.Entry<ReviveType, Integer> entry : entrySet) {
                    labels.add(new AbstractClayMobScreen.Label((class_2561)class_2561.method_43469((String)REVIVE_TYPE_COOLDOWN_ENTRY, (Object[])new Object[]{entry.getKey().getAnimatedDisplayName((class_1309)claySoldier), entry.getValue() / 20}), 0x404040, 0.75f, 10));
                }
            }
        });
    }

    protected static class_2561 getZombieTeamLabel(ZombieClaySoldierEntity zombie) {
        return class_2561.method_43469((String)PREVIOUS_CLAY_TEAM_LABEL, (Object[])new Object[]{zombie.getPreviousTeam().getDisplayNameWithColor(c -> c.getColor((class_1309)zombie, 0.0f))});
    }
}

