/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.platform.FabricDataMapGetter;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class DataMapPayloadBuilder<H, T> {
    private static final List<DataMapPayloadBuilder<?, ?>> VALUES = new ArrayList();
    public static final DataMapPayloadBuilder<class_1792, SoldierHoldableEffect> HOLDABLE = DataMapPayloadBuilder.register("fabric_holdable", class_7924.field_41197, SoldierHoldableEffect.STREAM_CODEC, FabricDataMapGetter::updateSoldierHoldable);
    public static final DataMapPayloadBuilder<class_1792, SoldierMultiWearable> WEARABLE = DataMapPayloadBuilder.register("fabric_wearable", class_7924.field_41197, SoldierMultiWearable.STREAM_CODEC, FabricDataMapGetter::updateSoldierWearable);
    public static final DataMapPayloadBuilder<class_1792, SoldierPoi> ITEM_POI = DataMapPayloadBuilder.register("fabric_item_poi", class_7924.field_41197, SoldierPoi.STREAM_CODEC, FabricDataMapGetter::updateSoldierItemPoi);
    public static final DataMapPayloadBuilder<class_2248, SoldierPoi> BLOCK_POI = DataMapPayloadBuilder.register("fabric_block_poi", class_7924.field_41254, SoldierPoi.STREAM_CODEC, FabricDataMapGetter::updateSoldierBlockPoi);
    public static final DataMapPayloadBuilder<class_1299<?>, SoldierVehicleProperties> VEHICLE_PROPERTIES = DataMapPayloadBuilder.register("fabric_vehicle_properties", class_7924.field_41266, SoldierVehicleProperties.STREAM_CODEC, FabricDataMapGetter::updateVehicleProperties);
    private final class_8710.class_9154<Payload> id;
    private final class_9139<class_9129, Payload> streamCodec;
    private final Consumer<Map<class_6880<H>, T>> clientEffect;

    private DataMapPayloadBuilder(String name, class_9139<class_9129, Map<class_6880<H>, T>> streamCodec, Consumer<Map<class_6880<H>, T>> clientEffect) {
        this.id = new class_8710.class_9154(class_2960.method_60655((String)"csr", (String)name));
        this.clientEffect = clientEffect;
        this.streamCodec = streamCodec.method_56432(x$0 -> new Payload(x$0), p -> p.map);
    }

    private static <H, T> DataMapPayloadBuilder<H, T> register(String name, class_5321<class_2378<H>> registry, class_9139<class_9129, T> valueCodec, Consumer<Map<class_6880<H>, T>> clientEffect) {
        DataMapPayloadBuilder<H, T> v = new DataMapPayloadBuilder<H, T>(name, registry, valueCodec, clientEffect);
        VALUES.add(v);
        return v;
    }

    public DataMapPayloadBuilder(String name, class_5321<class_2378<H>> registry, class_9139<class_9129, T> valueCodec, Consumer<Map<class_6880<H>, T>> clientEffect) {
        this(name, class_9135.method_56377(HashMap::new, (class_9139)class_9135.method_56383(registry), valueCodec), clientEffect);
    }

    public static void registerAll() {
        VALUES.forEach(DataMapPayloadBuilder::register);
    }

    public static void registerAllReceiver() {
        VALUES.forEach(DataMapPayloadBuilder::registerReceiver);
    }

    private void register() {
        PayloadTypeRegistry.playS2C().register(this.id, this.streamCodec);
    }

    public void registerReceiver() {
        ClientPlayNetworking.registerGlobalReceiver(this.id, Payload::handleClient);
    }

    public class_8710 create(Map<class_6880<H>, T> map) {
        return new Payload(map);
    }

    public class Payload
    implements class_8710 {
        private final Map<class_6880<H>, T> map;

        public Payload(Map<class_6880<H>, T> map) {
            this.map = map;
        }

        public void handleClient(ClientPlayNetworking.Context context) {
            context.client().execute(() -> DataMapPayloadBuilder.this.clientEffect.accept(this.map));
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return DataMapPayloadBuilder.this.id;
        }
    }
}

