/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.networking.spawnpayloads;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.networking.IClientPayload;
import net.bumblebee.claysoldiers.platform.services.INetworkManger;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ClaySoldierSpawnPayload
implements IClientPayload {
    public static final class_8710.class_9154<ClaySoldierSpawnPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"csr", (String)"clay_soldier_spawn"));
    public static final class_9139<class_9129, ClaySoldierSpawnPayload> STREAM_CODEC = new class_9139<class_9129, ClaySoldierSpawnPayload>(){

        public ClaySoldierSpawnPayload decode(class_9129 buffer) {
            return new ClaySoldierSpawnPayload((Integer)class_9135.field_49675.decode((Object)buffer), (class_2960)class_2960.field_48267.decode((Object)buffer), (class_1799)class_1799.field_49268.decode((Object)buffer), (class_1799)class_1799.field_49268.decode((Object)buffer), (class_1799)class_1799.field_49268.decode((Object)buffer), (List)ReviveType.INT_LIST_STREAM_CODEC.decode((Object)buffer), buffer.readInt(), (class_1799)class_1799.field_49268.decode((Object)buffer), buffer.readByte());
        }

        public void encode(class_9129 buffer, ClaySoldierSpawnPayload payload) {
            class_9135.field_49675.encode((Object)buffer, (Object)payload.getEntityId());
            class_2960.field_48267.encode((Object)buffer, (Object)payload.getTeamId());
            class_1799.field_49268.encode((Object)buffer, (Object)payload.cape);
            class_1799.field_49268.encode((Object)buffer, (Object)payload.backpack1);
            class_1799.field_49268.encode((Object)buffer, (Object)payload.backpack2);
            ReviveType.INT_LIST_STREAM_CODEC.encode((Object)buffer, payload.reviveCooldowns);
            buffer.method_53002(payload.skinId);
            class_1799.field_49268.encode((Object)buffer, (Object)payload.carried);
            buffer.method_52997((int)payload.workStatus);
        }
    };
    private final int entityId;
    private final class_2960 teamId;
    private final class_1799 cape;
    private final class_1799 backpack1;
    private final class_1799 backpack2;
    private final List<Integer> reviveCooldowns;
    private final int skinId;
    private final class_1799 carried;
    private final byte workStatus;

    protected ClaySoldierSpawnPayload(int entity, class_2960 teamId, class_1799 cape, class_1799 backpack1, class_1799 backpack2, List<Integer> reviveCooldowns, int skinId, class_1799 carried, byte workStatus) {
        this.entityId = entity;
        this.teamId = teamId;
        this.cape = cape;
        this.backpack1 = backpack1;
        this.backpack2 = backpack2;
        this.reviveCooldowns = reviveCooldowns;
        this.skinId = skinId;
        this.carried = carried;
        this.workStatus = workStatus;
    }

    public ClaySoldierSpawnPayload(AbstractClaySoldierEntity claySoldier) {
        this.entityId = claySoldier.method_5628();
        this.teamId = claySoldier.getClayTeamType();
        this.cape = claySoldier.getItemBySlot(SoldierEquipmentSlot.CAPE).stack();
        this.backpack1 = claySoldier.getItemBySlot(SoldierEquipmentSlot.BACKPACK).stack();
        this.backpack2 = claySoldier.getItemBySlot(SoldierEquipmentSlot.BACKPACK_PASSIVE).stack();
        ArrayList<Integer> cooldowns = new ArrayList<Integer>(ReviveType.values().length);
        for (ReviveType type : ReviveType.values()) {
            cooldowns.add(Objects.requireNonNullElse(claySoldier.getReviveTypeCooldown().get(type), -1));
        }
        this.reviveCooldowns = cooldowns;
        this.skinId = claySoldier.getSkinVariant();
        this.carried = claySoldier.getCarriedStack();
        this.workStatus = claySoldier.getDataWorkStatus();
    }

    @Override
    public void handleClient(INetworkManger.PayloadContext context) {
        class_1297 entity = context.client().field_1687.method_8469(this.entityId);
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            soldier.handleSpawnPayload(this);
        }
    }

    public class_1799 getCape() {
        return this.cape;
    }

    public class_1799 getBackpack1() {
        return this.backpack1;
    }

    public class_1799 getBackpack2() {
        return this.backpack2;
    }

    public List<Integer> getReviveCooldowns() {
        return this.reviveCooldowns;
    }

    public int getSkinId() {
        return this.skinId;
    }

    public class_1799 getCarried() {
        return this.carried;
    }

    public byte getWorkStatus() {
        return this.workStatus;
    }

    protected int getEntityId() {
        return this.entityId;
    }

    protected class_2960 getTeamId() {
        return this.teamId;
    }

    public class_8710.class_9154<? extends ClaySoldierSpawnPayload> method_56479() {
        return ID;
    }
}

