/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.networking.DataMapPayloadBuilder;
import net.bumblebee.claysoldiers.platform.services.IDataMapGetter;
import net.bumblebee.claysoldiers.soldieritemtypes.SoldierItemType;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FabricDataMapGetter
extends class_4309
implements IdentifiableResourceReloadListener,
IDataMapGetter {
    public static final String PATH = "data_maps";
    public static final String HOLDABLE_PATH = "item/soldier_holdable";
    public static final String WEARABLE_PATH = "item/soldier_wearable";
    public static final String ITEM_POI_PATH = "item/soldier_poi";
    public static final String BLOCK_POI_PATH = "block/soldier_poi";
    public static final String ENTITY_VEHICLE_PROPERTIES_PATH = "entity_type/soldier_vehicle_properties";
    public static final class_2960 FABRIC_ITEM_ID = class_2960.method_60655((String)"csr", (String)"csr_items");
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final Map<class_6880<class_1792>, SoldierHoldableEffect> SOLDIER_HOLDABLE_MAP = new HashMap<class_6880<class_1792>, SoldierHoldableEffect>();
    private static final Map<class_6880<class_1792>, SoldierMultiWearable> SOLDIER_WEARABLE_MAP = new HashMap<class_6880<class_1792>, SoldierMultiWearable>();
    private static final Map<class_6880<class_1792>, SoldierPoi> SOLDIER_ITEM_POI_MAP = new HashMap<class_6880<class_1792>, SoldierPoi>();
    private static final Map<class_6880<class_2248>, SoldierPoi> SOLDIER_BLOCK_POI_MAP = new HashMap<class_6880<class_2248>, SoldierPoi>();
    private static final Map<class_6880<class_1299<?>>, SoldierVehicleProperties> SOLDIER_VEHICLE_PROPERTIES_MAP = new HashMap();
    public static final Codec<Map<class_5699.class_7476, SoldierHoldableEffect>> ITEM_SOLDIER_HOLDABLE_CODEC = Codec.unboundedMap((Codec)class_5699.field_39274, SoldierHoldableEffect.CODEC);
    public static final Codec<Map<class_5699.class_7476, SoldierMultiWearable>> ITEM_SOLDIER_WEARABLE_CODEC = Codec.unboundedMap((Codec)class_5699.field_39274, SoldierMultiWearable.CODEC);
    public static final Codec<Map<class_5699.class_7476, SoldierPoi>> ITEM_SOLDIER_POI_CODEC = Codec.unboundedMap((Codec)class_5699.field_39274, SoldierPoi.CODEC);
    public static final Codec<Map<class_5699.class_7476, SoldierVehicleProperties>> ENTITY_SOLDIER_PROPRTIES_CODEC = Codec.unboundedMap((Codec)class_5699.field_39274, SoldierVehicleProperties.CODEC);
    private static final Codec<DataMap<class_1792, SoldierHoldableEffect>> DATA_MAP_HOLDABLE_CODEC = FabricDataMapGetter.createDataMapCodec(ITEM_SOLDIER_HOLDABLE_CODEC, class_7923.field_41178);
    private static final Codec<DataMap<class_1792, SoldierMultiWearable>> DATA_MAP_WEARABLE_CODEC = FabricDataMapGetter.createDataMapCodec(ITEM_SOLDIER_WEARABLE_CODEC, class_7923.field_41178);
    private static final Codec<DataMap<class_1792, SoldierPoi>> DATA_MAP_ITEM_POI_CODEC = FabricDataMapGetter.createDataMapCodec(ITEM_SOLDIER_POI_CODEC, class_7923.field_41178);
    private static final Codec<DataMap<class_2248, SoldierPoi>> DATA_MAP_BLOCK_POI_CODEC = FabricDataMapGetter.createDataMapCodec(ITEM_SOLDIER_POI_CODEC, class_7923.field_41175);
    private static final Codec<DataMap<class_1299<?>, SoldierVehicleProperties>> DATA_MAP_VEHICLE_PROPERTIES_CODEC = FabricDataMapGetter.createDataMapCodec(ENTITY_SOLDIER_PROPRTIES_CODEC, class_7923.field_41177);
    private final EnumMap<SoldierEquipmentSlot, List<class_1792>> bySlot;
    private final class_7225.class_7874 provider;
    private static final List<Consumer<class_5455>> afterTagLoad = new ArrayList<Consumer<class_5455>>();

    @ApiStatus.Internal
    public FabricDataMapGetter() {
        this(null);
    }

    public FabricDataMapGetter(class_7225.class_7874 provider) {
        super(new Gson(), PATH);
        this.provider = provider;
        this.bySlot = new EnumMap(SoldierEquipmentSlot.class);
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            this.bySlot.put(slot, new ArrayList());
        }
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        if (this.provider == null) {
            LOGGER.error("FabricDataMapGetter load Error: Lookup is null");
            return;
        }
        this.loadItems(object, resourceManager);
        List<class_6880<class_1792>> removed = FabricDataMapGetter.removeEmpty(SOLDIER_WEARABLE_MAP, SoldierMultiWearable::isEmpty);
        if (!removed.isEmpty()) {
            ErrorHandler.INSTANCE.error("Removed %s Wearable Properties, because they where empty.".formatted(removed));
        }
        SoldierItemType.setTagLoadCallback(() -> this.provider.method_46762(ModRegistries.SOLDIER_ITEM_TYPES).method_42017().forEach(h -> ((SoldierItemType)h.comp_349()).afterDataMapLoad()));
        class_3503 itemTagLoader = new class_3503(arg_0 -> ((class_7922)class_7923.field_41178).method_55841(arg_0), class_7924.method_60916((class_5321)class_7924.field_41197));
        Map mappedItemTagLoader = itemTagLoader.method_33176(resourceManager);
        IDataMapGetter.warnHoldable(SOLDIER_HOLDABLE_MAP, (holder, tagKey) -> {
            Collection tag = (Collection)mappedItemTagLoader.get(tagKey.comp_327());
            if (tag == null) {
                return false;
            }
            return tag.contains(holder);
        });
    }

    public static void onTagLoad(class_5455 registries) {
        afterTagLoad.forEach(c -> c.accept(registries));
        afterTagLoad.clear();
    }

    private void loadItems(Map<class_2960, JsonElement> object, class_3300 resourceManager) {
        class_3503 itemTagLoader = new class_3503(arg_0 -> ((class_7922)class_7923.field_41178).method_55841(arg_0), class_7924.method_60916((class_5321)class_7924.field_41197));
        Map mappedItemTagLoader = itemTagLoader.method_33176(resourceManager);
        class_3503 blockTagLoader = new class_3503(arg_0 -> ((class_7922)class_7923.field_41175).method_55841(arg_0), class_7924.method_60916((class_5321)class_7924.field_41254));
        Map mappedBlockTagLoader = blockTagLoader.method_33176(resourceManager);
        class_3503 entityTypeTagLoader = new class_3503(arg_0 -> ((class_7922)class_7923.field_41177).method_55841(arg_0), class_7924.method_60916((class_5321)class_7924.field_41266));
        Map mappedEntityTypeTagLoader = entityTypeTagLoader.method_33176(resourceManager);
        object.forEach((key, value) -> {
            switch (key.method_12832()) {
                case "item/soldier_holdable": {
                    FabricDataMapGetter.loadMap(value, DATA_MAP_HOLDABLE_CODEC, mappedItemTagLoader, SOLDIER_HOLDABLE_MAP, key);
                    break;
                }
                case "item/soldier_wearable": {
                    FabricDataMapGetter.loadMap(value, DATA_MAP_WEARABLE_CODEC, mappedItemTagLoader, SOLDIER_WEARABLE_MAP, key);
                    break;
                }
                case "item/soldier_poi": {
                    FabricDataMapGetter.loadMap(value, DATA_MAP_ITEM_POI_CODEC, mappedItemTagLoader, SOLDIER_ITEM_POI_MAP, key);
                    break;
                }
                case "block/soldier_poi": {
                    FabricDataMapGetter.loadMap(value, DATA_MAP_BLOCK_POI_CODEC, mappedBlockTagLoader, SOLDIER_BLOCK_POI_MAP, key);
                    break;
                }
                case "entity_type/soldier_vehicle_properties": {
                    FabricDataMapGetter.loadMap(value, DATA_MAP_VEHICLE_PROPERTIES_CODEC, mappedEntityTypeTagLoader, SOLDIER_VEHICLE_PROPERTIES_MAP, key);
                }
            }
        });
        IDataMapGetter.createBySlotMap(SOLDIER_HOLDABLE_MAP, class_6880::comp_349);
    }

    private static <T, H> void loadMap(JsonElement jsonElement, Codec<DataMap<H, T>> dataMapCodec, Map<class_2960, Collection<class_6880<H>>> tagLoader, Map<class_6880<H>, T> staticMap, class_2960 name) {
        HashMap replaceMap = new HashMap();
        staticMap.clear();
        dataMapCodec.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).ifSuccess(dataMapPartial -> ((DataMap)dataMapPartial.getFirst()).forEach(tagLoader, staticMap::put, replaceMap::put, name)).ifError(err -> LOGGER.error("DataMap from {} loaded with error: {}", (Object)name, (Object)err.error()));
        staticMap.putAll(replaceMap);
        LOGGER.info("Loaded {} Entries for {}.", (Object)staticMap.size(), (Object)name);
        LOGGER.debug("Loaded Entries of {}  for {}", (Object)name, staticMap.keySet());
    }

    private static <K, V> List<K> removeEmpty(Map<K, V> map, Predicate<V> emptyPredicate) {
        List<Object> keysToRemove = map.entrySet().stream().filter(e -> emptyPredicate.test(e.getValue())).map(Map.Entry::getKey).toList();
        keysToRemove.forEach(map::remove);
        return keysToRemove;
    }

    public static List<String> getLoadedDataMapsWithSize() {
        ArrayList<String> list = new ArrayList<String>();
        if (!SOLDIER_HOLDABLE_MAP.isEmpty()) {
            list.add("item/soldier_holdable: " + SOLDIER_HOLDABLE_MAP.size());
        }
        if (!SOLDIER_WEARABLE_MAP.isEmpty()) {
            list.add("item/soldier_wearable: " + SOLDIER_WEARABLE_MAP.size());
        }
        if (!SOLDIER_ITEM_POI_MAP.isEmpty()) {
            list.add("item/soldier_poi: " + SOLDIER_ITEM_POI_MAP.size());
        }
        if (!SOLDIER_BLOCK_POI_MAP.isEmpty()) {
            list.add("block/soldier_poi: " + SOLDIER_BLOCK_POI_MAP.size());
        }
        return list;
    }

    @Override
    @Nullable
    public SoldierHoldableEffect getEffect(class_1799 stack) {
        return SOLDIER_HOLDABLE_MAP.get(stack.method_41409());
    }

    @Override
    @Nullable
    public SoldierHoldableEffect getEffect(class_1792 item) {
        return SOLDIER_HOLDABLE_MAP.get(item.method_40131());
    }

    @Override
    @Nullable
    public SoldierMultiWearable getArmor(class_1799 stack) {
        return SOLDIER_WEARABLE_MAP.get(stack.method_41409());
    }

    @Override
    @Nullable
    public SoldierPoi getItemPoi(class_1799 stack) {
        return SOLDIER_ITEM_POI_MAP.get(stack.method_41409());
    }

    @Override
    @Nullable
    public SoldierPoi getItemPoi(class_1792 item) {
        return SOLDIER_ITEM_POI_MAP.get(item.method_40131());
    }

    @Override
    @Nullable
    public SoldierPoi getBlockPoi(class_2248 block) {
        return SOLDIER_BLOCK_POI_MAP.get(block.method_40142());
    }

    @Override
    @Nullable
    public SoldierVehicleProperties getVehicleProperties(class_1299<?> type) {
        return SOLDIER_VEHICLE_PROPERTIES_MAP.get(type.method_40124());
    }

    @Override
    @NotNull
    public List<class_1792> getHoldableEffectForSlot(SoldierEquipmentSlot slot) {
        return Objects.requireNonNull(this.bySlot.get(slot));
    }

    public class_2960 getFabricId() {
        return FABRIC_ITEM_ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return List.of(ResourceReloadListenerKeys.TAGS);
    }

    private static <T, H> Codec<DataMap<H, T>> createDataMapCodec(Codec<Map<class_5699.class_7476, T>> dataCodec, class_2378<H> registry) {
        return RecordCodecBuilder.create(in -> in.group((App)dataCodec.fieldOf("values").forGetter(DataMap::data), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(DataMap::replace)).apply((Applicative)in, (s, r) -> new DataMap(s, (boolean)r, registry)));
    }

    public static void sentPayloadsToClient(class_3222 serverPlayer) {
        LOGGER.info("Sending DataMap payloads to {}", (Object)serverPlayer.method_5820());
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)DataMapPayloadBuilder.HOLDABLE.create(SOLDIER_HOLDABLE_MAP));
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)DataMapPayloadBuilder.WEARABLE.create(SOLDIER_WEARABLE_MAP));
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)DataMapPayloadBuilder.ITEM_POI.create(SOLDIER_ITEM_POI_MAP));
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)DataMapPayloadBuilder.BLOCK_POI.create(SOLDIER_BLOCK_POI_MAP));
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)DataMapPayloadBuilder.VEHICLE_PROPERTIES.create(SOLDIER_VEHICLE_PROPERTIES_MAP));
    }

    public static void updateSoldierHoldable(Map<class_6880<class_1792>, SoldierHoldableEffect> map) {
        FabricDataMapGetter.updateClientMap(SOLDIER_HOLDABLE_MAP, map, "soldier_holdable");
    }

    public static void updateSoldierWearable(Map<class_6880<class_1792>, SoldierMultiWearable> map) {
        FabricDataMapGetter.updateClientMap(SOLDIER_WEARABLE_MAP, map, "soldier_wearable");
    }

    public static void updateSoldierItemPoi(Map<class_6880<class_1792>, SoldierPoi> map) {
        FabricDataMapGetter.updateClientMap(SOLDIER_ITEM_POI_MAP, map, "soldier_item_poi");
    }

    public static void updateSoldierBlockPoi(Map<class_6880<class_2248>, SoldierPoi> map) {
        FabricDataMapGetter.updateClientMap(SOLDIER_BLOCK_POI_MAP, map, "soldier_block_poi");
    }

    public static void updateVehicleProperties(Map<class_6880<class_1299<?>>, SoldierVehicleProperties> map) {
        FabricDataMapGetter.updateClientMap(SOLDIER_VEHICLE_PROPERTIES_MAP, map, "soldier_vehicle_properties");
    }

    private static <H, T> void updateClientMap(Map<class_6880<H>, T> old, Map<class_6880<H>, T> newMap, String name) {
        LOGGER.info("Syncing {} had previously {} entries now {}", new Object[]{name, old.size(), newMap.size()});
        old.clear();
        old.putAll(newMap);
    }

    private record DataMap<H, T>(Map<class_5699.class_7476, T> data, boolean replace, class_2378<H> registry) {
        public void forEach(Map<class_2960, Collection<class_6880<H>>> tagLookup, BiConsumer<class_6880<H>, T> addMap, BiConsumer<class_6880<H>, T> replaceMap, class_2960 description) {
            this.data.forEach((key, value) -> {
                BiConsumer entry;
                BiConsumer biConsumer = entry = this.replace ? replaceMap : addMap;
                if (key.comp_814()) {
                    Optional.ofNullable((Collection)tagLookup.get(key.comp_813())).ifPresentOrElse(holders -> holders.forEach(holder -> entry.accept(holder, value)), () -> LOGGER.error("Cannot parse Tag with Id for {}: {}", (Object)description, (Object)key.comp_813()));
                } else {
                    this.registry.method_55841(key.comp_813()).ifPresentOrElse(holder -> entry.accept(holder, value), () -> LOGGER.error("Cannot parse Holder with Id for {}}: {}", (Object)description, (Object)key.comp_813()));
                }
            });
        }
    }
}

