/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform.services;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.IHamsterWheelEnergyStorage;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.capability.CustomEquipCapability;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.capability.ThrowableItemCapability;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3542;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractCapabilityManger
extends class_4309 {
    public static final String PATH = "clay_soldiers";
    public static final String FILE_NAME = "capabilities";
    private static final EnumMap<Types, Map<class_1792, EnabledHolder>> ENABLED_MAP = new EnumMap(Types.class);
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final Codec<Boolean> ENABLED_CODEC = Codec.STRING.comapFlatMap(s -> {
        if (s.equals("enabled")) {
            return DataResult.success((Object)true);
        }
        if (s.equals("disabled")) {
            return DataResult.success((Object)false);
        }
        return DataResult.error(() -> "Cannot parse %s as enabled/disabled".formatted(s));
    }, b -> b != false ? "enabled" : "disabled");
    private static final Decoder<Map<Types, Map<class_1792, Boolean>>> DECODER = Codec.unboundedMap(Types.CODEC, (Codec)Codec.unboundedMap((Codec)class_7923.field_41178.method_39673(), ENABLED_CODEC));

    protected AbstractCapabilityManger() {
        super(new Gson(), PATH);
    }

    @Nullable
    public BiFunction<class_1799, SoldierHoldableEffect, CustomEquipCapability> getCustomEquip(class_1799 stack) {
        return this.ifEnabledOrNull(Types.EQUIP, stack, CustomEquipCapability.CUSTOM_EQUIP_MAP.get(stack.method_7909()));
    }

    @Nullable
    public @Nullable BiFunction<class_1799, @Nullable SoldierHoldableEffect, ThrowableItemCapability> getThrowableItem(class_1799 stack) {
        return this.ifEnabledOrNull(Types.THROW, stack, ThrowableItemCapability.THROWABLE_ITEM_MAP.get(stack.method_7909()));
    }

    public abstract IHamsterWheelEnergyStorage createEnergyStorage(HamsterWheelBlockEntity var1);

    @Nullable
    private <T> T ifEnabledOrNull(Types type, class_1799 stack, T cap) {
        return (T)(Objects.requireNonNullElse(ENABLED_MAP.get((Object)type).get(stack.method_7909()), new EnabledHolder()).isEnabled() ? cap : null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ENABLED_MAP.forEach((type, status) -> {
            builder.append(type.serializedName);
            builder.append("{ Enabled: ");
            builder.append(status.entrySet().stream().filter(entry -> ((EnabledHolder)entry.getValue()).isEnabled()).map(Map.Entry::getKey).toList());
            builder.append(", Disabled: ");
            builder.append(status.entrySet().stream().filter(entry -> ((EnabledHolder)entry.getValue()).isDisabled()).map(Map.Entry::getKey).toList());
            builder.append("} ");
        });
        return builder.toString();
    }

    public abstract IBlockCache<IBlockStorageAccess> create(class_3218 var1, class_2338 var2);

    public abstract IBlockCache<BlueprintRequestHandler> createBlueprint(class_3218 var1, class_2338 var2);

    public abstract IBlockCache<AssignablePoiCapability> createPoiCache(class_3218 var1, class_2338 var2);

    protected void apply(Map<class_2960, JsonElement> jsonElementMap, class_3300 resourceManager, class_3695 profilerFiller) {
        AbstractCapabilityManger.registerCapabilities();
        jsonElementMap.forEach((path, jsonElement) -> {
            if (path.method_12832().equals(FILE_NAME)) {
                DECODER.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).ifSuccess(AbstractCapabilityManger::updateCapabilityStatus).ifError(err -> LOGGER.error(err.message()));
            }
        });
        AbstractCapabilityManger.finalizeCapStatuses(false);
    }

    public static void setForClient(Map<Types, Map<class_1792, Boolean>> map) {
        ENABLED_MAP.putAll(Map.of(Types.THROW, new HashMap(), Types.EQUIP, new HashMap()));
        map.forEach((types, itemBooleanMap) -> {
            Map<class_1792, EnabledHolder> typeMap = ENABLED_MAP.get(types);
            itemBooleanMap.forEach((item, enabled) -> typeMap.put((class_1792)item, EnabledHolder.createImmutable(enabled)));
        });
        AbstractCapabilityManger.finalizeCapStatuses(true);
    }

    private static void finalizeCapStatuses(boolean client) {
        ENABLED_MAP.forEach((type, status) -> {
            status.values().forEach(EnabledHolder::makeImmutable);
            LOGGER.info("Disabled {} Capabilities on {} for: {}", new Object[]{type.serializedName, client ? "Client" : "Server", status.entrySet().stream().filter(entry -> ((EnabledHolder)entry.getValue()).isDisabled()).map(Map.Entry::getKey).toList()});
        });
    }

    public static Map<Types, Map<class_1792, Boolean>> getEnabledMap() {
        EnumMap<Types, Map<class_1792, Boolean>> map = new EnumMap<Types, Map<class_1792, Boolean>>(Types.class);
        ENABLED_MAP.forEach((type, enMap) -> {
            HashMap enabledMap = new HashMap(enMap.size());
            enMap.forEach((item, enabledHolder) -> enabledMap.put(item, enabledHolder.isEnabled()));
            map.put((Types)((Object)type), enabledMap);
        });
        return map;
    }

    private static void registerCapabilities() {
        for (Types type : Types.values()) {
            ENABLED_MAP.put(type, new HashMap());
        }
        Map<class_1792, EnabledHolder> equipMap = ENABLED_MAP.get((Object)Types.EQUIP);
        CustomEquipCapability.CUSTOM_EQUIP_MAP.keySet().forEach(itemSupplier -> equipMap.put(itemSupplier.method_8389(), new EnabledHolder()));
        Map<class_1792, EnabledHolder> throwMap = ENABLED_MAP.get((Object)Types.THROW);
        ThrowableItemCapability.THROWABLE_ITEM_MAP.keySet().forEach(itemSupplier -> throwMap.put(itemSupplier.method_8389(), new EnabledHolder()));
    }

    private static void updateCapabilityStatus(Map<Types, Map<class_1792, Boolean>> enabledMap) {
        enabledMap.forEach((type, newMap) -> {
            Map<class_1792, EnabledHolder> map = ENABLED_MAP.get(type);
            newMap.forEach((item, enabledBool) -> {
                if (map.containsKey(item)) {
                    ((EnabledHolder)map.get(item)).and((boolean)enabledBool);
                } else {
                    LOGGER.error("Tried to {} Capability for an {}, but {} has no Capability", new Object[]{enabledBool != false ? "enable" : "disable", item, item});
                }
            });
        });
    }

    public static enum Types implements class_3542
    {
        EQUIP("equip"),
        THROW("throwable");

        private static final Codec<Types> CODEC;
        private final String serializedName;

        private Types(String serializedName) {
            this.serializedName = serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(Types::values);
        }
    }

    private static class EnabledHolder {
        private boolean enabled = true;
        private boolean immutable = false;

        private EnabledHolder() {
        }

        public void and(boolean enabled) {
            if (this.immutable) {
                throw new UnsupportedOperationException("Cannot change the value of an Immutable EnabledHolder");
            }
            this.enabled = this.enabled && enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isDisabled() {
            return !this.enabled;
        }

        public static EnabledHolder createImmutable(boolean enabled) {
            EnabledHolder enabledHolder = new EnabledHolder();
            enabledHolder.enabled = enabled;
            enabledHolder.makeImmutable();
            return enabledHolder;
        }

        public void makeImmutable() {
            this.immutable = true;
        }
    }
}

