/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.platform.services;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseItemMap;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseWearableProperties;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IDataMapGetter {
    @Nullable
    public SoldierHoldableEffect getEffect(class_1799 var1);

    @Nullable
    public SoldierHoldableEffect getEffect(class_1792 var1);

    @Nullable
    public SoldierMultiWearable getArmor(class_1799 var1);

    @Nullable
    public SoldierPoi getItemPoi(class_1799 var1);

    @Nullable
    public SoldierPoi getItemPoi(class_1792 var1);

    @Nullable
    public SoldierPoi getBlockPoi(class_2248 var1);

    @Nullable
    default public SoldierPoi getBlockPoi(class_1799 stack) {
        return this.getBlockPoi(stack.method_7909());
    }

    @Nullable
    default public SoldierPoi getBlockPoi(class_1792 item) {
        SoldierPoi soldierPoi;
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            soldierPoi = this.getBlockPoi(blockItem.method_7711());
        } else {
            soldierPoi = null;
        }
        return soldierPoi;
    }

    default public ClayHorseWearableProperties getHorseArmor(class_1792 item) {
        return ClayHorseItemMap.get(item);
    }

    @Nullable
    public SoldierVehicleProperties getVehicleProperties(class_1299<?> var1);

    @NotNull
    public List<class_1792> getHoldableEffectForSlot(SoldierEquipmentSlot var1);

    public static <T> void warnHoldable(Map<T, SoldierHoldableEffect> dataMap, BiPredicate<T, class_6862<class_1792>> isTagged) {
        dataMap.forEach((k, effect) -> {
            effect.getRemovalConditions().forEach(r -> {
                if (r.getChance() <= 0.0f) {
                    ClaySoldiersCommon.LOGGER.warn("DataMap: {} has a RemovalCondition({}) with chance 0", k, (Object)r.getDisplayName().getString());
                }
            });
            if (!isTagged.test(k, ModTags.Items.SOLDIER_HOLDABLE)) {
                ClaySoldiersCommon.LOGGER.warn("DataMap: {} is not tagged with {}", k, ModTags.Items.SOLDIER_HOLDABLE);
            }
        });
    }

    public static <T> Map<SoldierEquipmentSlot, List<class_1792>> createBySlotMap(Map<T, SoldierHoldableEffect> dataMap, Function<T, class_1792> keyToItem) {
        EnumMap<SoldierEquipmentSlot, List<class_1792>> map = new EnumMap<SoldierEquipmentSlot, List<class_1792>>(SoldierEquipmentSlot.class);
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            map.put(slot, new ArrayList());
        }
        dataMap.forEach((k, effect) -> effect.slots().forEach(slot -> ((List)map.get(slot)).add((class_1792)keyToItem.apply(k))));
        return map;
    }
}

