/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldieritemtypes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.soldieritemtypes.Generator;
import net.bumblebee.claysoldiers.soldieritemtypes.ItemGenerator;
import net.bumblebee.claysoldiers.soldieritemtypes.WeightedItem;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class SoldierItemType {
    public static final Codec<SoldierItemType> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").forGetter(s -> s.tag), (App)ModRegistries.ITEM_GENERATORS_REGISTRY.method_39673().fieldOf("generator").forGetter(s -> s.generator), (App)Codec.STRING.optionalFieldOf("name", (Object)"").forGetter(s -> s.name)).apply((Applicative)in, SoldierItemType::new));
    public static final String LANG = "clay_soldier_item_type";
    private static Runnable postTagLoad = () -> {};
    private static List<Generator> types;
    private final class_6862<class_1792> tag;
    private final ItemGenerator generator;
    private List<WeightedItem> available;
    @Nullable
    private String descriptionId;
    private final String name;

    public SoldierItemType(class_6862<class_1792> tag, ItemGenerator generator) {
        this(tag, generator, "");
    }

    public SoldierItemType(class_6862<class_1792> tag, ItemGenerator generator, String name) {
        this.tag = tag;
        this.generator = generator;
        this.name = name;
    }

    public void onTagLoad(Function<class_6862<class_1792>, Optional<class_6885.class_6888<class_1792>>> tagGetter) {
        Optional<class_6885.class_6888<class_1792>> opt = tagGetter.apply(this.tag);
        opt.ifPresentOrElse(holderSet -> {
            this.available = holderSet.method_40239().map(h -> new WeightedItem((class_1792)h.comp_349())).toList();
        }, () -> {
            this.available = List.of();
        });
    }

    public void afterDataMapLoad() {
        if (this.available == null) {
            throw new IllegalStateException("Cannot complete SoldierItemType before tags are loaded");
        }
        this.available = this.available.stream().filter(w -> w.finalizeWeight() > 0.0f).toList();
    }

    public boolean isEmpty() {
        return this.available.isEmpty();
    }

    public static void postTagLoad(Stream<SoldierItemType> all) {
        types = all.filter(s -> !s.available.isEmpty() && s.generator.limitedBy() != ItemGenerator.Limit.ZERO).map(SoldierItemType::asGenerator).toList();
        postTagLoad.run();
    }

    public static void setTagLoadCallback(Runnable runnable) {
        postTagLoad = runnable;
    }

    private Generator asGenerator() {
        return new Generator(){

            @Override
            public class_2371<class_1799> generateForTag(int count, class_5819 random) {
                return SoldierItemType.this.generator.generateForTag(SoldierItemType.this.available, count, random);
            }

            @Override
            public ItemGenerator.Limit limitedBy() {
                return SoldierItemType.this.generator.limitedBy();
            }
        };
    }

    public class_2371<class_1799> getItems(class_5819 random, int count) {
        if (this.available == null || types == null) {
            throw new IllegalStateException("Tried to generate items before tag loading");
        }
        return this.generator.generate(this.available, count, random, types);
    }

    public String toString() {
        return "SoldierItemType(%s)[%s]".formatted(this.generator, this.available != null ? Integer.valueOf(this.available.size()) : "null");
    }

    public class_2561 getDisplayName() {
        if (!this.name.isEmpty()) {
            return class_2561.method_43470((String)this.name);
        }
        return this.descriptionId != null ? class_2561.method_43471((String)this.descriptionId) : class_2561.method_43470((String)"[unregistered]");
    }

    public void onRegister(class_2960 id) {
        this.descriptionId = class_156.method_646((String)LANG, (class_2960)id);
    }
}

