/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import java.util.Comparator;
import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithBlock;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithSource;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class FindNearestPoiGoal
extends class_1352 {
    private static final int DEFAULT_RANDOM_INTERVAL = 60;
    private static final int SEARCH_RANGE = 10;
    private static final int VERTICAL_SEARCH_RANGE = 4;
    private static final int VERTICAL_SEARCH_START = 0;
    protected final int randomInterval;
    private final AbstractClaySoldierEntity clayMob;
    @Nullable
    private SoldierPoiWithSource<?> target = null;

    public FindNearestPoiGoal(AbstractClaySoldierEntity clayMob, int randomInterval) {
        this.clayMob = clayMob;
        this.randomInterval = randomInterval;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public FindNearestPoiGoal(AbstractClaySoldierEntity clayMob) {
        this(clayMob, 60);
    }

    public boolean method_6264() {
        if (this.clayMob.method_42148()) {
            return false;
        }
        if (this.randomInterval > 0 && this.clayMob.method_59922().method_43048(this.randomInterval) != 0) {
            return false;
        }
        this.findNearestPoi();
        return this.target != null;
    }

    public boolean method_6266() {
        return !this.clayMob.method_5942().method_6357() && !this.clayMob.method_42148();
    }

    public void method_6269() {
        assert (this.target != null);
        this.target.startPath(this.clayMob.method_5942());
    }

    public void method_6270() {
        assert (this.target != null);
        this.target.performEffect(this.clayMob);
        this.target = null;
        this.clayMob.method_5942().method_6340();
        super.method_6270();
    }

    private void findNearestPoi() {
        SoldierPoiWithSource itemPoi = this.clayMob.method_37908().method_18467(class_1542.class, this.getTargetSearchArea(this.getFollowDistance())).stream().map(this::getPoiWithPos).filter(this::canUsePoi).min(this.sortDistance()).orElse(null);
        if (itemPoi != null) {
            this.target = itemPoi;
            return;
        }
        this.target = this.findNearestBlock();
    }

    private SoldierPoiWithSource<class_1542> getPoiWithPos(class_1542 entity) {
        return SoldierPoiWithSource.getPoiFromItem(entity);
    }

    protected class_238 getTargetSearchArea(double pTargetDistance) {
        return this.clayMob.method_5829().method_1009(pTargetDistance, 4.0, pTargetDistance);
    }

    private Comparator<SoldierPoiWithSource<class_1542>> sortDistance() {
        return (p1, p2) -> (int)(this.clayMob.method_5858((class_1297)p1.getSource()) - this.clayMob.method_5858((class_1297)p2.getSource()));
    }

    private double getFollowDistance() {
        return this.clayMob.method_45325(class_5134.field_23717);
    }

    private boolean canUsePoi(SoldierPoiWithSource<?> poi) {
        return poi.canPerformEffect(this.clayMob);
    }

    @Nullable
    protected SoldierPoiWithBlock findNearestBlock() {
        class_2338 blockpos = this.clayMob.method_24515();
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        int ySearch = 0;
        while (ySearch <= 4) {
            for (int l = 0; l < 10; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        SoldierPoiWithBlock poi;
                        blockpos$mutableblockpos.method_25504((class_2382)blockpos, i1, ySearch - 1, j1);
                        class_2680 state = this.clayMob.method_37908().method_8320((class_2338)blockpos$mutableblockpos);
                        if (!state.method_26215() && this.clayMob.method_18407((class_2338)blockpos$mutableblockpos) && this.canUsePoi(poi = new SoldierPoiWithBlock(state.method_26204(), (class_2338)blockpos$mutableblockpos))) {
                            return poi;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            ySearch = ySearch > 0 ? -ySearch : 1 - ySearch;
        }
        return null;
    }

    public boolean method_38846() {
        return true;
    }
}

