/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierpoi;

import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoiWithItem;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import org.jetbrains.annotations.Nullable;

public abstract class SoldierPoiWithSource<T> {
    @Nullable
    private final SoldierPoi poi;
    private final T source;

    public SoldierPoiWithSource(@Nullable SoldierPoi poi, T source) {
        this.poi = poi;
        this.source = source;
    }

    public static SoldierPoiWithSource<class_1542> getPoiFromItem(class_1542 itemEntity) {
        return new SoldierPoiWithItem(itemEntity);
    }

    @Nullable
    public SoldierPoi getPoi() {
        return this.poi;
    }

    public T getSource() {
        return this.source;
    }

    public void performEffect(AbstractClaySoldierEntity soldier) {
        if (this.poi != null && this.stillValid(soldier)) {
            this.poi.performEffect(soldier, this.createPoiSource(this.source));
            this.animateEffect(soldier);
            this.onUse(this.source, soldier);
        }
    }

    protected abstract ClayPoiSource createPoiSource(T var1);

    protected boolean stillValid(AbstractClaySoldierEntity soldier) {
        return true;
    }

    public abstract void animateEffect(ClayMobEntity var1);

    public boolean canPerformEffect(ClaySoldierInventoryQuery soldier) {
        if (this.poi == null) {
            return false;
        }
        return this.poi.canPerformEffect(soldier);
    }

    public abstract void startPath(class_1408 var1);

    public abstract void onUse(T var1, AbstractClaySoldierEntity var2);

    public String toString() {
        return "SoldierPoiWithSource{" + String.valueOf(this.poi) + ", " + String.valueOf(this.source) + "}";
    }
}

