/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties;

import java.util.Objects;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.UnitProperty;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import org.jetbrains.annotations.NotNull;

public class SoldierProperty<T> {
    private final SoldierPropertyType<T> type;
    private final T value;

    public SoldierProperty(@NotNull SoldierPropertyType<T> type, @NotNull T value) {
        this.type = type;
        this.value = value;
    }

    public static SoldierProperty<UnitProperty> unit(SoldierPropertyType<UnitProperty> unit) {
        return new SoldierProperty<UnitProperty>(unit, UnitProperty.INSTANCE);
    }

    @NotNull
    public T value() {
        return this.value;
    }

    @NotNull
    public SoldierPropertyType<T> type() {
        return this.type;
    }

    public SoldierProperty<T> createWithCombinedValues(@NotNull T other) {
        T result;
        try {
            result = this.type.combine(this.value, other);
        }
        catch (IllegalArgumentException e) {
            result = this.value;
            ClaySoldiersCommon.LOGGER.error("Tried combining to incompatible values {}, {}, using the first", this.value, other);
        }
        return new SoldierProperty<T>(this.type, result);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SoldierProperty that = (SoldierProperty)other;
        return this.type.equals(that.type);
    }

    public void streamEncode(class_9129 byteBuf) {
        this.type.streamEncode(byteBuf, this.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.type);
    }

    public boolean is(class_6862<SoldierPropertyType<?>> tagKey) {
        return this.type.is(tagKey);
    }

    public String toString() {
        return "SoldierProperty[" + String.valueOf(this.type) + ", " + String.valueOf(this.value) + "]";
    }
}

