/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class SoldierPropertyType<T>
implements ToIntFunction<T>,
ValueCombiner<T> {
    private final Codec<T> valueCodec;
    private final class_9139<class_9129, T> streamCodec;
    private final T defaultValue;
    private final ToIntFunction<T> toIntFunction;
    private final ValueCombiner<T> combiner;
    private class_6880.class_6883<SoldierPropertyType<?>> holder;
    @Nullable
    private String descriptionId;
    @Nullable
    private final BiFunction<String, T, List<class_2561>> customDisplayName;

    protected SoldierPropertyType(Codec<T> valueCodec, class_9139<class_9129, T> streamCodec, T defaultValue, ToIntFunction<T> toIntFunction, ValueCombiner<T> combiner, @Nullable BiFunction<String, T, List<class_2561>> customDisplayName) {
        this.valueCodec = valueCodec;
        this.streamCodec = streamCodec;
        this.defaultValue = defaultValue;
        this.toIntFunction = toIntFunction;
        this.combiner = combiner;
        this.customDisplayName = customDisplayName;
    }

    public Codec<T> getValueCodec() {
        return this.valueCodec;
    }

    public void streamEncode(class_9129 byteBuff, T value) {
        this.streamCodec.encode((Object)byteBuff, value);
    }

    public T streamDecode(class_9129 byteBuff) {
        return (T)this.streamCodec.decode((Object)byteBuff);
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int applyAsInt(T value) {
        return this.toIntFunction.applyAsInt(value);
    }

    @Override
    public T combine(T first, T second) {
        return this.combiner.combine(first, second);
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = class_156.method_646((String)"clay_soldier_property", (class_2960)this.getOrCreateReference().method_40237().method_29177());
        }
        return this.descriptionId;
    }

    public SoldierProperty<T> createProperty(T value) {
        return new SoldierProperty<T>(this, value);
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)this.getDescriptionId());
    }

    public List<class_2561> getDisplayNameWithValue(T value, @Nullable ClaySoldierInventoryQuery soldier) {
        if (this.customDisplayName == null) {
            return List.of(class_2561.method_43471((String)this.getDescriptionId()).method_27693(": " + String.valueOf(value)));
        }
        return this.customDisplayName.apply(this.getDescriptionId(), (String)value);
    }

    public String toString() {
        return ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.method_10221((Object)this).method_12832();
    }

    public boolean is(class_6862<SoldierPropertyType<?>> tag) {
        return this.getOrCreateReference().method_40220(tag);
    }

    private class_6880.class_6883<SoldierPropertyType<?>> getOrCreateReference() {
        if (this.holder == null) {
            this.holder = ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.method_40290(class_5321.method_29179(ModRegistries.SOLDIER_PROPERTY_TYPES, (class_2960)ModRegistries.SOLDIER_PROPERTY_TYPES_REGISTRY.method_10221((Object)this)));
        }
        return this.holder;
    }
}

