/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.combined;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicate;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicatePriority;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicates;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.bumblebee.claysoldiers.soldierproperties.combined.SoldierPropertyCombinedMap;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_5131;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoldierHoldablePropertiesCombiner
implements SoldierPropertyMapReader {
    private static final String TEAM_SLOT_NAME = "team";
    private static final String VEHICLES_SLOT_NAME = "vehicle";
    private static final String BASE_SLOT_NAME = "base";
    private final Map<SoldierEquipmentSlot, PredicatePropertiesPair> slotPropertyMap;
    private final ClaySoldierInventoryQuery inventory;
    private final class_5131 attributeMap;
    private PredicatePropertiesPair fromTeam = new PredicatePropertiesPair(ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), SoldierPropertyMap.EMPTY, "team");
    private PredicatePropertiesPair fromVehicle = new PredicatePropertiesPair(ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), SoldierPropertyMap.EMPTY, "vehicle");
    private PredicatePropertiesPair baseProperties = new PredicatePropertiesPair(ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), SoldierPropertyMap.EMPTY, "base");
    private final SoldierPropertyCombinedMap combinedPropertiesMap;

    public SoldierHoldablePropertiesCombiner(ClaySoldierInventoryQuery inventory, class_5131 attributeMap) {
        this.slotPropertyMap = new EnumMap<SoldierEquipmentSlot, PredicatePropertiesPair>(SoldierEquipmentSlot.class);
        this.combinedPropertiesMap = new SoldierPropertyCombinedMap();
        this.inventory = inventory;
        this.attributeMap = attributeMap;
    }

    public void addPropertyFromTeam(ClayMobTeam team) {
        if (this.fromTeam != null) {
            this.attributeMap.method_59935(this.fromTeam.attributesAsMultiMapHolder());
        }
        this.fromTeam = new PredicatePropertiesPair(null, team.getProperties(), TEAM_SLOT_NAME);
    }

    public void addVehicle(@NotNull SoldierVehicleProperties soldierProperties) {
        this.attributeMap.method_59935(this.fromVehicle.attributesAsMultiMapHolder());
        this.fromVehicle = new PredicatePropertiesPair(soldierProperties.predicate(), soldierProperties.properties(), VEHICLES_SLOT_NAME);
    }

    public void addBaseProperties(@NotNull SoldierPropertyMapReader properties) {
        this.attributeMap.method_59935(this.baseProperties.attributesAsMultiMapHolder());
        this.baseProperties = new PredicatePropertiesPair(ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), properties, BASE_SLOT_NAME);
    }

    public void addProperty(ClayPredicate<?> predicate, SoldierPropertyMap property, SoldierEquipmentSlot slot) {
        PredicatePropertiesPair pairPrev = this.slotPropertyMap.put(slot, new PredicatePropertiesPair(predicate, property, slot.method_15434()));
        if (pairPrev != null) {
            this.attributeMap.method_59935(pairPrev.attributesAsMultiMapHolder());
        }
    }

    public void removeProperty(SoldierEquipmentSlot slot) {
        PredicatePropertiesPair pair = this.slotPropertyMap.remove(slot);
        if (pair != null) {
            this.attributeMap.method_59935(pair.attributesAsMultiMapHolder());
        }
    }

    public void combine() {
        this.reset();
        this.testAndCombine();
    }

    private void reset() {
        this.combinedPropertiesMap.clear();
        for (PredicatePropertiesPair pair : this.slotPropertyMap.values()) {
            this.attributeMap.method_59935(pair.attributesAsMultiMapHolder());
        }
    }

    private void testAndCombine() {
        List<PredicatePropertiesPair> highPriorityCompleted = this.getAddedProperties().filter(l -> l.getPriority() == ClayPredicatePriority.HIGH).filter(l -> l.predicate.test(this.inventory)).toList();
        this.addTestedProperties(highPriorityCompleted);
        this.addTestedProperties(List.of(this.fromTeam, this.fromVehicle, this.baseProperties));
        List<PredicatePropertiesPair> restAll = this.getAddedProperties().filter(p -> p.getPriority() != ClayPredicatePriority.HIGH).toList();
        ArrayList<PredicatePropertiesPair> newlyTrue = new ArrayList<PredicatePropertiesPair>();
        do {
            this.addTestedProperties(newlyTrue);
            newlyTrue.clear();
            newlyTrue.addAll(restAll.stream().filter(p -> p.predicate.test(this.inventory)).toList());
            restAll = restAll.stream().filter(p -> !p.predicate.test(this.inventory)).toList();
        } while (!newlyTrue.isEmpty());
    }

    private Stream<PredicatePropertiesPair> getAddedProperties() {
        return this.slotPropertyMap.values().stream();
    }

    private void addTestedProperties(List<PredicatePropertiesPair> allReadyCompleted) {
        for (PredicatePropertiesPair pair : allReadyCompleted) {
            this.combinedPropertiesMap.combineMap(pair.properties());
            this.attributeMap.method_59932(pair.attributesAsMultiMapHolder());
        }
    }

    @Override
    public <T> SoldierProperty<T> getProperty(SoldierPropertyType<T> type) {
        return this.combinedPropertiesMap.getProperty(type);
    }

    @Override
    @Nullable
    public <T> T getValueOrNull(SoldierPropertyType<T> type) {
        return this.combinedPropertiesMap.getValueOrNull(type);
    }

    @Override
    public <T> boolean hasPropertyType(SoldierPropertyType<T> type) {
        return this.combinedPropertiesMap.hasPropertyType(type);
    }

    @Override
    @NotNull
    public Iterator<SoldierProperty<?>> iterator() {
        return this.combinedPropertiesMap.iterator();
    }

    public String toString() {
        return this.combinedPropertiesMap.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.combinedPropertiesMap.isEmpty();
    }

    private record PredicatePropertiesPair(ClayPredicate<?> predicate, SoldierPropertyMapReader properties, String slotName) {
        public ClayPredicatePriority getPriority() {
            return this.predicate.getPriority();
        }

        public Multimap<class_6880<class_1320>, class_1322> attributesAsMultiMapHolder() {
            Map baseMap = (Map)this.properties.getValueOrDfault(SoldierPropertyTypes.ATTRIBUTES.get());
            ArrayListMultimap multiMap = ArrayListMultimap.create((int)baseMap.size(), (int)1);
            baseMap.forEach((arg_0, arg_1) -> this.lambda$attributesAsMultiMapHolder$1((Multimap)multiMap, arg_0, arg_1));
            return multiMap;
        }

        private /* synthetic */ void lambda$attributesAsMultiMapHolder$1(Multimap multiMap, class_6880 h, List m) {
            m.forEach(mod -> multiMap.put((Object)h, (Object)new class_1322(mod.comp_2447().method_48331("_" + this.slotName), mod.comp_2449(), mod.comp_2450())));
        }
    }
}

