/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.serialization.Codec;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3542;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public enum AttackTypeProperty implements class_3542,
KeyableTranslatableProperty
{
    NORMAL("normal", true, true, true, AttackTypeProperty::shouldAttackClaySoldier, null),
    PACIFIST("pacifist", false, true, true, (s, t) -> false, class_124.field_1068),
    AGGRESSIVE("aggressive", true, false, false, AttackTypeProperty::canSeeTarget, class_124.field_1079),
    SUPPORT("support", false, true, true, AttackTypeProperty::healerPredicate, class_124.field_1060),
    KING("king", true, false, true, AttackTypeProperty::royaltyPredicate, class_124.field_1065),
    QUEEN("queen", true, false, true, AttackTypeProperty::royaltyPredicate, class_124.field_1075),
    ZOMBIE("zombie", true, false, false, AttackTypeProperty::shouldAttackClaySoldier, class_124.field_1077),
    VAMPIRE("vampire", true, false, false, AttackTypeProperty::shouldAttackClaySoldier, null){

        @Override
        public class_2583 getStyle() {
            return class_2583.field_24360.method_36139(0x660707);
        }

        @Override
        public class_2583 getAnimatedStyle(class_1309 livingEntity) {
            return class_2583.field_24360.method_36139(0x660707 + (AttackTypeProperty.triangleWave(livingEntity.field_6012, 48) << 16));
        }

        @Override
        public class_2561 getAnimatedDisplayName(class_1309 livingEntity) {
            return class_2561.method_43471((String)this.translatableKey()).method_27696(this.getAnimatedStyle(livingEntity));
        }
    }
    ,
    BOSS("boss", true, false, false, null, class_124.field_1068){

        @Override
        public boolean canAttack(AbstractClaySoldierEntity attacker, class_1309 target) {
            if (target.method_5864().method_20210(ModTags.EntityTypes.CLAY_BOSS)) {
                return false;
            }
            return target instanceof class_1657 || target instanceof ClayMobEntity;
        }

        @Override
        public class_2583 getAnimatedStyle(class_1309 livingEntity) {
            if (livingEntity instanceof ClayMobEntity) {
                ClayMobEntity clayMobEntity = (ClayMobEntity)livingEntity;
                return class_2583.field_24360.method_36139(clayMobEntity.getClayTeam().getColor(livingEntity, 0.0f));
            }
            return super.getAnimatedStyle(livingEntity);
        }

        @Override
        public class_2561 getAnimatedDisplayName(class_1309 livingEntity) {
            return class_2561.method_43471((String)this.translatableKey()).method_27696(this.getAnimatedStyle(livingEntity));
        }
    };

    private static AttackTypeProperty[] withOutBoss;
    public static final Codec<AttackTypeProperty> CODEC;
    public static final class_9139<class_2540, AttackTypeProperty> STREAM_CODEC;
    public static final ToIntFunction<AttackTypeProperty> TO_INT;
    public static final ValueCombiner<AttackTypeProperty> COMBINER;
    private final String serializedName;
    private final boolean fightsBack;
    private final boolean canBeRidden;
    private final boolean canBeRevived;
    private final ClaySoldierTargetPredicate targetPredicate;
    private final class_124 chatFormatting;

    private AttackTypeProperty(String serializedName, boolean fightsBack, boolean canBeRidden, boolean canBeRevived, ClaySoldierTargetPredicate targetPredicate, class_124 chatFormatting) {
        this.serializedName = serializedName;
        this.fightsBack = fightsBack;
        this.canBeRidden = canBeRidden;
        this.canBeRevived = canBeRevived;
        this.targetPredicate = targetPredicate;
        this.chatFormatting = chatFormatting;
    }

    public boolean fightsBack() {
        return this.fightsBack;
    }

    public boolean compatibleWith(AttackTypeProperty attackType) {
        return this == attackType || this == NORMAL || attackType == NORMAL;
    }

    public boolean isRoyalty() {
        return this == QUEEN || this == KING;
    }

    public boolean rideable() {
        return this.canBeRidden;
    }

    public boolean isSupportive() {
        return this == SUPPORT;
    }

    public boolean canWork() {
        return this == PACIFIST;
    }

    public boolean canBeRevived() {
        return this.canBeRevived;
    }

    public SpecialEffectCategory forType() {
        return this.isSupportive() ? SpecialEffectCategory.BENEFICIAL : SpecialEffectCategory.HARMFUL;
    }

    public String method_15434() {
        return this.serializedName;
    }

    public boolean canAttack(AbstractClaySoldierEntity attacker, class_1309 target) {
        if (!(target instanceof ClayMobEntity)) {
            return false;
        }
        ClayMobEntity clayMobEntity = (ClayMobEntity)target;
        return this.targetPredicate.canAttack(attacker, clayMobEntity);
    }

    private static boolean shouldAttackClaySoldier(AbstractClaySoldierEntity self, ClayMobEntity target) {
        AbstractClaySoldierEntity claySoldier;
        if (!AttackTypeProperty.canSeeTarget(self, target)) {
            return false;
        }
        if (target instanceof AbstractClaySoldierEntity && (claySoldier = (AbstractClaySoldierEntity)target).getAttackType() == AGGRESSIVE) {
            return true;
        }
        return self.shouldAttackTeamHolder(target);
    }

    private static boolean canSeeTarget(AbstractClaySoldierEntity self, ClayMobEntity target) {
        return !target.method_5767() || target.method_5851() || self.canSeeInvis();
    }

    private static boolean healerPredicate(AbstractClaySoldierEntity self, ClayMobEntity target) {
        AbstractClaySoldierEntity claySoldier;
        if (target instanceof AbstractClaySoldierEntity && (claySoldier = (AbstractClaySoldierEntity)target).getAttackType() == AGGRESSIVE) {
            return false;
        }
        return self.sameTeamAs((class_1297)target);
    }

    private static boolean royaltyPredicate(AbstractClaySoldierEntity self, ClayMobEntity target) {
        if (target instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldierEntity = (AbstractClaySoldierEntity)target;
            if (self.getAttackType() == soldierEntity.getAttackType()) {
                return true;
            }
        }
        if (self.getAttackType() == QUEEN) {
            return false;
        }
        return AttackTypeProperty.shouldAttackClaySoldier(self, target);
    }

    @Override
    public String translatableKey() {
        return "clay_soldier_property.csr.attack_type." + this.serializedName;
    }

    @Override
    public class_124 getFormat() {
        return this.chatFormatting;
    }

    @Override
    @Nullable
    public class_2561 getDisplayName() {
        return KeyableTranslatableProperty.super.getDisplayName();
    }

    @Nullable
    public class_2583 getAnimatedStyle(class_1309 livingEntity) {
        return this.getStyle();
    }

    private static int triangleWave(int tick, int max) {
        int period = 2 * max;
        int mod = tick % period;
        if (mod <= max) {
            return mod;
        }
        return period - mod;
    }

    private static AttackTypeProperty[] withOutBoss() {
        if (withOutBoss == null) {
            withOutBoss = new AttackTypeProperty[]{NORMAL, PACIFIST, AGGRESSIVE, SUPPORT, KING, QUEEN, ZOMBIE, VAMPIRE};
        }
        return withOutBoss;
    }

    static {
        CODEC = class_3542.method_28140(AttackTypeProperty::withOutBoss);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(AttackTypeProperty.class);
        TO_INT = Enum::ordinal;
        COMBINER = (t1, t2) -> {
            if (!t1.compatibleWith((AttackTypeProperty)t2)) {
                throw new IllegalArgumentException("Cannot Combine Attack Type %s with %s".formatted(t1, t2));
            }
            return t1 != NORMAL ? t1 : t2;
        };
    }

    @FunctionalInterface
    public static interface ClaySoldierTargetPredicate {
        public boolean canAttack(AbstractClaySoldierEntity var1, ClayMobEntity var2);
    }
}

