/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class DamageBlock {
    public static final DamageBlock EMPTY = new DamageBlock(0.0f, 0.0f, false){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    public static final ValueCombiner<DamageBlock> COMBINER = CombinedDamageBlock::new;
    public static final ToIntFunction<DamageBlock> TO_INT = d -> d.blockAmount > 0.0f && d.blockChance > 0.0f ? 1 : 0;
    public static final Codec<DamageBlock> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_5699.field_34387.fieldOf("chance").forGetter(d -> Float.valueOf(d.blockChance)), (App)class_5699.field_34387.fieldOf("amount").forGetter(d -> Float.valueOf(d.blockAmount)), (App)Codec.BOOL.optionalFieldOf("pierceable", (Object)true).forGetter(d -> d.pierceable)).apply((Applicative)in, DamageBlock::new));
    public static final class_9139<ByteBuf, DamageBlock> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48552, d -> Float.valueOf(d.blockChance), (class_9139)class_9135.field_48552, d -> Float.valueOf(d.blockAmount), (class_9139)class_9135.field_48547, d -> d.pierceable, DamageBlock::new);
    public static final BiFunction<String, DamageBlock, List<class_2561>> DISPLAY_NAME_CREATOR = (key, value) -> {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)class_2561.method_43471((String)key).method_27693(":"));
        value.appendNameToList(list);
        return list;
    };
    private final float blockChance;
    private final float blockAmount;
    private final boolean pierceable;

    public DamageBlock(float blockChance, float blockAmount, boolean pierceable) {
        this.blockChance = blockChance;
        this.blockAmount = blockAmount;
        this.pierceable = pierceable;
    }

    public DamageBlock(float blockChance, float blockAmount) {
        this(blockChance, blockAmount, true);
    }

    public float blocked(class_5819 random, float damage, boolean isPiercing) {
        if (this.blockChance <= 0.0f || this.blockAmount <= 0.0f) {
            return damage;
        }
        if ((!isPiercing || this.pierceable) && random.method_43057() > this.blockChance) {
            float newDamage = damage - this.blockAmount;
            return newDamage < 0.0f ? 0.0f : newDamage;
        }
        return damage;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        if (this.blockAmount <= 0.0f || this.blockChance <= 0.0f) {
            return "DamageBlock(Empty)";
        }
        return "DamageBlock(Chance: %f, Amount: %f)".formatted(Float.valueOf(this.blockChance), Float.valueOf(this.blockAmount));
    }

    public String asString() {
        if (this.blockAmount <= 0.0f || this.blockChance <= 0.0f) {
            return "";
        }
        return " (Chance: %.2f Amount: %.2f)".formatted(Float.valueOf(this.blockChance), Float.valueOf(this.blockAmount));
    }

    protected void appendNameToList(List<class_2561> tooltip) {
        if (this.blockAmount <= 0.0f || this.blockChance <= 0.0f) {
            return;
        }
        tooltip.add((class_2561)class_5244.method_48320().method_27693(this.asString()).method_27692(class_124.field_1063));
    }

    private static class CombinedDamageBlock
    extends DamageBlock {
        private final DamageBlock damageBlock1;
        private final DamageBlock damageBlock2;

        public CombinedDamageBlock(DamageBlock damageBlock1, DamageBlock damageBlock2) {
            super(0.0f, 0.0f, false);
            this.damageBlock1 = damageBlock1;
            this.damageBlock2 = damageBlock2;
        }

        @Override
        public float blocked(class_5819 random, float damage, boolean isPiercing) {
            float newDamage = this.damageBlock1.blocked(random, damage, isPiercing);
            return this.damageBlock2.blocked(random, newDamage, isPiercing);
        }

        @Override
        public String toString() {
            if (this.damageBlock1.isEmpty()) {
                return this.damageBlock2.toString();
            }
            return String.valueOf(this.damageBlock1) + (String)(this.damageBlock2.isEmpty() ? "" : ", " + String.valueOf(this.damageBlock2));
        }

        @Override
        protected void appendNameToList(List<class_2561> tooltip) {
            this.damageBlock1.appendNameToList(tooltip);
            this.damageBlock2.appendNameToList(tooltip);
        }
    }
}

