/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.class_1297;
import net.minecraft.class_1671;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_9139;
import net.minecraft.class_9284;
import net.minecraft.class_9334;

public interface IEvacuationProperty {
    public static final String EVACUATION_PROPERTY_PREFIX = "clay_soldier_property.csr..evacuation.";
    public static final Codec<IEvacuationProperty> CODEC = EvacuationProperty.CODEC.flatComapMap(e -> e, IEvacuationProperty::decode);
    public static final class_9139<ByteBuf, IEvacuationProperty> STREAM_CODEC = new class_9139<ByteBuf, IEvacuationProperty>(){

        public IEvacuationProperty decode(ByteBuf byteBuf) {
            return EvacuationProperty.values()[byteBuf.readByte()];
        }

        public void encode(ByteBuf o, IEvacuationProperty iEvacuationProperty) {
            o.writeByte(Math.max(iEvacuationProperty.id(), 0));
        }
    };
    public static final IEvacuationProperty NONE = EvacuationProperty.NONE;
    public static final IEvacuationProperty FIREWORK = EvacuationProperty.FIREWORK;
    public static final ValueCombiner<IEvacuationProperty> COMBINER = (first, second) -> {
        if (first instanceof CombinedEvacuationProperty) {
            CombinedEvacuationProperty combined1 = (CombinedEvacuationProperty)first;
            return combined1.append((IEvacuationProperty)second);
        }
        if (second instanceof CombinedEvacuationProperty) {
            CombinedEvacuationProperty comnined2 = (CombinedEvacuationProperty)second;
            return comnined2.append((IEvacuationProperty)first);
        }
        return new CombinedEvacuationProperty((IEvacuationProperty)first, (IEvacuationProperty)second);
    };
    public static final BiFunction<String, IEvacuationProperty, List<class_2561>> DISPLAY_NAME_GETTER = (key, property) -> {
        if (property instanceof CombinedEvacuationProperty) {
            return List.of(class_2561.method_43471((String)key), property.getDisplayName());
        }
        return List.of(property.getDisplayName());
    };

    public void evacuate(class_3218 var1, ClayMobEntity var2);

    public int id();

    public class_2561 getDisplayName();

    public boolean isEmpty();

    public int toInt();

    private static DataResult<EvacuationProperty> decode(IEvacuationProperty iEvacuationProperty) {
        if (iEvacuationProperty.id() < 0 || iEvacuationProperty.id() >= EvacuationProperty.values().length) {
            return DataResult.error(() -> "Cannot Decode EvacuationProperty with id " + iEvacuationProperty.id());
        }
        return DataResult.success((Object)EvacuationProperty.values()[iEvacuationProperty.id()]);
    }

    public static enum EvacuationProperty implements class_3542,
    IEvacuationProperty
    {
        NONE("none", (s, c) -> {}),
        FIREWORK("firework", EvacuationProperty::evacuateFirework);

        public static final Codec<EvacuationProperty> CODEC;
        private final String serializedName;
        private final BiConsumer<class_3218, ClayMobEntity> evacuationFunction;

        private EvacuationProperty(String serializedName, BiConsumer<class_3218, ClayMobEntity> evacuationFunction) {
            this.serializedName = serializedName;
            this.evacuationFunction = evacuationFunction;
        }

        @Override
        public void evacuate(class_3218 level, ClayMobEntity entity) {
            this.evacuationFunction.accept(level, entity);
        }

        private static void evacuateFirework(class_3218 level, ClayMobEntity shooter) {
            shooter.method_5848();
            class_1799 stack = class_1802.field_8639.method_7854();
            stack.method_57379(class_9334.field_49616, (Object)new class_9284(1, List.of()));
            class_1671 fireworkrocketentity = new class_1671((class_1937)level, (class_1297)shooter, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), stack);
            level.method_8649((class_1297)fireworkrocketentity);
            shooter.method_5873((class_1297)fireworkrocketentity, true);
        }

        @Override
        public int id() {
            return this.ordinal();
        }

        @Override
        public int toInt() {
            return 1;
        }

        @Override
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)this.translatableKey());
        }

        public String translatableKey() {
            return IEvacuationProperty.EVACUATION_PROPERTY_PREFIX + this.serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        @Override
        public boolean isEmpty() {
            return this == NONE;
        }

        static {
            CODEC = class_3542.method_28140(EvacuationProperty::values);
        }
    }

    public static class CombinedEvacuationProperty
    implements IEvacuationProperty {
        private final List<IEvacuationProperty> evacs = new ArrayList<IEvacuationProperty>();

        public CombinedEvacuationProperty(IEvacuationProperty first, IEvacuationProperty second) {
            this.evacs.add(first);
            this.evacs.add(second);
        }

        private IEvacuationProperty append(IEvacuationProperty property) {
            if (property instanceof CombinedEvacuationProperty) {
                CombinedEvacuationProperty combined = (CombinedEvacuationProperty)property;
                this.evacs.addAll(combined.evacs);
            } else {
                this.evacs.add(property);
            }
            return this;
        }

        @Override
        public void evacuate(class_3218 level, ClayMobEntity shooter) {
            this.evacs.getFirst().evacuate(level, shooter);
        }

        @Override
        public int id() {
            return -1;
        }

        @Override
        public class_2561 getDisplayName() {
            class_5250 start = class_2561.method_43470((String)"[");
            for (int i = 0; i < this.evacs.size(); ++i) {
                if (i != 0) {
                    start.method_10852((class_2561)class_2561.method_43470((String)", "));
                }
                start.method_10852(this.evacs.get(i).getDisplayName());
            }
            start.method_10852((class_2561)class_2561.method_43470((String)"]"));
            return start;
        }

        @Override
        public int toInt() {
            return this.evacs.size();
        }

        @Override
        public boolean isEmpty() {
            return this.evacs.isEmpty();
        }
    }
}

