/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record WraithProperty(int duration, float damage, List<SpecialAttack<?>> attackModifiers) implements ITranslatableProperty
{
    public static final WraithProperty EMPTY = new WraithProperty(-1, 0.0f, List.of());
    public static final ToIntFunction<WraithProperty> TO_INT = WraithProperty::duration;
    public static final ValueCombiner<WraithProperty> COMBINER = WraithProperty::combine;
    public static final Codec<WraithProperty> CODEC = RecordCodecBuilder.create(in -> in.group((App)CodecUtils.TIME_CODEC.fieldOf("duration").forGetter(WraithProperty::duration), (App)class_5699.field_34387.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(WraithProperty::damage), (App)SpecialAttack.LIST_CODEC.optionalFieldOf("attack_effect", List.of()).forGetter(WraithProperty::attackModifiers)).apply((Applicative)in, WraithProperty::new));
    public static final class_9139<class_9129, WraithProperty> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48550, WraithProperty::duration, (class_9139)class_9135.field_48552, WraithProperty::damage, (class_9139)SpecialAttack.STREAM_CODEC.method_56433(class_9135.method_56363()), WraithProperty::attackModifiers, WraithProperty::new);

    private WraithProperty combine(WraithProperty other) {
        return new WraithProperty(Math.max(this.duration, other.duration), Math.max(this.damage, other.damage), SpecialAttack.COMBINER.combine(this.attackModifiers, other.attackModifiers));
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)("Wraith: " + this.duration + "s")).method_54663(261343);
    }

    public Consumer<ClayWraithEntity> onSpawnEffect() {
        return wraith -> {
            wraith.method_6127().method_59932((Multimap)Multimaps.forMap(Map.of(class_5134.field_23721, new class_1322(class_2960.method_60655((String)"csr", (String)"bonus_damage"), (double)this.damage, class_1322.class_1323.field_6328))));
            wraith.setAttackFunctions(this.attackModifiers);
        };
    }
}

