/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.effectimmunity.EffectImmunityType;
import net.bumblebee.claysoldiers.soldierproperties.translation.EffectTranslatableProperty;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.minecraft.class_1291;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class EffectImmunityMap
implements Iterable<ITranslatableProperty> {
    public static final Codec<EffectImmunityMap> CODEC = Codec.unboundedMap((Codec)class_7923.field_41174.method_40294(), EffectImmunityType.CODEC).xmap(EffectImmunityMap::fromMap, EffectImmunityMap::fromImmunityMap);
    private static final class_9139<class_9129, Map<class_6880<class_1291>, EffectImmunityType>> MAP_STREAM_CODEC = class_9135.method_56377(HashMap::new, (class_9139)class_1291.field_51934, EffectImmunityType.STREAM_CODEC);
    public static final class_9139<class_9129, EffectImmunityMap> STREAM_CODEC = MAP_STREAM_CODEC.method_56432(EffectImmunityMap::new, EffectImmunityMap::fromImmunityMap);
    public static final EffectImmunityMap EMPTY = new EffectImmunityMap();
    public static final ToIntFunction<EffectImmunityMap> TO_INT = EffectImmunityMap::size;
    public static final ValueCombiner<EffectImmunityMap> COMBINER = EffectImmunityMap::combine;
    private final Map<class_6880<class_1291>, EffectImmunityType> immuneEffects;

    public EffectImmunityMap() {
        this.immuneEffects = new HashMap<class_6880<class_1291>, EffectImmunityType>();
    }

    public EffectImmunityMap(Map<class_6880<class_1291>, EffectImmunityType> effectMap) {
        this.immuneEffects = new HashMap<class_6880<class_1291>, EffectImmunityType>(effectMap);
    }

    private static EffectImmunityMap combine(EffectImmunityMap map1, EffectImmunityMap map2) {
        if (map1.isEmpty()) {
            return map2;
        }
        if (map2.isEmpty()) {
            return map1;
        }
        EffectImmunityMap combined = new EffectImmunityMap(map1.immuneEffects);
        combined.putAll(map2.immuneEffects);
        return combined;
    }

    private static EffectImmunityMap fromMap(Map<class_6880<class_1291>, EffectImmunityType> immuneEffects) {
        return new EffectImmunityMap(immuneEffects);
    }

    private static Map<class_6880<class_1291>, EffectImmunityType> fromImmunityMap(EffectImmunityMap map) {
        return map.immuneEffects;
    }

    public void put(class_6880<class_1291> effect, EffectImmunityType newType) {
        this.immuneEffects.compute(effect, (key, value) -> {
            if (value == null) {
                return newType;
            }
            return value == newType ? value : null;
        });
    }

    private void putAll(Map<class_6880<class_1291>, EffectImmunityType> effects) {
        effects.forEach(this::put);
    }

    public boolean isImmune(class_6880<class_1291> mobEffect) {
        return this.immuneEffects.get(mobEffect) == EffectImmunityType.IMMUNE;
    }

    public boolean isPersistent(class_6880<class_1291> mobEffect) {
        return this.immuneEffects.get(mobEffect) == EffectImmunityType.PERSISTENT;
    }

    protected int size() {
        return this.immuneEffects.size();
    }

    protected boolean isEmpty() {
        return this.immuneEffects.isEmpty();
    }

    @Override
    public Iterator<ITranslatableProperty> iterator() {
        return this.immuneEffects.entrySet().stream().map(EffectImmunityMap::create).iterator();
    }

    public String toString() {
        return "EffectImmunityMap" + String.valueOf(this.immuneEffects);
    }

    private static ITranslatableProperty create(Map.Entry<class_6880<class_1291>, EffectImmunityType> mapEntry) {
        return ITranslatableProperty.keyValuePair(EffectTranslatableProperty.create(mapEntry.getKey()), mapEntry.getValue());
    }
}

