/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.revive;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveResult;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ReviveProperty
implements ITranslatableProperty {
    public static final Codec<ReviveProperty> CODEC = RecordCodecBuilder.create(in -> in.group((App)ReviveType.CODEC.fieldOf("type").forGetter(s -> s.reviveType), (App)Codec.INT.fieldOf("priority").forGetter(s -> s.priority), (App)CodecUtils.CHANCE_CODEC.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(s -> Float.valueOf(s.reviveChance)), (App)CodecUtils.TIME_CODEC.optionalFieldOf("cooldown", (Object)0).forGetter(s -> s.cooldown)).apply((Applicative)in, ReviveProperty::new));
    public static final class_9139<class_9129, ReviveProperty> STREAM_CODEC = class_9139.method_56905(ReviveType.STREAM_CODEC, s -> s.reviveType, (class_9139)class_9135.field_48550, s -> s.priority, (class_9139)class_9135.field_48552, s -> Float.valueOf(s.reviveChance), (class_9139)class_9135.field_48550, s -> s.cooldown, ReviveProperty::new);
    public static final ReviveProperty EMPTY = new ReviveProperty(ReviveType.NONE, 0){

        @Override
        public ReviveProperty append(ReviveProperty property) {
            return property;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    public static final ToIntFunction<ReviveProperty> TO_INT = r -> r.equals(EMPTY) ? 0 : 1;
    public static final ValueCombiner<ReviveProperty> COMBINER = ReviveProperty::append;
    private final int priority;
    private final ReviveType reviveType;
    private final float reviveChance;
    private final int cooldown;

    public ReviveProperty(ReviveType reviveType, int priority) {
        this(reviveType, priority, 1.0f, 0);
    }

    public ReviveProperty(ReviveType reviveType, int priority, float chance, int cooldown) {
        this.priority = priority;
        this.reviveType = reviveType;
        this.reviveChance = chance;
        this.cooldown = cooldown;
    }

    public ReviveResult reviveSoldier(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        if (!reviver.isReviveTypeOffCooldown(this.reviveType)) {
            return ReviveResult.FAIL;
        }
        if (this.reviveChance <= 0.0f || level.method_8409().method_43057() > this.reviveChance) {
            return ReviveResult.FAIL;
        }
        ReviveResult result = this.reviveType.revive(level, toRevive, reviver);
        if (result.success() && this.cooldown > 0) {
            reviver.setReviveOnCooldown(this.reviveType, this.cooldown);
        }
        return result;
    }

    public boolean canRevive() {
        return !this.isEmpty();
    }

    @Override
    @Nullable
    public class_2561 getDisplayName() {
        return this.reviveType.getDisplayName();
    }

    @Nullable
    public class_2561 getDisplayPrefix() {
        class_2561 prefix = this.reviveType.getDisplayPrefix();
        if (prefix == null) {
            return class_5244.field_39003;
        }
        return prefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviveProperty that = (ReviveProperty)o;
        return this.priority == that.priority && this.reviveType == that.reviveType;
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.reviveType);
    }

    public boolean isEmpty() {
        return false;
    }

    public ReviveProperty append(ReviveProperty property) {
        if (property.isEmpty()) {
            return this;
        }
        if (property instanceof CombinedReviveProperty) {
            CombinedReviveProperty combined = (CombinedReviveProperty)property;
            combined.append(this);
            return combined;
        }
        return new CombinedReviveProperty(this, property);
    }

    protected static class CombinedReviveProperty
    extends ReviveProperty {
        private final List<ReviveProperty> reviveProperties = new ArrayList<ReviveProperty>(2);

        public CombinedReviveProperty(ReviveProperty property1, ReviveProperty property2) {
            super(ReviveType.NONE, 0, 1.0f, 0);
            if (property1.priority >= property2.priority) {
                this.reviveProperties.add(property1);
                this.reviveProperties.add(property2);
            } else {
                this.reviveProperties.add(property2);
                this.reviveProperties.add(property1);
            }
        }

        @Override
        public ReviveProperty append(ReviveProperty property) {
            if (property.isEmpty()) {
                return this;
            }
            if (property instanceof CombinedReviveProperty) {
                CombinedReviveProperty combined = (CombinedReviveProperty)property;
                for (ReviveProperty pr : combined.reviveProperties) {
                    this.append(pr);
                }
                return this;
            }
            for (int i = 0; i < this.reviveProperties.size(); ++i) {
                ReviveProperty previousProperty = this.reviveProperties.get(i);
                if (previousProperty.priority > property.priority) continue;
                this.reviveProperties.add(i, property);
                return this;
            }
            this.reviveProperties.add(property);
            return this;
        }

        @Override
        public ReviveResult reviveSoldier(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
            for (ReviveProperty revives : this.reviveProperties) {
                ReviveResult result = revives.reviveSoldier(level, toRevive, reviver);
                if (!result.success()) continue;
                return result;
            }
            return ReviveResult.FAIL;
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            int index;
            int propertyCount = this.reviveProperties.size();
            class_2561 end = null;
            for (index = 0; index < propertyCount; ++index) {
                end = this.reviveProperties.get(index).getDisplayName();
                if (end == null) continue;
            }
            if (end == null) {
                return null;
            }
            class_5250 name = null;
            for (int i = propertyCount - 1; i >= index; --i) {
                class_2561 prefix = this.reviveProperties.get(i).getDisplayPrefix();
                if (prefix == null) continue;
                if (name == null) {
                    name = prefix.method_27661();
                } else {
                    name.method_10852(prefix);
                }
                name.method_10852(class_5244.field_41874);
            }
            return name != null ? name.method_10852(end) : end;
        }
    }
}

