/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.revive;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveResult;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ReviveType implements class_3542,
KeyableTranslatableProperty
{
    NONE("none", (level, toRevive, reviver) -> ReviveResult.FAIL, (toRevive, reviver) -> false, null),
    NECROTIC("necrotic", ReviveType::necroticRevive, (toRevive, reviver) -> !toRevive.isIgnited(), class_124.field_1077),
    DARK_NECROTIC("dark_necrotic", ReviveType::darkNecrotic, (toRevive, reviver) -> true, class_124.field_1074),
    MEDIC("medic", ReviveType::medicRevive, ReviveType::medicPredicate, class_124.field_1060),
    ANGEL("angel", ReviveType::medicRevive, ReviveType::sameTeam, class_124.field_1054),
    WRAITH("spiritual", ReviveType::wraithConversion, ReviveType::sameTeam, class_124.field_1077){

        @Override
        public class_2583 getStyle() {
            return class_2583.field_24360.method_36139(261343);
        }
    };

    public static final Codec<ReviveType> CODEC;
    public static final class_9139<class_2540, ReviveType> STREAM_CODEC;
    public static final class_9139<ByteBuf, List<Integer>> INT_LIST_STREAM_CODEC;
    private final String serializedName;
    @Nullable
    private final class_124 chatFormatting;
    private final ReviveFunction effect;
    private final BiPredicate<AbstractClaySoldierEntity, AbstractClaySoldierEntity> reviveCondition;

    private ReviveType(String serializedName, @Nullable ReviveFunction effect, BiPredicate<AbstractClaySoldierEntity, AbstractClaySoldierEntity> reviveCondition, class_124 chatFormatting) {
        this.serializedName = serializedName;
        this.reviveCondition = reviveCondition;
        this.effect = effect;
        this.chatFormatting = chatFormatting;
    }

    @NotNull
    public String method_15434() {
        return this.serializedName;
    }

    @Nullable
    public class_2561 getDisplayPrefix() {
        if (this.getStyle() == null) {
            return null;
        }
        return class_2561.method_43471((String)this.translatablePrefixKey()).method_27696(this.getStyle());
    }

    @Override
    public String translatableKey() {
        return "clay_soldier_property.csr.revive_type." + this.serializedName;
    }

    public String translatablePrefixKey() {
        return "clay_soldier_property.csr.revive_type." + this.serializedName + ".prefix";
    }

    @Override
    public class_124 getFormat() {
        return this.chatFormatting;
    }

    public ReviveResult revive(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        if (!this.reviveCondition.test(toRevive, reviver)) {
            return ReviveResult.FAIL;
        }
        return this.effect.revive(level, toRevive, reviver);
    }

    public static Optional<ReviveType> getFromString(String name) {
        for (ReviveType type : ReviveType.values()) {
            if (!type.serializedName.equals(name)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    private static ReviveResult necroticRevive(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        return ReviveType.zombieRevive(toRevive, reviver, true);
    }

    private static ReviveResult darkNecrotic(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        return ReviveType.zombieRevive(toRevive, reviver, false);
    }

    private static ReviveResult zombieRevive(AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver, boolean curable) {
        return ReviveResult.zombieOrFail(toRevive.convertToSoldier(ModEntityTypes.ZOMBIE_CLAY_SOLDIER_ENTITY.get(), convertedTo -> {
            convertedTo.setClayTeamType(reviver.getClayTeamType());
            convertedTo.setPreviousTeam(toRevive.getClayTeamType());
            convertedTo.setCurable(curable);
        }));
    }

    private static ReviveResult medicRevive(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        return ReviveResult.soldierOrFail(toRevive.convertToSoldier(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), convertedTo -> {
            convertedTo.setClayTeamType(reviver.getClayTeamType());
            convertedTo.method_6033(convertedTo.method_6063() / 2.0f);
        }));
    }

    private static ReviveResult wraithConversion(class_3218 level, AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        return ReviveResult.wraithOrFail(ClayWraithEntity.spawnWraith(level, toRevive, 10));
    }

    private static boolean medicPredicate(AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        return ReviveType.sameTeam(toRevive, reviver) && toRevive.method_5809() && !toRevive.isIgnited();
    }

    private static boolean sameTeam(AbstractClaySoldierEntity toRevive, AbstractClaySoldierEntity reviver) {
        return toRevive.sameTeamAs((class_1297)reviver);
    }

    static {
        CODEC = class_3542.method_28140(ReviveType::values);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(ReviveType.class);
        INT_LIST_STREAM_CODEC = class_9135.field_49675.method_56433(class_9135.method_58000((int)ReviveType.values().length));
    }

    @FunctionalInterface
    public static interface ReviveFunction {
        public ReviveResult revive(class_3218 var1, AbstractClaySoldierEntity var2, AbstractClaySoldierEntity var3);
    }
}

