/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.ZombieClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackSerializer;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.util.EffectHolder;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_4081;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class SpecialAttacks {
    private static final Supplier<SpecialAttackSerializer<Thorns>> THORNS_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("thorns", () -> new SpecialAttackSerializer<Thorns>(Thorns.CODEC, Thorns.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<SneakAttack>> SNEAK_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("sneak_attack", () -> new SpecialAttackSerializer<SneakAttack>(SneakAttack.CODEC, SneakAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<LightningAttack>> LIGHTNING_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("lightning_attack", () -> new SpecialAttackSerializer<LightningAttack>(LightningAttack.CODEC, LightningAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<EffectAttack>> EFFECT_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("effect", () -> new SpecialAttackSerializer<EffectAttack>(EffectAttack.CODEC, EffectAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<CritAttack>> CRIT_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("critical_hit", () -> new SpecialAttackSerializer<CritAttack>(CritAttack.CODEC, CritAttack.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<Smite>> SMITE_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("smite", () -> new SpecialAttackSerializer<Smite>(Smite.CODEC, Smite.STREAM_CODEC));
    private static final Supplier<SpecialAttackSerializer<Ignite>> IGNITE_ATTACK_SERIALIZER = ClaySoldiersCommon.PLATFORM.registerSpecialAttackSerializer("ignite", () -> new SpecialAttackSerializer<Ignite>(Ignite.CODEC, Ignite.STREAM_CODEC));

    public static void init() {
    }

    public static class Ignite
    extends SpecialAttack<Ignite>
    implements ValueCombiner<Ignite> {
        public static final Codec<Ignite> CODEC = RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(SpecialAttack::getDamage), (App)class_5699.field_33441.fieldOf("duration").forGetter(c -> c.duration)).apply((Applicative)in, Ignite::new));
        public static final class_9139<class_9129, Ignite> STREAM_CODEC = class_9139.method_56436(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (class_9139)class_9135.field_48552, SpecialAttack::getDamage, (class_9139)class_9135.field_48550, c -> c.duration, Ignite::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.ignite";
        private final int duration;

        public Ignite(SpecialAttackType attackType, float bonusDamage, int duration) {
            super(IGNITE_ATTACK_SERIALIZER, attackType, bonusDamage);
            this.duration = duration;
        }

        @Override
        public void attackEffect(ClayMobEntity attacker, class_1297 target) {
            target.method_56073(this.duration);
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43469((String)DISPLAY_NAME_KEY, (Object[])new Object[]{Float.valueOf((float)this.duration / 20.0f)}).method_27692(class_124.field_1065);
        }

        @Override
        public Ignite combine(Ignite first, Ignite second) {
            return new Ignite(first.getAttackType(), first.getDamage() + second.getDamage(), first.duration + second.duration);
        }
    }

    public static class Smite
    extends SpecialAttack<Smite> {
        public static final Codec<Smite> CODEC = SpecialAttack.createDefaultDamageCodec(Smite::new);
        public static final class_9139<class_9129, Smite> STREAM_CODEC = Smite.createDefaultStreamCodec(Smite::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.smite";

        public Smite(SpecialAttackType attackType, float bonusDamage) {
            super(SMITE_ATTACK_SERIALIZER, attackType, bonusDamage);
        }

        @Override
        public boolean condition(ClayMobEntity attacker, class_1297 target) {
            return target.method_5864().method_20210(class_3483.field_46232);
        }

        @Override
        public void attackEffect(ClayMobEntity attacker, class_1297 target) {
            ZombieClaySoldierEntity zombie;
            if (target instanceof ZombieClaySoldierEntity && (zombie = (ZombieClaySoldierEntity)target).previousTeamSameAs(attacker)) {
                zombie.cureZombieSoldier();
            }
            if (target instanceof class_1309) {
                class_1309 livingEntity = (class_1309)target;
                livingEntity.method_6016(ModEffects.VAMPIRE_CONVERSION);
            }
        }

        @Override
        public boolean shouldAttackTarget(class_1309 target) {
            return target.method_5864().method_20210(class_3483.field_46232);
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)DISPLAY_NAME_KEY).method_27692(class_124.field_1054);
        }
    }

    public static class CritAttack
    extends SpecialAttack<CritAttack> {
        public static final Codec<CritAttack> CODEC = RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(SpecialAttack::getDamage), (App)class_5699.field_34387.optionalFieldOf("chance", (Object)Float.valueOf(0.5f)).forGetter(c -> Float.valueOf(c.chance))).apply((Applicative)in, CritAttack::new));
        public static final class_9139<class_9129, CritAttack> STREAM_CODEC = class_9139.method_56436(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (class_9139)class_9135.field_48552, SpecialAttack::getDamage, (class_9139)class_9135.field_48552, c -> Float.valueOf(c.chance), CritAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.crit";
        private final float chance;

        public CritAttack(SpecialAttackType attackType, float bonusDamage, float chance) {
            super(CRIT_ATTACK_SERIALIZER, attackType, bonusDamage);
            this.chance = chance;
        }

        @Override
        public boolean condition(ClayMobEntity attacker, class_1297 target) {
            return attacker.method_59922().method_43057() >= this.chance;
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)DISPLAY_NAME_KEY);
        }
    }

    public static class EffectAttack
    extends SpecialAttack<EffectAttack>
    implements EffectHolder {
        public static final Codec<EffectAttack> CODEC = RecordCodecBuilder.create(in -> in.group((App)SpecialAttackType.CODEC.fieldOf("attack_type").forGetter(SpecialAttack::getAttackType), (App)Codec.FLOAT.optionalFieldOf("damage", (Object)Float.valueOf(0.0f)).forGetter(SpecialAttack::getDamage)).and(CodecUtils.addEffectAnd()).apply((Applicative)in, EffectAttack::new));
        public static final class_9139<class_9129, EffectAttack> STREAM_CODEC = class_9139.method_56906(SpecialAttackType.STREAM_CODEC, SpecialAttack::getAttackType, (class_9139)class_9135.field_48552, SpecialAttack::getDamage, (class_9139)class_1291.field_51934, EffectAttack::effectHolder, (class_9139)class_9135.field_48550, EffectAttack::duration, (class_9139)class_9135.field_48550, EffectAttack::amplifier, EffectAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.effect";
        private final class_6880<class_1291> effect;
        private final int duration;
        private final int amplifier;

        public EffectAttack(SpecialAttackType specialAttackType, float bonusDamage, class_6880<class_1291> effect, int duration, int amplifier) {
            super(EFFECT_ATTACK_SERIALIZER, specialAttackType, bonusDamage);
            this.effect = effect;
            this.duration = duration;
            this.amplifier = amplifier;
        }

        @Override
        public void attackEffect(ClayMobEntity attacker, class_1297 target) {
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                livingTarget.method_6092(new class_1293(this.effect, this.duration, this.amplifier, false, true, true));
            }
        }

        @Override
        public boolean isForCategory(SpecialEffectCategory category) {
            return switch (((class_1291)this.effect.comp_349()).method_18792()) {
                default -> throw new MatchException(null, null);
                case class_4081.field_18273 -> true;
                case class_4081.field_18271 -> category.isSupportive();
                case class_4081.field_18272 -> category.isHarmful();
            };
        }

        @Override
        public boolean shouldAttackTarget(class_1309 target) {
            return !target.method_6059(this.effect);
        }

        @Override
        public class_6880<class_1291> effectHolder() {
            return this.effect;
        }

        @Override
        public int duration() {
            return this.duration;
        }

        @Override
        public int amplifier() {
            return this.amplifier;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.effectHolderToString();
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)DISPLAY_NAME_KEY).method_27693(" ").method_10852(this.effect().method_5560()).method_54663(this.effect().method_5556());
        }
    }

    public static class LightningAttack
    extends SpecialAttack<LightningAttack> {
        public static final Codec<LightningAttack> CODEC = LightningAttack.createDefaultDamageCodec(LightningAttack::new);
        public static final class_9139<class_9129, LightningAttack> STREAM_CODEC = LightningAttack.createDefaultStreamCodec(LightningAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.lightning";

        public LightningAttack(SpecialAttackType attackType, float bonusDamage) {
            super(LIGHTNING_ATTACK_SERIALIZER, attackType, bonusDamage);
        }

        @Override
        public void attackEffect(ClayMobEntity attacker, class_1297 target) {
            class_3218 serverLevel;
            class_1538 lightningbolt;
            class_1937 class_19372 = attacker.method_37908();
            if (class_19372 instanceof class_3218 && (lightningbolt = (class_1538)class_1299.field_6112.method_5883((class_1937)(serverLevel = (class_3218)class_19372))) != null) {
                lightningbolt.method_29495(class_243.method_24955((class_2382)target.method_24515()));
                lightningbolt.method_29498(true);
                serverLevel.method_8649((class_1297)lightningbolt);
                attacker.method_5783((class_3414)class_3417.field_14896.comp_349(), 0.5f, 1.0f);
            }
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)DISPLAY_NAME_KEY).method_27692(class_124.field_1068);
        }
    }

    public static class SneakAttack
    extends SpecialAttack<SneakAttack> {
        public static final Codec<SneakAttack> CODEC = SneakAttack.createDefaultDamageCodec(SneakAttack::new);
        public static final class_9139<class_9129, SneakAttack> STREAM_CODEC = SneakAttack.createDefaultStreamCodec(SneakAttack::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.sneak_attack";

        public SneakAttack(SpecialAttackType attackType, float bonusDamage) {
            super(SNEAK_ATTACK_SERIALIZER, attackType, bonusDamage);
        }

        @Override
        public void attackEffect(ClayMobEntity attacker, class_1297 target) {
            class_1937 class_19372 = attacker.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.1), target.method_23321(), 1, 0.1, 0.0, 0.1, 0.2);
            }
        }

        @Override
        public boolean condition(ClayMobEntity attacker, class_1297 target) {
            return attacker.method_5767();
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)DISPLAY_NAME_KEY);
        }
    }

    public static class Thorns
    extends SpecialAttack<Thorns> {
        public static final Codec<Thorns> CODEC = Thorns.createDefaultDamageCodec(Thorns::new);
        public static final class_9139<class_9129, Thorns> STREAM_CODEC = Thorns.createDefaultStreamCodec(Thorns::new);
        public static final String DISPLAY_NAME_KEY = "clay_soldier_property.csr.special_attack.thorns";

        public Thorns(SpecialAttackType attackType, float reflectDamage) {
            super(THORNS_SERIALIZER, attackType, reflectDamage);
        }

        @Override
        public boolean condition(ClayMobEntity attacker, class_1297 target) {
            return attacker.method_59922().method_43057() < 0.75f;
        }

        @Override
        @Nullable
        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)DISPLAY_NAME_KEY).method_27692(class_124.field_1077);
        }
    }
}

