/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.types;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.combined.ValueCombiner;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class AttributePropertyType
extends SoldierPropertyType<Map<class_6880<class_1320>, List<class_1322>>> {
    public static final Codec<Map<class_6880<class_1320>, List<class_1322>>> CODEC = Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)class_1322.field_46247.listOf());
    public static final class_9139<class_9129, Map<class_6880<class_1320>, List<class_1322>>> STREAM_CODEC = class_9135.method_56377(HashMap::new, (class_9139)class_9135.method_56383((class_5321)class_7924.field_41251), (class_9139)class_1322.field_49233.method_56433(class_9135.method_56363()));
    public static final Map<class_6880<class_1320>, List<class_1322>> EMPTY = Map.of();
    public static final ToIntFunction<Map<class_6880<class_1320>, List<class_1322>>> TO_INT = Map::size;
    public static final ValueCombiner<Map<class_6880<class_1320>, List<class_1322>>> COMBINER = (m1, m2) -> {
        HashMap newMap = new HashMap(Math.max(m1.size(), m2.size()));
        m1.forEach((k, v) -> newMap.put(k, new ArrayList(v)));
        m2.forEach((k, v) -> newMap.merge(k, v, (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }));
        return newMap;
    };

    public AttributePropertyType() {
        super(CODEC, STREAM_CODEC, EMPTY, TO_INT, COMBINER, null);
    }

    @Override
    public List<class_2561> getDisplayNameWithValue(Map<class_6880<class_1320>, List<class_1322>> value, @Nullable ClaySoldierInventoryQuery soldier) {
        class_5250 name = class_2561.method_43471((String)this.getDescriptionId()).method_27692(class_124.field_1063);
        name.method_27693(":");
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        list.add((class_2561)name);
        for (Map.Entry<class_6880<class_1320>, List<class_1322>> entry : value.entrySet()) {
            AttributePropertyType.combine(entry.getValue()).forEach(m -> this.addModifierTooltip(list::add, (class_6880<class_1320>)((class_6880)entry.getKey()), (class_1322)m));
        }
        return list;
    }

    private static List<class_1322> combine(List<class_1322> modifiers) {
        ArrayList<class_1322> combined = new ArrayList<class_1322>();
        modifiers.forEach(mod -> {
            boolean merged = false;
            for (int i = 0; i < combined.size(); ++i) {
                class_1322 other = (class_1322)combined.get(i);
                if (mod.comp_2450() != other.comp_2450()) continue;
                combined.set(i, new class_1322(mod.comp_2447(), mod.comp_2449() + other.comp_2449(), mod.comp_2450()));
                merged = true;
                break;
            }
            if (!merged) {
                combined.add((class_1322)mod);
            }
        });
        return combined;
    }

    private void addModifierTooltip(Consumer<class_2561> pTooltipAdder, class_6880<class_1320> pAttribute, class_1322 modifier) {
        double amount = modifier.comp_2449();
        double displayAmount = modifier.comp_2450() == class_1322.class_1323.field_6330 || modifier.comp_2450() == class_1322.class_1323.field_6331 ? amount * 100.0 : (pAttribute.method_55838(class_5134.field_23718) ? amount * 10.0 : amount);
        if (amount > 0.0) {
            pTooltipAdder.accept((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(displayAmount), class_2561.method_43471((String)((class_1320)pAttribute.comp_349()).method_26830())}).method_27692(((class_1320)pAttribute.comp_349()).method_60494(true))));
        } else if (amount < 0.0) {
            pTooltipAdder.accept((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + modifier.comp_2450().method_56082()), (Object[])new Object[]{class_9285.field_49329.format(-displayAmount), class_2561.method_43471((String)((class_1320)pAttribute.comp_349()).method_26830())}).method_27692(((class_1320)pAttribute.comp_349()).method_60494(false))));
        }
    }
}

