/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.soldierproperties.types;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;

public class BreathHoldPropertyType
extends SoldierPropertyType<Integer> {
    private static final Codec<Integer> CODEC = CodecUtils.withReplacementValues((Codec)Codec.INT, BreathHoldProperty.CODEC_SPECIAL, (Supplier[])BreathHoldProperty.values());
    public static final int MAX_BREATH_HOLD = 1000;
    public static final int NO_BREATH_HOLD = -200;

    public BreathHoldPropertyType() {
        super(CODEC, class_9135.field_48550.method_56430(), BreathHoldProperty.NORMAL.get(), SoldierPropertyTypes.INT_AS_INT, SoldierPropertyTypes.INT_COMBINER, null);
    }

    @Override
    public List<class_2561> getDisplayNameWithValue(Integer value, @Nullable ClaySoldierInventoryQuery soldier) {
        class_5250 name = class_2561.method_43471((String)this.getDescriptionId()).method_27693(": ");
        if (value >= 1000) {
            name.method_10852((class_2561)class_2561.method_43471((String)BreathHoldProperty.INFINITE.translatableKey()));
        } else if (value <= -200) {
            name.method_10852((class_2561)class_2561.method_43471((String)BreathHoldProperty.NONE.translatableKey()));
        } else {
            name.method_27693(value.toString());
        }
        return List.of(name);
    }

    public static enum BreathHoldProperty implements class_3542,
    Supplier<Integer>,
    KeyableTranslatableProperty
    {
        NONE("none", -200),
        NORMAL("normal", 0),
        INFINITE("infinite", 1000);

        public static final Codec<BreathHoldProperty> CODEC_SPECIAL;
        private final String serializedName;
        private final int amount;

        private BreathHoldProperty(String name, int amount) {
            this.serializedName = name;
            this.amount = amount;
        }

        public String method_15434() {
            return this.serializedName;
        }

        @Override
        public Integer get() {
            return this.amount;
        }

        public String toString() {
            return this.serializedName;
        }

        @Override
        public String translatableKey() {
            return SoldierPropertyTypes.BREATH_HOLD.get().getDescriptionId() + "." + this.serializedName;
        }

        static {
            CODEC_SPECIAL = class_3542.method_28140(BreathHoldProperty::values);
        }
    }
}

