/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.ToIntFunction;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class ClayMobTeam {
    public static final Codec<ClayMobTeam> CODEC_JSON = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.fieldOf("name").forGetter(ClayMobTeam::getName), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(c -> c.color), (App)Codec.BOOL.optionalFieldOf("friendly_fire", (Object)false).forGetter(ClayMobTeam::isFriendlyFireAllowed), (App)class_7923.field_41178.method_39673().optionalFieldOf("from", (Object)class_1802.field_8162).forGetter(ClayMobTeam::getGetFromOrAir), (App)SoldierPropertyMap.CODEC_FOR_NON_ITEM.optionalFieldOf("properties", (Object)SoldierPropertyMap.EMPTY_MAP).forGetter(ClayMobTeam::getProperties), (App)PlayerUUIDAndName.CODEC.listOf().optionalFieldOf("players", List.of()).forGetter(c -> c.players)).apply((Applicative)in, ClayMobTeam::new));
    public static final class_9139<class_9129, ClayMobTeam> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48554, ClayMobTeam::getName, ColorHelper.STREAM_CODEC, c -> c.color, (class_9139)class_9135.field_48547, ClayMobTeam::isFriendlyFireAllowed, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), t -> t.getFrom == null ? class_1802.field_8162 : t.getFrom, SoldierPropertyMap.STREAM_CODEC, ClayMobTeam::getProperties, (class_9139)PlayerUUIDAndName.STREAM_CODEC.method_56433(class_9135.method_56374(ArrayList::new)), c -> c.players, ClayMobTeam::new);
    public static final String TEAM_ID_TAG = "team_id";
    private static final String FORMATTED_TEAM_ID_TAG = "%s_team_id";
    private final String name;
    private final ColorHelper color;
    private final boolean friendlyFire;
    @Nullable
    private final class_1792 getFrom;
    private final SoldierPropertyMap properties;
    private final List<PlayerUUIDAndName> players;
    private final Collection<UUID> playerUUIDs;
    private final List<String> playerNames;

    private ClayMobTeam(String name, ColorHelper color, boolean friendlyFire, @NotNull class_1792 getFrom, SoldierPropertyMap properties, Collection<PlayerUUIDAndName> players) {
        this.name = name;
        this.color = color;
        this.friendlyFire = friendlyFire;
        this.getFrom = getFrom == class_1802.field_8162 ? null : getFrom;
        this.properties = properties;
        this.players = List.copyOf(players);
        this.playerUUIDs = players.stream().map(PlayerUUIDAndName::uuid).toList();
        this.playerNames = players.stream().map(PlayerUUIDAndName::name).toList();
    }

    protected ClayMobTeam(String name, ColorHelper color, boolean friendlyFire, @NotNull class_1792 getFrom) {
        this(name, color, friendlyFire, getFrom, SoldierPropertyMap.EMPTY_MAP, List.of());
    }

    private ClayMobTeam(String name, ColorHelper color, boolean friendlyFire, @NotNull class_1792 getFrom, SoldierPropertyMap properties) {
        this(name, color, friendlyFire, getFrom, properties, List.of());
    }

    public SoldierPropertyMap getProperties() {
        return this.properties;
    }

    public class_2561 getDisplayNameWithColor(ToIntFunction<ColorHelper> colorFunction) {
        return class_2561.method_43470((String)this.getName()).method_54663(colorFunction.applyAsInt(this.color));
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)this.getName());
    }

    private String getName() {
        return this.name;
    }

    public int getColor(class_1309 livingEntity, float partialTick) {
        return this.color.getColor(livingEntity, partialTick);
    }

    public int getColor(int offsetStart, int tick, float partialTick) {
        return this.color.getColor(offsetStart, tick, partialTick);
    }

    @Nullable
    public class_1792 getGetFrom() {
        return this.getFrom;
    }

    private class_1792 getGetFromOrAir() {
        return this.getFrom != null ? this.getFrom : class_1802.field_8162;
    }

    public boolean isFriendlyFireAllowed() {
        return this.friendlyFire;
    }

    public boolean isCooperative() {
        return true;
    }

    public @UnmodifiableView Collection<UUID> getPlayers() {
        return this.playerUUIDs;
    }

    public @UnmodifiableView List<String> getPlayerNames() {
        return this.playerNames;
    }

    public boolean canBeUsed(class_1657 player) {
        return this.players.isEmpty() || this.players.contains(new PlayerUUIDAndName(player.method_7334()));
    }

    public boolean hasPlayer() {
        return !this.players.isEmpty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClayMobTeam otherTeam = (ClayMobTeam)other;
        return this.color.equals(otherTeam.color) && this.friendlyFire == otherTeam.friendlyFire && this.name.equalsIgnoreCase(otherTeam.name) && Objects.equals(this.players, otherTeam.players);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.color, this.friendlyFire);
    }

    public String toString() {
        return "ClayMobTeam{" + this.name + "', " + String.valueOf(this.color) + (this.friendlyFire ? " friendlyFire" : "") + String.valueOf(this.playerNames.isEmpty() ? "" : this.playerNames) + "}";
    }

    public static void save(class_2960 key, class_2487 tag) {
        tag.method_10582(TEAM_ID_TAG, key.toString());
    }

    public static class_2960 read(class_2487 tag) {
        return class_2960.method_60654((String)tag.method_10558(TEAM_ID_TAG));
    }

    public static void save(class_2960 key, class_2487 tag, String prefix) {
        tag.method_10582(FORMATTED_TEAM_ID_TAG.formatted(prefix), key.toString());
    }

    public static class_2960 read(class_2487 tag, String prefix) {
        return class_2960.method_60654((String)tag.method_10558(FORMATTED_TEAM_ID_TAG.formatted(prefix)));
    }

    public static Builder of(String name, ColorHelper color) {
        return new Builder(name, color);
    }

    private record PlayerUUIDAndName(UUID uuid, String name) {
        public static final Codec<PlayerUUIDAndName> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_4844.field_25122.fieldOf("uuid").forGetter(PlayerUUIDAndName::uuid), (App)Codec.STRING.fieldOf("name").forGetter(PlayerUUIDAndName::name)).apply((Applicative)in, PlayerUUIDAndName::new));
        public static final class_9139<ByteBuf, PlayerUUIDAndName> STREAM_CODEC = class_9139.method_56435((class_9139)class_4844.field_48453, PlayerUUIDAndName::uuid, (class_9139)class_9135.field_48554, PlayerUUIDAndName::name, PlayerUUIDAndName::new);

        private PlayerUUIDAndName(GameProfile profile) {
            this(profile.getId(), profile.getName());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerUUIDAndName that = (PlayerUUIDAndName)o;
            return Objects.equals(this.uuid, that.uuid);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.uuid);
        }
    }

    public static class Builder {
        private SoldierPropertyMap properties = SoldierPropertyMap.EMPTY_MAP;
        private class_1792 getFrom = class_1802.field_8162;
        private boolean friendlyFire = false;
        private final String name;
        private final ColorHelper color;

        public Builder(String name, ColorHelper color) {
            this.name = name;
            this.color = color;
        }

        public Builder setProperties(SoldierPropertyMap properties) {
            this.properties = properties;
            return this;
        }

        public Builder setGetFrom(@NotNull class_1792 getFrom) {
            this.getFrom = getFrom;
            return this;
        }

        public Builder allowFriendlyFire() {
            this.friendlyFire = true;
            return this;
        }

        public ClayMobTeam build() {
            return new ClayMobTeam(this.name, this.color, this.friendlyFire, this.getFrom, this.properties);
        }
    }
}

