/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.IClayMobTeamReference;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClayMobTeamManger {
    public static final class_2960 DEFAULT_TYPE = class_2960.method_60655((String)"csr", (String)"normal");
    public static final class_2960 NO_TEAM_TYPE = class_2960.method_60655((String)"csr", (String)"no_team");
    private static final ClayMobTeam DEFAULT = ClayMobTeam.of("Normal", ColorHelper.EMPTY).build();
    private static final ClayMobTeam NO_TEAM = ClayMobTeam.of("NoTeam", ColorHelper.EMPTY).allowFriendlyFire().build();
    private static final Map<class_1792, class_2960> FROM_ITEM_MAP = new HashMap<class_1792, class_2960>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Clay Soldiers Team Manger");
    public static final ClayMobTeam ERROR = new ErrorClayMobTeam();

    public static IClayMobTeamReference getReferenceOrDefault(class_2960 key, class_5455 access, Runnable ifInValid) {
        Optional holder = access.method_30530(ModRegistries.CLAY_MOB_TEAMS).method_55841(key);
        if (holder.isPresent()) {
            return new ClayMobTeamReference((class_6880.class_6883<ClayMobTeam>)((class_6880.class_6883)holder.orElseThrow()));
        }
        ifInValid.run();
        return new ClayMobTeamReference(ClayMobTeamManger.getDefault((class_7225.class_7874)access));
    }

    public static class_6880.class_6883<ClayMobTeam> getDefault(class_7225.class_7874 access) {
        return (class_6880.class_6883)access.method_46762(ModRegistries.CLAY_MOB_TEAMS).method_46746(class_5321.method_29179(ModRegistries.CLAY_MOB_TEAMS, (class_2960)DEFAULT_TYPE)).orElseThrow();
    }

    public static Stream<class_2960> getAllKeys(class_7225.class_7874 registryAccess) {
        return registryAccess.method_46762(ModRegistries.CLAY_MOB_TEAMS).method_46754().map(class_5321::method_29177);
    }

    @NotNull
    public static ClayMobTeam getFromKeyAssumeValid(class_2960 key, class_5455 access) {
        return Objects.requireNonNull((ClayMobTeam)access.method_30530(ModRegistries.CLAY_MOB_TEAMS).method_10223(key), "Tried accessing in valid team");
    }

    @Nullable
    public static ClayMobTeam getFromKey(class_2960 key, class_5455 registryAccess) {
        return (ClayMobTeam)registryAccess.method_30530(ModRegistries.CLAY_MOB_TEAMS).method_10223(key);
    }

    public static Optional<ClayMobTeam> getOptional(class_2960 key, class_7225.class_7874 registryAccess) {
        return registryAccess.method_46762(ModRegistries.CLAY_MOB_TEAMS).method_46746(ClayMobTeamManger.create(key)).map(class_6880::comp_349);
    }

    public static Optional<class_6880.class_6883<ClayMobTeam>> getHolder(class_2960 key, class_7225.class_7874 registryAccess) {
        return registryAccess.method_46762(ModRegistries.CLAY_MOB_TEAMS).method_46746(class_5321.method_29179(ModRegistries.CLAY_MOB_TEAMS, (class_2960)key));
    }

    public static boolean isValidTeam(class_2960 key, class_5455 access) {
        return access.method_30530(ModRegistries.CLAY_MOB_TEAMS).method_10250(key);
    }

    @NotNull
    public static ClayMobTeam getFromKeyOrError(@NotNull class_2960 key, class_7225.class_7874 access) {
        if (access == null || key == null) {
            return ERROR;
        }
        return access.method_46759(ModRegistries.CLAY_MOB_TEAMS).map(r -> r.method_46746(class_5321.method_29179(ModRegistries.CLAY_MOB_TEAMS, (class_2960)key)).map(class_6880::comp_349).orElse(ERROR)).orElse(ERROR);
    }

    public static class_1799 createStackForTeam(class_2960 id, class_7225.class_7874 registries) {
        class_1799 stack = ModItems.CLAY_SOLDIER.get().method_7854();
        ClaySoldierSpawnItem.setClayMobTeam(stack, id, registries);
        return stack;
    }

    @Nullable
    public static class_2960 getFromItem(class_1792 item) {
        return FROM_ITEM_MAP.get(item);
    }

    public static void appendFromItemMap(@Nullable class_1792 item, class_2960 location) {
        if (item == null) {
            return;
        }
        FROM_ITEM_MAP.put(item, location);
    }

    public static @UnmodifiableView Map<class_1792, class_2960> getFromItemMap() {
        return Map.copyOf(FROM_ITEM_MAP);
    }

    private static class_5321<ClayMobTeam> create(class_2960 location) {
        return class_5321.method_29179(ModRegistries.CLAY_MOB_TEAMS, (class_2960)location);
    }

    public static void registerDefault(class_2378<ClayMobTeam> registry) {
        ClayMobTeam noTeam;
        boolean defaultType = false;
        boolean noTeamType = false;
        if (registry.method_10223(DEFAULT_TYPE) == null) {
            class_2378.method_10230(registry, (class_2960)DEFAULT_TYPE, (Object)DEFAULT);
            defaultType = true;
        }
        if ((noTeam = (ClayMobTeam)registry.method_10223(NO_TEAM_TYPE)) == null) {
            class_2378.method_10230(registry, (class_2960)NO_TEAM_TYPE, (Object)NO_TEAM);
            noTeamType = true;
        } else if (!noTeam.isFriendlyFireAllowed()) {
            LOGGER.warn("Created {} without friendly-fire enabled, however it probably should be", (Object)NO_TEAM);
        }
        if (noTeamType && defaultType) {
            LOGGER.info("Registered {} and {} as they were not present", (Object)DEFAULT_TYPE, (Object)NO_TEAM_TYPE);
        } else if (noTeamType || defaultType) {
            LOGGER.info("Registered {} as it was not present", (Object)(noTeamType ? NO_TEAM_TYPE : DEFAULT_TYPE));
        }
    }

    private record ClayMobTeamReference(class_6880.class_6883<ClayMobTeam> base) implements IClayMobTeamReference
    {
        @Override
        @NotNull
        public ClayMobTeam value() {
            return (ClayMobTeam)this.base.comp_349();
        }

        @Override
        @NotNull
        public class_2960 key() {
            return this.base.method_40237().method_29177();
        }
    }

    private static class ErrorClayMobTeam
    extends ClayMobTeam {
        protected ErrorClayMobTeam() {
            super("Error", ColorHelper.color(0xFF5555), true, class_1802.field_8162);
        }

        @Override
        public boolean canBeUsed(class_1657 player) {
            return false;
        }
    }
}

