/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.networking.ClayTeamPlayerDataPayload;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class TeamLoyaltyManger {
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    public static final class_9139<class_9129, TeamPlayerData.PlayerData> PLAYER_DATA_STREAM_CODEC = class_9139.method_56435((class_9139)class_4844.field_48453, TeamPlayerData.PlayerData::getUUID, (class_9139)class_8824.field_48540, TeamPlayerData.PlayerData::getLastDisplayName, TeamPlayerData.PlayerData::new);
    public static final class_9139<class_9129, Pair<class_2960, TeamPlayerData.PlayerData>> STREAM_CODEC_TEAM_PLAYER = class_9139.method_56435((class_9139)class_2960.field_48267, Pair::getFirst, PLAYER_DATA_STREAM_CODEC, Pair::getSecond, Pair::of);
    public static final class_9139<class_9129, List<Pair<class_2960, TeamPlayerData.PlayerData>>> STREAM_CODEC_TEAM_PLAYER_DATA = STREAM_CODEC_TEAM_PLAYER.method_56433(class_9135.method_56363());

    public static TeamPlayerData getTeamPlayerData(class_3218 level) {
        return ServerTeamPlayerData.getFromLevel(level);
    }

    public static TeamPlayerData getClientTeamPlayerData() {
        ClientTeamPlayerData instance = ClientTeamPlayerData.INSTANCE;
        if (instance == null) {
            LOGGER.error("ClientTeamPlayerData has not yet been instantiated. Setting it to Empty");
            ClientTeamPlayerData.setEmpty();
        }
        return instance;
    }

    @ApiStatus.Internal
    public static void createClientTeamPlayerData(List<Pair<class_2960, TeamPlayerData.PlayerData>> data, boolean reload) {
        ClientTeamPlayerData.createInstance(data, reload);
    }

    @ApiStatus.Internal
    public static void updateClientTeamPlayerData(class_2960 teamId, TeamPlayerData.PlayerData player) {
        ClientTeamPlayerData.INSTANCE.update(teamId, player);
    }

    @ApiStatus.Internal
    public static void removeClientTeamPlayerData(class_2960 teamId) {
        ClientTeamPlayerData.INSTANCE.remove(teamId);
    }

    @ApiStatus.Internal
    public static List<Pair<class_2960, TeamPlayerData.PlayerData>> getTeamData(class_3218 serverLevel) {
        return ServerTeamPlayerData.getFromLevel(serverLevel).toData();
    }

    public static boolean setTeamPlayer(class_3218 level, class_2960 team, @Nullable class_1657 player) {
        ServerTeamPlayerData serverData = ServerTeamPlayerData.getFromLevel(level);
        if (player != null) {
            return serverData.putPlayer(team, player);
        }
        TeamPlayerData.PlayerData prev = serverData.teamPlayerMap.remove(team);
        if (prev != null) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToAllPlayers(level, new ClayTeamPlayerDataPayload.Remove(team));
            return true;
        }
        return false;
    }

    private static class ServerTeamPlayerData
    extends class_18
    implements TeamPlayerData {
        private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
        private static final String TAG_NAME = "teamPlayerMap";
        private final class_3218 level;
        private final Map<class_2960, TeamPlayerData.PlayerData> teamPlayerMap = new HashMap<class_2960, TeamPlayerData.PlayerData>();
        private long timeStampLastChange = 0L;

        private ServerTeamPlayerData(class_3218 level) {
            this.level = level;
        }

        public static ServerTeamPlayerData getFromLevel(class_3218 level) {
            return (ServerTeamPlayerData)level.method_8503().method_30002().method_17983().method_17924(ServerTeamPlayerData.factory(level), "clayTeamLoyalty");
        }

        public List<Pair<class_2960, TeamPlayerData.PlayerData>> toData() {
            return this.teamPlayerMap.entrySet().stream().map(e -> Pair.of((Object)((class_2960)e.getKey()), (Object)((TeamPlayerData.PlayerData)e.getValue()))).toList();
        }

        private static class_18.class_8645<ServerTeamPlayerData> factory(class_3218 pLevel) {
            return new class_18.class_8645(() -> new ServerTeamPlayerData(pLevel), (tag, provider) -> ServerTeamPlayerData.load(pLevel, tag), null);
        }

        private static ServerTeamPlayerData load(class_3218 level, class_2487 tag) {
            ServerTeamPlayerData teamPlayerData = new ServerTeamPlayerData(level);
            if (!tag.method_10545(TAG_NAME)) {
                return teamPlayerData;
            }
            class_2487 mapTag = tag.method_10562(TAG_NAME).method_10553();
            LOGGER.debug("Started Loading TeamLoyaltyData");
            for (String teamId : mapTag.method_10541()) {
                class_2960 resTeamId = class_2960.method_60654((String)teamId);
                if (ClayMobTeamManger.isValidTeam(resTeamId, level.method_30349())) {
                    ServerTeamPlayerData.loadPlayerData(mapTag.method_10580(teamId), playerData -> teamPlayerData.teamPlayerMap.put(resTeamId, (TeamPlayerData.PlayerData)playerData));
                    continue;
                }
                LOGGER.error("{} Team does not exist anymore removing it from SavedData", (Object)teamId);
            }
            LOGGER.debug("Finished Loading TeamLoyaltyData");
            return teamPlayerData;
        }

        public class_2487 method_75(class_2487 pTag, class_7225.class_7874 pRegistries) {
            if (!this.teamPlayerMap.isEmpty()) {
                class_2487 mapTag = new class_2487();
                this.teamPlayerMap.forEach((? super K k, ? super V v) -> ServerTeamPlayerData.savePlayerData(mapTag, k.toString(), v));
                pTag.method_10566(TAG_NAME, (class_2520)mapTag);
            }
            return pTag;
        }

        @Override
        public TeamPlayerData.PlayerData getPlayerForTeam(class_2960 teamId) {
            return this.teamPlayerMap.get(teamId);
        }

        @Override
        public long lastChangeTime() {
            return this.timeStampLastChange;
        }

        @Override
        public boolean putPlayerIfAbsent(class_2960 teamId, class_1657 player) {
            if (this.teamPlayerMap.containsKey(teamId)) {
                return false;
            }
            this.putPlayer(teamId, player);
            return true;
        }

        public boolean putPlayer(class_2960 teamId, class_1657 player) {
            @Nullable TeamPlayerData.PlayerData data = this.teamPlayerMap.get(teamId);
            if (data != null && data.is(player)) {
                return false;
            }
            class_2960 toRemove = null;
            for (Map.Entry<class_2960, TeamPlayerData.PlayerData> entry : this.teamPlayerMap.entrySet()) {
                if (!entry.getValue().getUUID().equals(player.method_5667())) continue;
                toRemove = entry.getKey();
                break;
            }
            this.teamPlayerMap.remove(toRemove);
            TeamPlayerData.PlayerData playerData = ServerTeamPlayerData.playerDataFromPlayer(player);
            this.teamPlayerMap.put(teamId, playerData);
            this.method_80();
            this.timeStampLastChange = this.level.method_8510();
            ClaySoldiersCommon.NETWORK_MANGER.sendToAllPlayers(this.level, new ClayTeamPlayerDataPayload.Single(teamId, playerData));
            return true;
        }

        @Override
        public void forEach(BiConsumer<class_2960, TeamPlayerData.PlayerData> action) {
            this.teamPlayerMap.forEach(action);
        }

        @Override
        public void updatePlayerName(class_2960 teamId, class_1657 player) {
            TeamPlayerData.PlayerData data = this.teamPlayerMap.get(teamId);
            if (data == null) {
                return;
            }
            if (!data.getLastDisplayName().equals((Object)player.method_5476())) {
                data.setLastKnowName(player.method_5476());
                ClaySoldiersCommon.NETWORK_MANGER.sendToAllPlayers(this.level, new ClayTeamPlayerDataPayload.Single(teamId, data));
            }
        }

        public String toString() {
            return "ServerTeamLoyalData{" + String.valueOf(this.teamPlayerMap) + "}";
        }

        public static TeamPlayerData.PlayerData playerDataFromPlayer(class_1657 player) {
            return new TeamPlayerData.PlayerData(player.method_5667(), player.method_5476());
        }

        public static void loadPlayerData(class_2520 tag, Consumer<TeamPlayerData.PlayerData> thenDo) {
            PLAYER_DATA_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag).ifSuccess(thenDo).ifError(e -> LOGGER.error("Error Loading TeamLoyalty: {}", (Object)e.message()));
        }

        public static void savePlayerData(class_2487 tag, String key, TeamPlayerData.PlayerData data) {
            PLAYER_DATA_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)data).ifSuccess(t -> tag.method_10566(key, t)).ifError(e -> LOGGER.error("Error Saving TeamLoyalty for [{}|{}]: {}", new Object[]{key, data.getLastDisplayName(), e.message()}));
        }
    }

    private static class ClientTeamPlayerData
    implements TeamPlayerData {
        private static ClientTeamPlayerData INSTANCE = null;
        private static boolean wasCalledBeforeCreation = false;
        private final Map<class_2960, TeamPlayerData.PlayerData> teamPlayerMap;

        private ClientTeamPlayerData(List<Pair<class_2960, TeamPlayerData.PlayerData>> data) {
            this.teamPlayerMap = new HashMap<class_2960, TeamPlayerData.PlayerData>(data.size());
            data.forEach((? super T pair) -> this.teamPlayerMap.put((class_2960)pair.getFirst(), (TeamPlayerData.PlayerData)pair.getSecond()));
        }

        public static void createInstance(List<Pair<class_2960, TeamPlayerData.PlayerData>> data, boolean reload) {
            if (wasCalledBeforeCreation) {
                LOGGER.error("ClientTeamPlayerData was accessed before creation. Resetting it");
            }
            if (INSTANCE != null && !reload) {
                LOGGER.debug("ClientTeamPlayerData instantiated twice. Current: {} , new Data: {}", (Object)INSTANCE, data);
            }
            INSTANCE = new ClientTeamPlayerData(data);
        }

        private static void setEmpty() {
            INSTANCE = new ClientTeamPlayerData(List.of());
            wasCalledBeforeCreation = true;
        }

        public void update(class_2960 teamID, TeamPlayerData.PlayerData player) {
            class_2960 toRemove = null;
            for (Map.Entry<class_2960, TeamPlayerData.PlayerData> entry : ClientTeamPlayerData.INSTANCE.teamPlayerMap.entrySet()) {
                if (!entry.getValue().equals(player)) continue;
                toRemove = entry.getKey();
                break;
            }
            this.teamPlayerMap.remove(toRemove);
            this.teamPlayerMap.put(teamID, player);
        }

        public void remove(class_2960 teamID) {
            this.teamPlayerMap.remove(teamID);
        }

        @Override
        public boolean putPlayerIfAbsent(class_2960 teamId, class_1657 player) {
            throw new UnsupportedOperationException("ClayMobTeam cannot be modified from the Client");
        }

        @Override
        public TeamPlayerData.PlayerData getPlayerForTeam(class_2960 teamId) {
            return this.teamPlayerMap.get(teamId);
        }

        @Override
        public long lastChangeTime() {
            return -1L;
        }

        @Override
        public void forEach(BiConsumer<class_2960, TeamPlayerData.PlayerData> action) {
            this.teamPlayerMap.forEach(action);
        }

        @Override
        public void updatePlayerName(class_2960 teamId, class_1657 player) {
            throw new UnsupportedOperationException("ClayMobTeam cannot be modified from the Client");
        }

        public String toString() {
            return "ClientTeamLoyalData{" + String.valueOf(this.teamPlayerMap) + "}";
        }
    }
}

