/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.team;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public interface TeamPlayerData {
    public static final Codec<PlayerData> PLAYER_DATA_CODEC = RecordCodecBuilder.create(in -> in.group((App)class_4844.field_25122.fieldOf("uuid").forGetter(PlayerData::getUUID), (App)class_8824.field_46597.fieldOf("lastKnowName").forGetter(PlayerData::getLastDisplayName)).apply((Applicative)in, PlayerData::new));

    public boolean putPlayerIfAbsent(class_2960 var1, class_1657 var2);

    @Nullable
    public PlayerData getPlayerForTeam(class_2960 var1);

    public long lastChangeTime();

    public void forEach(BiConsumer<class_2960, PlayerData> var1);

    public void updatePlayerName(class_2960 var1, class_1657 var2);

    public static class PlayerData {
        private final UUID player;
        private class_2561 lastKnowName;

        public PlayerData(UUID player, class_2561 lastKnowName) {
            this.player = player;
            this.lastKnowName = lastKnowName;
        }

        public static PlayerData of(class_1657 player) {
            return new PlayerData(player.method_5667(), player.method_5476());
        }

        public UUID getUUID() {
            return this.player;
        }

        public void setLastKnowName(class_2561 lastKnowName) {
            this.lastKnowName = lastKnowName;
        }

        public boolean is(class_1657 player) {
            return this.getUUID().equals(player.method_5667());
        }

        public class_2561 getLastDisplayName() {
            return this.lastKnowName;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlayerData data = (PlayerData)o;
            return this.player.equals(data.player);
        }

        public int hashCode() {
            return this.player.hashCode();
        }

        public String toString() {
            return "Player(%s)".formatted(this.lastKnowName.getString());
        }
    }
}

