/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClaySoldierInventoryQuery;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseWearableProperties;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierpoi.SoldierPoi;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.translation.ITranslatableProperty;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public final class ComponentFormating {
    public static final String SOLDIER_PROPERTIES_EQUIP = "item.tooltip.csr.soldier_properties_equip";
    public static final String SOLDIER_PROPERTIES_EQUIP_AND_PREDICATE = "item.tooltip.csr.soldier_properties_equip_predicate";
    public static final String CLAY_HORSE_PROPERTIES_EQUIP = "item.tooltip.csr.clay_horse_properties_equip";
    public static final String SOLDIER_BECOMES_ATTACK_TYPE = "item.tooltip.csr.soldier_becomes_attack_type";
    public static final String SOLDIER_POI_ITEM = "item.tooltip.csr.soldier_poi_item";
    public static final String SOLDIER_POI_BLOCK = "item.tooltip.csr.soldier_poi_block";
    public static final String SOLDIER_POI_PREDICATE = "item.tooltip.csr.soldier_poi_predicate";
    public static final String SOLDIER_POI_EFFECT = "item.tooltip.csr.soldier_poi_effect";
    public static final String SOLDIER_ITEM_PICKUP_EFFECT = "item.tooltip.csr.soldier_pickup_effect";
    public static final String SOLDIER_ITEM_PICKUP_REMOVE = "item.tooltip.csr.soldier_removal_condition";
    public static final String CLAY_HORSE_PROTECTION = "item.tooltip.csr.clay_horse.protection";
    private static final String DOUBLE_SPACE = "  ";

    public static void addHoldableTooltip(@Nullable SoldierHoldableEffect holdableEffect, List<class_2561> tooltip) {
        if (holdableEffect == null) {
            return;
        }
        class_2561 predicateDisplayName = holdableEffect.predicate().getDisplayName();
        if (predicateDisplayName != null) {
            tooltip.add((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43471((String)SOLDIER_PROPERTIES_EQUIP_AND_PREDICATE).method_27692(class_124.field_1063)));
            tooltip.add((class_2561)class_5244.method_48320().method_10852(class_5244.field_41874).method_10852(predicateDisplayName).method_27692(class_124.field_1063));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)SOLDIER_PROPERTIES_EQUIP).method_27692(class_124.field_1063));
        }
        class_2561 attackTypeLang = holdableEffect.properties().attackType().getAnimatedDisplayName((class_1309)class_310.method_1551().field_1724);
        if (attackTypeLang != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)SOLDIER_BECOMES_ATTACK_TYPE, (Object[])new Object[]{attackTypeLang}).method_27692(class_124.field_1063));
        }
        ComponentFormating.formatProperties(tooltip, holdableEffect.properties(), List.of(SoldierPropertyTypes.ATTACK_TYPE.get()), null);
        ComponentFormating.formatListDisplayNamesMultiLine(tooltip, holdableEffect.getOnPickUpFunctions(), (class_2561)class_2561.method_43471((String)SOLDIER_ITEM_PICKUP_EFFECT), clayPoiFunction -> clayPoiFunction.getDisplayNameDynamic((class_1657)class_310.method_1551().field_1724));
        ComponentFormating.formatListDisplayNames(tooltip, holdableEffect.getRemovalConditions(), (class_2561)class_2561.method_43471((String)SOLDIER_ITEM_PICKUP_REMOVE), RemovalCondition::getDisplayName);
    }

    public static void addPoiTooltip(@Nullable SoldierPoi poi, List<class_2561> tooltip) {
        if (poi == null) {
            return;
        }
        class_2561 predicateDisplayName = poi.getPredicate().getDisplayName();
        if (predicateDisplayName != null) {
            tooltip.add((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43471((String)SOLDIER_POI_PREDICATE).method_27692(class_124.field_1063)));
            tooltip.add((class_2561)class_2561.method_43470((String)DOUBLE_SPACE).method_10852(predicateDisplayName).method_27692(class_124.field_1063));
        }
        ComponentFormating.formatListDisplayNamesMultiLine(tooltip, poi.getEffects(), (class_2561)class_2561.method_43471((String)SOLDIER_POI_EFFECT), clayPoiFunction -> clayPoiFunction.getDisplayNameDynamic((class_1657)class_310.method_1551().field_1724));
    }

    public static void formatProperties(List<class_2561> tooltip, Iterable<SoldierProperty<?>> properties, List<SoldierPropertyType<?>> hiddenProperties, @Nullable ClaySoldierInventoryQuery soldier) {
        for (SoldierProperty<?> soldierProperty : properties) {
            if (hiddenProperties.contains(soldierProperty.type())) continue;
            ComponentFormating.formatProperty(tooltip, soldierProperty, soldier);
        }
    }

    private static void formatProperty(List<class_2561> tooltip, SoldierProperty<?> property, @Nullable ClaySoldierInventoryQuery soldier) {
        Object propertyValue = property.value();
        class_5250 propertyComponent = class_5244.method_48320().method_27692(class_124.field_1063);
        if (property.type().is(ModTags.SoldierPropertyTypes.REQUIRES_OWNER) && soldier != null && soldier.getClayTeamOwner() != null) {
            return;
        }
        tooltip.add((class_2561)propertyComponent);
        if (propertyValue instanceof Iterable) {
            Iterable listValue = (Iterable)propertyValue;
            propertyComponent.method_10852(property.type().getDisplayName());
            propertyComponent.method_10852((class_2561)class_2561.method_43470((String)":"));
            ComponentFormating.formatList(tooltip, listValue);
        } else if (propertyValue instanceof ITranslatableProperty) {
            ITranslatableProperty soldierProperty = (ITranslatableProperty)propertyValue;
            class_2561 displayName = soldierProperty.getAnimatedDisplayName((class_1309)class_310.method_1551().field_1724);
            if (displayName != null) {
                propertyComponent.method_10852(displayName);
            }
        } else {
            List<class_2561> compList = ComponentFormating.formatProperty(property, soldier);
            if (compList.isEmpty()) {
                tooltip.removeLast();
                return;
            }
            propertyComponent.method_10852(compList.getFirst());
            for (int i = 1; i < compList.size(); ++i) {
                tooltip.add(compList.get(i));
            }
        }
    }

    private static void formatList(List<class_2561> tooltip, Iterable<?> values) {
        for (Object value : values) {
            class_5250 propertyComponent = class_5244.method_48320();
            tooltip.add((class_2561)propertyComponent);
            propertyComponent.method_10852(class_5244.field_41874);
            propertyComponent.method_10852(class_5244.field_41874).method_27692(class_124.field_1063);
            if (value instanceof ITranslatableProperty) {
                ITranslatableProperty soldierProperty = (ITranslatableProperty)value;
                class_2561 displayName = soldierProperty.getAnimatedDisplayName((class_1309)class_310.method_1551().field_1724);
                if (displayName == null) continue;
                propertyComponent.method_10852(displayName);
                continue;
            }
            propertyComponent.method_10852((class_2561)class_2561.method_43470((String)value.toString()));
        }
    }

    private static <T> List<class_2561> formatProperty(SoldierProperty<T> property, @Nullable ClaySoldierInventoryQuery soldier) {
        return property.type().getDisplayNameWithValue(property.value(), soldier);
    }

    public static void formatClayHorseProperties(@Nullable ClayHorseWearableProperties effect, List<class_2561> tooltip) {
        if (effect == null) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)CLAY_HORSE_PROPERTIES_EQUIP).method_27692(class_124.field_1063));
        if (effect.protection() != 0.0f) {
            tooltip.add((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43469((String)CLAY_HORSE_PROTECTION, (Object[])new Object[]{Float.valueOf(effect.protection())})).method_27692(class_124.field_1063));
        }
    }

    public static <T> void formatListDisplayNames(List<class_2561> tooltip, Collection<T> effects, class_2561 heading, Function<T, class_2561> displayNameGetter) {
        if (!effects.isEmpty()) {
            tooltip.add((class_2561)class_5244.method_48320().method_10852(heading).method_27692(class_124.field_1063));
        }
        for (T effect : effects) {
            class_2561 displayName = displayNameGetter.apply(effect);
            if (displayName == null) continue;
            tooltip.add((class_2561)class_2561.method_43470((String)DOUBLE_SPACE).method_10852(displayName).method_27692(class_124.field_1063));
        }
    }

    public static <T> void formatListDisplayNamesMultiLine(List<class_2561> tooltip, Collection<T> effects, class_2561 heading, Function<T, List<class_2561>> displayNameGetter) {
        if (!effects.isEmpty()) {
            tooltip.add((class_2561)class_5244.method_48320().method_10852(heading).method_27692(class_124.field_1063));
        }
        for (T effect : effects) {
            displayNameGetter.apply(effect).forEach(component -> tooltip.add((class_2561)class_2561.method_43470((String)DOUBLE_SPACE).method_10852(component).method_27692(class_124.field_1063)));
        }
    }
}

