/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.util.color;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5253;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ColorHelper {
    public static final int DEFAULT_CLAY_COLOR = -6182991;
    public static final Codec<ColorHelper> CODEC = Codec.either((Codec)Codec.INT, (Codec)Codec.string((int)4, (int)7)).comapFlatMap(ColorHelper::getFromEither, ColorHelper::convertToEither);
    public static final class_9139<ByteBuf, ColorHelper> STREAM_CODEC = class_9135.method_57995((class_9139)class_9135.field_49675, (class_9139)class_9135.field_48554).method_56432(ColorHelper::new, ColorHelper::convertToEither);
    public static final ColorHelper EMPTY = ColorHelper.color(-1);
    public static final String JEB_NAME = "jeb_";
    private static final int MAGIC_NUMBER = 25;
    private static final String INT_COLOR_TAG = "color";
    private final int color;
    private final boolean jeb;

    public ColorHelper(int color, boolean jeb) {
        this.color = color;
        this.jeb = jeb;
    }

    private ColorHelper(Either<Integer, String> either) {
        this(either.left().orElse(-1), either.right().isPresent());
    }

    private static DataResult<ColorHelper> getFromEither(Either<Integer, String> either) {
        if (either.left().isPresent()) {
            return DataResult.success((Object)ColorHelper.color((Integer)either.left().get()));
        }
        String name = (String)either.right().orElseThrow();
        if (name.equals(JEB_NAME)) {
            return DataResult.success((Object)ColorHelper.jeb());
        }
        if (name.matches("^#[0-9A-Fa-f]{6}$")) {
            return DataResult.success((Object)ColorHelper.color(Integer.parseInt(name.substring(1), 16)));
        }
        return DataResult.error(() -> "Invalid hex format. Expected format: #RRGGBB");
    }

    private Either<Integer, String> convertToEither() {
        return this.jeb ? Either.right((Object)JEB_NAME) : Either.left((Object)this.color);
    }

    public void writeToTag(String key, class_2487 tag) {
        class_2487 tagColor = new class_2487();
        if (this.color >= 0) {
            tagColor.method_10569(INT_COLOR_TAG, this.color);
        }
        if (this.jeb) {
            tagColor.method_10556(JEB_NAME, true);
        }
        tag.method_10566(key, (class_2520)tagColor);
    }

    public static ColorHelper getFromTag(String key, class_2487 tag) {
        if (!tag.method_10573(key, 10)) {
            return EMPTY;
        }
        class_2487 colorTag = tag.method_10562(key);
        return new ColorHelper(colorTag.method_10573(INT_COLOR_TAG, 99) ? colorTag.method_10550(INT_COLOR_TAG) : -1, colorTag.method_10545(JEB_NAME));
    }

    public static ColorHelper jeb() {
        return new ColorHelper((Either<Integer, String>)Either.right((Object)JEB_NAME));
    }

    public static ColorHelper color(int color) {
        return new ColorHelper((Either<Integer, String>)Either.left((Object)color));
    }

    public String toString() {
        return "Color(" + this.color + (this.jeb ? ",jeb)" : ")");
    }

    private String format() {
        if (this.jeb) {
            return "Jeb_";
        }
        return String.format("#%06x", this.color & 0xFFFFFF).toUpperCase(Locale.ROOT);
    }

    public class_2561 formatDynamic(class_1309 entity) {
        return class_2561.method_43470((String)this.format()).method_54663(this.getColor(entity, 0.0f));
    }

    public int getColor(class_1309 entity, float pPartialTicks) {
        return this.getColor(entity.method_5628(), entity.field_6012, pPartialTicks);
    }

    public int getColor(int offset, int tickCount, float pPartialTicks) {
        if (this.jeb) {
            int k = tickCount / 25 + offset;
            int colorValues = class_1767.values().length;
            int colorIdMin = k % colorValues;
            int colorIdMax = (k + 1) % colorValues;
            float lerp = ((float)(tickCount % 25) + pPartialTicks) / 25.0f;
            int min = class_1472.method_6634((class_1767)class_1767.method_7791((int)colorIdMin));
            int max = class_1472.method_6634((class_1767)class_1767.method_7791((int)colorIdMax));
            return class_5253.class_5254.method_48780((float)lerp, (int)min, (int)max);
        }
        return this.color;
    }

    public boolean isEmpty() {
        return !this.jeb && this.color <= -1;
    }

    public boolean isJeb() {
        return this.jeb;
    }

    public boolean hasStaticColor() {
        return this.color >= 0;
    }

    public int[] covertToRgb() {
        if (this.color <= -1) {
            return new int[0];
        }
        int red = this.color >> 16 & 0xFF;
        int green = this.color >> 8 & 0xFF;
        int blue = this.color & 0xFF;
        return new int[]{red, green, blue};
    }

    public int getColorStatic() {
        return this.color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorHelper that = (ColorHelper)o;
        return this.color == that.color && this.jeb == that.jeb;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.jeb);
    }

    public ColorHelper addColor(ColorHelper colorHelper) {
        if (this.color <= -1) {
            return new ColorHelper(colorHelper.color, this.jeb || colorHelper.jeb);
        }
        if (colorHelper.color <= -1) {
            return new ColorHelper(this.color, this.jeb || colorHelper.jeb);
        }
        return this.dyeColorHelper(colorHelper.covertToRgb(), this.jeb || colorHelper.jeb);
    }

    private ColorHelper dyeColorHelper(int[] colorAdded, boolean jeb) {
        int[] newColorArray = new int[3];
        int heightsValueOfEveryColorArray = 0;
        int[] currentColor = this.covertToRgb();
        int soldierRed = currentColor[0];
        int soldierGreen = currentColor[1];
        int soldierBlue = currentColor[2];
        heightsValueOfEveryColorArray += Math.max(soldierRed, Math.max(soldierGreen, soldierBlue));
        newColorArray[0] = newColorArray[0] + soldierRed;
        newColorArray[1] = newColorArray[1] + soldierGreen;
        newColorArray[2] = newColorArray[2] + soldierBlue;
        int dyeRed = colorAdded[0];
        int dyeGreen = colorAdded[1];
        int dyeBlue = colorAdded[2];
        newColorArray[0] = newColorArray[0] + dyeRed;
        newColorArray[1] = newColorArray[1] + dyeGreen;
        newColorArray[2] = newColorArray[2] + dyeBlue;
        return new ColorHelper(ColorHelper.getColorInt(newColorArray, heightsValueOfEveryColorArray += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue))), jeb);
    }

    private static int getColorInt(int[] newColorArray, float heightsValueOfEveryColorArray) {
        int newRed = newColorArray[0] / 2;
        int newGreen = newColorArray[1] / 2;
        int newBlue = newColorArray[2] / 2;
        float averageMaxValueOfEveryColor = heightsValueOfEveryColorArray / 2.0f;
        float maxAverageValue = Math.max(newRed, Math.max(newGreen, newBlue));
        newRed = (int)((float)newRed * averageMaxValueOfEveryColor / maxAverageValue);
        newGreen = (int)((float)newGreen * averageMaxValueOfEveryColor / maxAverageValue);
        newBlue = (int)((float)newBlue * averageMaxValueOfEveryColor / maxAverageValue);
        int colorInt = (newRed << 8) + newGreen;
        colorInt = (colorInt << 8) + newBlue;
        return colorInt;
    }
}

