/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityNowhereDisappear {
    private static final HashMap<UUID, Long> teleportedPlayers = new HashMap();
    private static final HashMap<UUID, ReturnData> returnData = new HashMap();
    private static final HashMap<UUID, LostLandsCoords> lostLandsCoords = new HashMap();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            Player player = event.player;
            UUID playerId = player.m_20148_();
            if (teleportedPlayers.containsKey(playerId)) {
                long teleportTime = teleportedPlayers.get(playerId);
                long currentTime = player.m_9236_().m_46467_();
                if (currentTime - teleportTime >= 600L) {
                    EntityNowhereDisappear.returnPlayer(player);
                    teleportedPlayers.remove(playerId);
                    returnData.remove(playerId);
                    lostLandsCoords.remove(playerId);
                    return;
                }
            }
            if (player.m_9236_().m_46472_().m_135782_().toString().equals("dont_look_into_the_fog:lost_lands")) {
                return;
            }
            for (Entity entity : player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(20.0))) {
                String entityName = entity.m_7755_().getString();
                if (!entityName.contains("WHO IS THERE") || !(player.m_20280_(entity) <= 16.0)) continue;
                double originalX = player.m_20185_();
                double originalY = player.m_20186_();
                double originalZ = player.m_20189_();
                ResourceKey originalDim = player.m_9236_().m_46472_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, true));
                returnData.put(playerId, new ReturnData(originalX, originalY, originalZ, (ResourceKey<Level>)originalDim));
                double lostLandsX = originalX + (player.m_9236_().f_46441_.m_188500_() * 200.0 - 100.0);
                double lostLandsZ = originalZ + (player.m_9236_().f_46441_.m_188500_() * 200.0 - 100.0);
                lostLandsCoords.put(playerId, new LostLandsCoords(lostLandsX, 0.0, lostLandsZ));
                teleportedPlayers.put(playerId, player.m_9236_().m_46467_());
                EntityNowhereDisappear.teleportToLostLands(player, lostLandsX, lostLandsZ);
                if (player instanceof ServerPlayer) {
                    AdvancementProgress progress;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Advancement advancement = serverPlayer.f_8924_.m_129889_().m_136041_(new ResourceLocation("dont_look_into_the_fog", "who"));
                    if (advancement != null && !(progress = serverPlayer.m_8960_().m_135996_(advancement)).m_8193_()) {
                        for (String criterion : progress.m_8219_()) {
                            serverPlayer.m_8960_().m_135988_(advancement, criterion);
                        }
                    }
                }
                entity.m_146870_();
                break;
            }
        }
    }

    private static void teleportToLostLands(Player player, double targetX, double targetZ) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ResourceKey lostLandsKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("dont_look_into_the_fog", "lost_lands"));
            ServerLevel targetLevel = serverPlayer.f_8924_.m_129880_(lostLandsKey);
            if (targetLevel == null && (targetLevel = serverPlayer.f_8924_.m_129880_(Level.f_46429_)) == null) {
                targetLevel = serverPlayer.f_8924_.m_129783_();
            }
            if (targetLevel != null) {
                int spawnY = EntityNowhereDisappear.findOrCreateSpawnPlatform(targetLevel, (int)targetX, (int)targetZ);
                UUID playerId = player.m_20148_();
                if (lostLandsCoords.containsKey(playerId)) {
                    LostLandsCoords coords = lostLandsCoords.get(playerId);
                    coords.y = spawnY;
                }
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 80, 0, false, true));
                serverPlayer.m_8999_(targetLevel, targetX, (double)(spawnY + 1), targetZ, player.m_146908_(), player.m_146909_());
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0, false, true));
            }
        }
    }

    private static int findOrCreateSpawnPlatform(ServerLevel level, int x, int z) {
        for (int radius = 0; radius <= 10; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int checkZ;
                    int checkX;
                    int groundY;
                    if (Math.abs(dx) != radius && Math.abs(dz) != radius || (groundY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, checkX = x + dx, checkZ = z + dz)) <= level.m_141937_() + 1) continue;
                    EntityNowhereDisappear.createBedrockPlatform(level, checkX, groundY + 1, checkZ);
                    return groundY + 1;
                }
            }
        }
        int platformY = 64;
        EntityNowhereDisappear.createBedrockPlatform(level, x, platformY, z);
        return platformY;
    }

    private static void createBedrockPlatform(ServerLevel level, int centerX, int y, int centerZ) {
        Block bedrock = Blocks.f_50752_;
        BlockState bedrockState = bedrock.m_49966_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos pos = new BlockPos(centerX + dx, y, centerZ + dz);
                if (level.m_8055_(pos).m_60734_() != Blocks.f_50016_ && level.m_8055_(pos).m_60734_() != Blocks.f_49990_ && level.m_8055_(pos).m_60734_() != Blocks.f_49991_) continue;
                level.m_7731_(pos, bedrockState, 3);
            }
        }
    }

    private static void returnPlayer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ReturnData data = returnData.get(player.m_20148_());
            if (data != null) {
                ServerLevel targetLevel = serverPlayer.f_8924_.m_129880_(data.dimension);
                if (targetLevel == null) {
                    targetLevel = serverPlayer.f_8924_.m_129783_();
                }
                int safeY = EntityNowhereDisappear.findSafeReturnY(targetLevel, (int)data.x, (int)data.z);
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 80, 0, false, true));
                serverPlayer.m_8999_(targetLevel, data.x, (double)safeY, data.z, player.m_146908_(), player.m_146909_());
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0, false, true));
            }
        }
    }

    private static int findSafeReturnY(ServerLevel level, int x, int z) {
        int groundY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        if (groundY <= level.m_141937_() + 1) {
            EntityNowhereDisappear.createBedrockPlatform(level, x, 64, z);
            return 65;
        }
        return groundY + 1;
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            UUID playerId = event.getEntity().m_20148_();
            teleportedPlayers.remove(playerId);
            returnData.remove(playerId);
            lostLandsCoords.remove(playerId);
        }
    }

    private static class ReturnData {
        double x;
        double y;
        double z;
        ResourceKey<Level> dimension;

        ReturnData(double x, double y, double z, ResourceKey<Level> dim) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimension = dim;
        }
    }

    private static class LostLandsCoords {
        double x;
        double y;
        double z;

        LostLandsCoords(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

