/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.mcreator.dontlookintothefog.init.DontLookIntoTheFogModItems;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GlazaControl {
    public static final int MAX_VISION_STATE = 2;
    public static final int RECOVERY_TIME = 2400;
    private static KeyMapping toggleVisionKey;
    private static boolean keyWasPressed;
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER;
    private static int messageID;

    public static PlayerVisionData getPlayerVisionData(Player player) {
        if (player == null) {
            return null;
        }
        if (player.m_9236_().m_5776_()) {
            UUID playerId = player.m_20148_();
            return ClientDataHolder.getPlayerData(playerId);
        }
        WorldVisionData worldData = WorldVisionData.get(player.m_9236_());
        if (worldData != null) {
            return worldData.getPlayerData(player.m_20148_());
        }
        return new PlayerVisionData();
    }

    public static void setPlayerVisionData(Player player, PlayerVisionData data) {
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        WorldVisionData worldData = WorldVisionData.get(player.m_9236_());
        if (worldData != null) {
            worldData.setPlayerData(player.m_20148_(), data);
        }
    }

    public GlazaControl() {
        PACKET_HANDLER.registerMessage(messageID++, AchievementRequestPacket.class, AchievementRequestPacket::encode, AchievementRequestPacket::decode, AchievementRequestPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        PACKET_HANDLER.registerMessage(messageID++, AchievementConfirmationPacket.class, AchievementConfirmationPacket::encode, AchievementConfirmationPacket::decode, AchievementConfirmationPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        PACKET_HANDLER.registerMessage(messageID++, PlayerVisionUpdatePacket.class, PlayerVisionUpdatePacket::encode, PlayerVisionUpdatePacket::decode, PlayerVisionUpdatePacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        PACKET_HANDLER.registerMessage(messageID++, ToggleVisionPacket.class, ToggleVisionPacket::encode, ToggleVisionPacket::decode, ToggleVisionPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        new GlazaControl();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        toggleVisionKey = new KeyMapping("key.dontlookintothefog.toggle_vision", InputConstants.Type.KEYSYM, 71, "category.dontlookintothefog.keys");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        if (toggleVisionKey != null) {
            event.register(toggleVisionKey);
        }
    }

    static {
        keyWasPressed = false;
        PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dont_look_into_the_fog", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        messageID = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ClientDataHolder {
        private static final Map<UUID, PlayerVisionData> clientPlayerData = new HashMap<UUID, PlayerVisionData>();

        private ClientDataHolder() {
        }

        public static PlayerVisionData getPlayerData(UUID playerId) {
            return clientPlayerData.computeIfAbsent(playerId, k -> new PlayerVisionData());
        }

        public static void updatePlayerData(UUID playerId, PlayerVisionData data) {
            clientPlayerData.put(playerId, data);
        }

        public static void clear() {
            clientPlayerData.clear();
        }
    }

    public static class PlayerVisionData {
        public int visionState = 0;
        public int recoveryTimer = 0;

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("visionState", this.visionState);
            tag.m_128405_("recoveryTimer", this.recoveryTimer);
            return tag;
        }

        public void load(CompoundTag tag) {
            this.visionState = tag.m_128451_("visionState");
            this.recoveryTimer = tag.m_128451_("recoveryTimer");
        }

        public boolean increaseVisionState() {
            if (this.visionState < 2) {
                ++this.visionState;
                return true;
            }
            return false;
        }

        public boolean decreaseVisionState() {
            if (this.visionState > 0) {
                --this.visionState;
                return true;
            }
            return false;
        }
    }

    public static class WorldVisionData
    extends SavedData {
        private final Map<UUID, PlayerVisionData> playerData = new HashMap<UUID, PlayerVisionData>();

        public WorldVisionData() {
            this.m_77762_();
        }

        public PlayerVisionData getPlayerData(UUID playerId) {
            return this.playerData.computeIfAbsent(playerId, k -> new PlayerVisionData());
        }

        public void setPlayerData(UUID playerId, PlayerVisionData data) {
            this.playerData.put(playerId, data);
            this.m_77762_();
        }

        public static WorldVisionData load(CompoundTag tag) {
            WorldVisionData data = new WorldVisionData();
            CompoundTag playersTag = tag.m_128469_("players");
            for (String key : playersTag.m_128431_()) {
                UUID playerId = UUID.fromString(key);
                PlayerVisionData playerData = new PlayerVisionData();
                playerData.load(playersTag.m_128469_(key));
                data.playerData.put(playerId, playerData);
            }
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            CompoundTag playersTag = new CompoundTag();
            for (Map.Entry<UUID, PlayerVisionData> entry : this.playerData.entrySet()) {
                playersTag.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().save());
            }
            tag.m_128365_("players", (Tag)playersTag);
            return tag;
        }

        public static WorldVisionData get(Level level) {
            if (level.m_5776_()) {
                return null;
            }
            DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
            return (WorldVisionData)storage.m_164861_(WorldVisionData::load, WorldVisionData::new, "glaza_vision_data");
        }
    }

    public static class AchievementRequestPacket {
        public static void encode(AchievementRequestPacket msg, FriendlyByteBuf buf) {
        }

        public static AchievementRequestPacket decode(FriendlyByteBuf buf) {
            return new AchievementRequestPacket();
        }

        public static void handle(AchievementRequestPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player != null) {
                    AdvancementProgress progress;
                    Advancement advancement;
                    ResourceLocation achievementId = new ResourceLocation("dont_look_into_the_fog", "first_glaza_minus");
                    MinecraftServer server = player.m_20194_();
                    if (server != null && (advancement = server.m_129889_().m_136041_(achievementId)) != null && !(progress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
                        for (String criterion : progress.m_8219_()) {
                            player.m_8960_().m_135988_(advancement, criterion);
                        }
                        PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AchievementConfirmationPacket());
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class AchievementConfirmationPacket {
        public static void encode(AchievementConfirmationPacket msg, FriendlyByteBuf buf) {
        }

        public static AchievementConfirmationPacket decode(FriendlyByteBuf buf) {
            return new AchievementConfirmationPacket();
        }

        public static void handle(AchievementConfirmationPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null && minecraft.f_91074_.m_9236_().m_5776_()) {
                    minecraft.f_91074_.m_9236_().m_6263_((Player)minecraft.f_91074_, minecraft.f_91074_.m_20185_(), minecraft.f_91074_.m_20186_(), minecraft.f_91074_.m_20189_(), SoundEvents.f_12288_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class PlayerVisionUpdatePacket {
        private final UUID playerId;
        private final int visionState;
        private final int recoveryTimer;

        public PlayerVisionUpdatePacket(UUID playerId, int visionState, int recoveryTimer) {
            this.playerId = playerId;
            this.visionState = visionState;
            this.recoveryTimer = recoveryTimer;
        }

        public static void encode(PlayerVisionUpdatePacket msg, FriendlyByteBuf buf) {
            buf.m_130077_(msg.playerId);
            buf.writeInt(msg.visionState);
            buf.writeInt(msg.recoveryTimer);
        }

        public static PlayerVisionUpdatePacket decode(FriendlyByteBuf buf) {
            return new PlayerVisionUpdatePacket(buf.m_130259_(), buf.readInt(), buf.readInt());
        }

        public static void handle(PlayerVisionUpdatePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            contextSupplier.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide().isClient()) {
                    PlayerVisionData data;
                    Minecraft minecraft = Minecraft.m_91087_();
                    if (minecraft.f_91074_ != null && minecraft.f_91074_.m_20148_().equals(msg.playerId) && (data = GlazaControl.getPlayerVisionData((Player)minecraft.f_91074_)) != null) {
                        data.visionState = msg.visionState;
                        data.recoveryTimer = msg.recoveryTimer;
                    }
                }
            });
            contextSupplier.get().setPacketHandled(true);
        }
    }

    public static class ToggleVisionPacket {
        private final UUID playerId;

        public ToggleVisionPacket(UUID playerId) {
            this.playerId = playerId;
        }

        public static void encode(ToggleVisionPacket msg, FriendlyByteBuf buf) {
            buf.m_130077_(msg.playerId);
        }

        public static ToggleVisionPacket decode(FriendlyByteBuf buf) {
            return new ToggleVisionPacket(buf.m_130259_());
        }

        public static void handle(ToggleVisionPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                PlayerVisionData data;
                ServerPlayer player = context.getSender();
                if (player != null && player.m_20148_().equals(msg.playerId) && (data = GlazaControl.getPlayerVisionData((Player)player)) != null && data.recoveryTimer <= 0 && data.visionState < 2) {
                    ++data.visionState;
                    player.m_6469_(player.m_269291_().m_269264_(), 4.0f);
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12323_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ItemStack glazaItem = new ItemStack((ItemLike)DontLookIntoTheFogModItems.GLAZA.get(), 1);
                    if (!player.m_150109_().m_36054_(glazaItem)) {
                        player.m_36176_(glazaItem, false);
                    }
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f);
                    if (data.visionState == 2) {
                        data.recoveryTimer = 2400;
                    }
                    GlazaControl.setPlayerVisionData((Player)player, data);
                    PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PlayerVisionUpdatePacket(player.m_20148_(), data.visionState, data.recoveryTimer));
                }
            });
            context.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber
    private static class GlazaControlForgeBusEvents {
        private GlazaControlForgeBusEvents() {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.NORMAL)
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player;
            PlayerVisionData data;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null || minecraft.f_91080_ != null) {
                return;
            }
            boolean isKeyPressed = toggleVisionKey.m_90857_();
            if (isKeyPressed && !keyWasPressed && (data = GlazaControl.getPlayerVisionData((Player)(player = minecraft.f_91074_))) != null) {
                if (data.visionState == 0) {
                    PACKET_HANDLER.sendToServer((Object)new AchievementRequestPacket());
                }
                if (data.recoveryTimer <= 0 && data.visionState < 2) {
                    PACKET_HANDLER.sendToServer((Object)new ToggleVisionPacket(player.m_20148_()));
                    ++data.visionState;
                    if (data.visionState == 2) {
                        data.recoveryTimer = 2400;
                    }
                }
            }
            keyWasPressed = isKeyPressed;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && (data = GlazaControl.getPlayerVisionData((Player)mc.f_91074_)) != null && data.recoveryTimer > 0) {
                --data.recoveryTimer;
            }
        }

        @SubscribeEvent
        public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
            Level world = event.getLevel();
            if (world.m_5776_()) {
                return;
            }
            Player player = event.getEntity();
            ItemStack itemstack = event.getItemStack();
            if (itemstack.m_41720_() == DontLookIntoTheFogModItems.GLAZA.get()) {
                PlayerVisionData data = GlazaControl.getPlayerVisionData(player);
                if (data != null && data.visionState > 0) {
                    --data.visionState;
                    if (data.recoveryTimer > 0) {
                        data.recoveryTimer = 0;
                    }
                    if (player instanceof ServerPlayer) {
                        itemstack.m_41774_(1);
                        player.m_36335_().m_41524_(itemstack.m_41720_(), 20);
                        GlazaControl.setPlayerVisionData(player, data);
                        PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlayerVisionUpdatePacket(player.m_20148_(), data.visionState, data.recoveryTimer));
                    }
                    event.setResult(Event.Result.DENY);
                    event.setCanceled(true);
                } else {
                    event.setResult(Event.Result.DENY);
                    event.setCanceled(true);
                }
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onRenderFog(ViewportEvent.RenderFog event) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            PlayerVisionData data = GlazaControl.getPlayerVisionData((Player)minecraft.f_91074_);
            if (data == null || data.visionState == 0) {
                return;
            }
            if (data.visionState == 1) {
                event.setNearPlaneDistance(2.0f);
                event.setFarPlaneDistance(8.0f);
                event.setCanceled(true);
            } else if (data.visionState == 2) {
                event.setNearPlaneDistance(0.1f);
                event.setFarPlaneDistance(0.5f);
                event.setCanceled(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onFogColor(ViewportEvent.ComputeFogColor event) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            PlayerVisionData data = GlazaControl.getPlayerVisionData((Player)minecraft.f_91074_);
            if (data == null) {
                return;
            }
            if (data.visionState == 2) {
                event.setRed(0.0f);
                event.setGreen(0.0f);
                event.setBlue(0.0f);
            } else if (data.visionState == 1) {
                event.setRed(event.getRed() * 0.5f);
                event.setGreen(event.getGreen() * 0.5f);
                event.setBlue(event.getBlue() * 0.5f);
            }
        }
    }
}

