/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class LostLandsSettings {
    private static boolean isLostLands(Level world) {
        return world.m_46472_().m_135782_().toString().contains("lost_lands");
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        Level world;
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_() && LostLandsSettings.isLostLands(world = (player = event.player).m_9236_())) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, true, false));
            BlockPos posUnderPlayer = BlockPos.m_274561_((double)player.m_20185_(), (double)(player.m_20186_() - 0.1), (double)player.m_20189_());
            BlockState stateUnder = world.m_8055_(posUnderPlayer);
            if (stateUnder.m_60734_() == Blocks.f_50723_ && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerLevel overworld = serverPlayer.f_8924_.m_129880_(Level.f_46428_);
                if (overworld != null) {
                    BlockPos spawnPos = overworld.m_220360_();
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    serverPlayer.m_8999_(overworld, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_() + 1.0, (double)spawnPos.m_123343_() + 0.5, serverPlayer.m_146908_(), serverPlayer.m_146909_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        Level world;
        LevelAccessor levelAccessor;
        if (!event.getLevel().m_5776_() && (levelAccessor = event.getLevel()) instanceof Level && LostLandsSettings.isLostLands(world = (Level)levelAccessor)) {
            ChunkAccess chunk = event.getChunk();
            LostLandsSettings.clearAndBuild(chunk);
        }
    }

    private static void clearAndBuild(ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        ChunkPos cPos = chunk.m_7697_();
        Random random = new Random(cPos.m_45588_());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = chunk.m_141937_(); y < chunk.m_151558_(); ++y) {
                    chunk.m_6978_((BlockPos)pos.m_122178_(x, y, z), Blocks.f_50016_.m_49966_(), false);
                }
            }
        }
        int minY = 64;
        int midY = 96;
        int maxY = 128;
        LostLandsSettings.generateSection(chunk, 0, 15, minY, midY, 0, 15);
        LostLandsSettings.generateSection(chunk, 0, 15, midY, maxY, 0, 15);
        if (cPos.f_45578_ == 0 && cPos.f_45579_ == 0) {
            for (int x = 7; x <= 8; ++x) {
                for (int z = 7; z <= 8; ++z) {
                    chunk.m_6978_((BlockPos)pos.m_122178_(x, 63, z), Blocks.f_50723_.m_49966_(), false);
                }
            }
        }
    }

    private static void generateSection(ChunkAccess chunk, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!LostLandsSettings.isFrame(x, y, z, minX, maxX, minY, maxY, minZ, maxZ)) continue;
                    chunk.m_6978_((BlockPos)pos.m_122178_(x, y, z), Blocks.f_50752_.m_49966_(), false);
                }
            }
        }
    }

    private static boolean isFrame(int x, int y, int z, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        boolean edgeX = x == minX || x == maxX;
        boolean edgeY = y == minY || y == maxY;
        boolean edgeZ = z == minZ || z == maxZ;
        return edgeX && edgeZ || edgeX && edgeY || edgeZ && edgeY;
    }
}

