/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class LostStrangerCopy {
    private static EntityType<?> cachedType = null;

    private static EntityType<?> getStrangerType() {
        if (cachedType != null) {
            return cachedType;
        }
        for (Map.Entry entry : ForgeRegistries.ENTITY_TYPES.getEntries()) {
            String name = ((ResourceKey)entry.getKey()).m_135782_().m_135815_();
            if (!name.contains("lost_stranger") && !name.contains("loststranger")) continue;
            cachedType = (EntityType)entry.getValue();
            return cachedType;
        }
        return null;
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
            if (!player.m_9236_().m_46472_().m_135782_().toString().contains("lost_lands")) {
                return;
            }
            BlockPos placedPos = event.getPos();
            BlockState state = event.getState();
            ServerLevel world = (ServerLevel)player.m_9236_();
            List strangers = world.m_142425_(LostStrangerCopy.getStrangerType(), player.m_20191_().m_82400_(64.0), e -> e.getPersistentData().m_128342_("copy_target").equals(player.m_20148_()));
            for (Entity stranger : strangers) {
                double offX = stranger.getPersistentData().m_128459_("off_x");
                double offZ = stranger.getPersistentData().m_128459_("off_z");
                BlockPos copyPos = new BlockPos((int)((double)placedPos.m_123341_() + offX), placedPos.m_123342_(), (int)((double)placedPos.m_123343_() + offZ));
                if (!world.m_46859_(copyPos)) continue;
                world.m_7731_(copyPos, state, 3);
                CompoundTag data = stranger.getPersistentData();
                ListTag blockList = data.m_128437_("placed_blocks", 10);
                blockList.add((Object)NbtUtils.m_129224_((BlockPos)copyPos));
                data.m_128365_("placed_blocks", (Tag)blockList);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player != null && !player.m_9236_().m_5776_()) {
            if (!player.m_9236_().m_46472_().m_135782_().toString().contains("lost_lands")) {
                return;
            }
            BlockPos brokenPos = event.getPos();
            ServerLevel world = (ServerLevel)player.m_9236_();
            List strangers = world.m_142425_(LostStrangerCopy.getStrangerType(), player.m_20191_().m_82400_(64.0), e -> e.getPersistentData().m_128342_("copy_target").equals(player.m_20148_()));
            for (Entity stranger : strangers) {
                double offX = stranger.getPersistentData().m_128459_("off_x");
                double offZ = stranger.getPersistentData().m_128459_("off_z");
                BlockPos copyPos = new BlockPos((int)((double)brokenPos.m_123341_() + offX), brokenPos.m_123342_(), (int)((double)brokenPos.m_123343_() + offZ));
                if (world.m_46859_(copyPos)) continue;
                world.m_7731_(copyPos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    @SubscribeEvent
    public static void onStrangerUpdate(LivingEvent.LivingTickEvent event) {
        CompoundTag data;
        LivingEntity entity = event.getEntity();
        EntityType<?> type = LostStrangerCopy.getStrangerType();
        if (type != null && entity.m_6095_() == type && !entity.m_9236_().m_5776_() && (data = entity.getPersistentData()).m_128441_("copy_target")) {
            Player target = entity.m_9236_().m_46003_(data.m_128342_("copy_target"));
            if (target != null && target.m_6084_()) {
                entity.m_146922_(target.m_146908_());
                entity.m_146926_(target.m_146909_());
                if (target.m_20184_().m_82556_() < 1.0E-4) {
                    int afk = data.m_128451_("target_afk_timer") + 1;
                    data.m_128405_("target_afk_timer", afk);
                    if (afk > 40 && entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    }
                } else {
                    data.m_128405_("target_afk_timer", 0);
                    entity.m_6021_(target.m_20185_() + data.m_128459_("off_x"), target.m_20186_(), target.m_20189_() + data.m_128459_("off_z"));
                }
                if (target.getPersistentData().m_128471_("stranger_event_used") || !target.getPersistentData().m_128471_("stranger_event_active")) {
                    LostStrangerCopy.removeCopiedBlocks((Entity)entity);
                    entity.m_146870_();
                }
            } else {
                LostStrangerCopy.removeCopiedBlocks((Entity)entity);
                entity.m_146870_();
            }
        }
    }

    private static void removeCopiedBlocks(Entity stranger) {
        Level level = stranger.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        CompoundTag data = stranger.getPersistentData();
        if (data.m_128441_("placed_blocks")) {
            ListTag blockList = data.m_128437_("placed_blocks", 10);
            for (int i = 0; i < blockList.size(); ++i) {
                BlockPos bPos = NbtUtils.m_129239_((CompoundTag)blockList.m_128728_(i));
                if (!world.m_46749_(bPos)) continue;
                world.m_7731_(bPos, Blocks.f_50016_.m_49966_(), 3);
            }
            data.m_128473_("placed_blocks");
        }
    }

    @SubscribeEvent
    public static void onChunkEnter(EntityEvent.EnteringSection event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player) || (player = (Player)entity).m_9236_().m_5776_()) {
            return;
        }
        if (!player.m_9236_().m_46472_().m_135782_().toString().contains("lost_lands")) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        if (data.m_128471_("stranger_event_used") || data.m_128471_("stranger_event_active")) {
            return;
        }
        if (event.didChunkChange() && Math.random() < 0.15) {
            LostStrangerCopy.startEvent(player);
        }
    }

    private static void startEvent(Player player) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        EntityType<?> type = LostStrangerCopy.getStrangerType();
        if (type == null) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        data.m_128379_("stranger_event_active", true);
        data.m_128347_("event_start_x", player.m_20185_());
        data.m_128347_("event_start_z", player.m_20189_());
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 1.5f, 0.7f);
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int zOff = -1; zOff <= 1; ++zOff) {
                Entity stranger;
                if (xOff == 0 && zOff == 0 || (stranger = type.m_20615_((Level)world)) == null) continue;
                stranger.getPersistentData().m_128347_("off_x", (double)xOff * 16.0);
                stranger.getPersistentData().m_128347_("off_z", (double)zOff * 16.0);
                stranger.getPersistentData().m_128362_("copy_target", player.m_20148_());
                stranger.m_7678_(player.m_20185_() + (double)xOff * 16.0, player.m_20186_(), player.m_20189_() + (double)zOff * 16.0, player.m_146908_(), player.m_146909_());
                world.m_7967_(stranger);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        CompoundTag data = event.player.getPersistentData();
        if (data.m_128471_("stranger_event_active")) {
            double startX = data.m_128459_("event_start_x");
            double startZ = data.m_128459_("event_start_z");
            if (event.player.m_20275_(startX, event.player.m_20186_(), startZ) > 40000.0) {
                data.m_128379_("stranger_event_active", false);
                data.m_128379_("stranger_event_used", true);
            }
        }
    }

    @SubscribeEvent
    public static void onDimChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getTo().m_135782_().toString().contains("lost_lands")) {
            event.getEntity().getPersistentData().m_128379_("stranger_event_used", false);
            event.getEntity().getPersistentData().m_128379_("stranger_event_active", false);
        }
    }
}

