/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class RandomEventManager {
    private static final Random random = new Random();
    private static int tickCounter = 0;
    private static final int EVENT_INTERVAL = 3300;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++tickCounter >= 3300) {
            tickCounter = 0;
            if (random.nextInt(100) < 60) {
                RandomEventManager.triggerRandomEvent();
            }
        }
    }

    private static void triggerRandomEvent() {
        for (Level level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            List players = serverLevel.m_6907_();
            if (players.isEmpty()) {
                return;
            }
            ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
            int chance = random.nextInt(100);
            if (chance < 50) {
                RandomEventManager.startRain(serverLevel);
                break;
            }
            if (chance < 80) {
                RandomEventManager.giveApple(randomPlayer);
                break;
            }
            RandomEventManager.strikeWithLightning(randomPlayer);
            break;
        }
    }

    private static void startRain(ServerLevel level) {
        level.m_8606_(0, 1200, true, true);
    }

    private static void giveApple(ServerPlayer player) {
        ItemStack apple = new ItemStack((ItemLike)Items.f_42410_);
        if (!player.m_150109_().m_36054_(apple)) {
            player.m_36176_(apple, false);
        }
    }

    private static void strikeWithLightning(ServerPlayer player) {
        BlockPos pos = player.m_20183_();
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, player.m_9236_());
        lightning.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        player.m_9236_().m_7967_((Entity)lightning);
    }
}

