/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class CameraOverlay {
    private static final long MINECRAFT_DAY_TICKS = 24000L;
    private static final long MINECRAFT_HOUR_TICKS = 1000L;
    private static final LocalDate START_DATE = LocalDate.of(2019, 8, 23);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd MMMM yyyy", new Locale("en"));
    private static final Map<String, WorldSharedData> worldSharedData = new HashMap<String, WorldSharedData>();
    private static final Map<String, Long> playerJoinTimes = new HashMap<String, Long>();
    private static String currentWorldKey = "";
    private static long lastBlinkTime = 0L;
    private static boolean recVisible = true;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void renderOverlay(RenderGuiEvent.Pre event) {
        long currentRealTime;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        int screenWidth = event.getWindow().m_85445_();
        int screenHeight = event.getWindow().m_85446_();
        ClientLevel level = mc.f_91073_;
        long worldTime = level.m_46468_();
        String worldKey = CameraOverlay.getWorldKey(level);
        if (!currentWorldKey.equals(worldKey)) {
            currentWorldKey = worldKey;
            String playerKey = mc.f_91074_.m_20149_() + "_" + worldKey;
            playerJoinTimes.put(playerKey, worldTime);
        }
        WorldSharedData worldData = worldSharedData.computeIfAbsent(worldKey, k -> new WorldSharedData());
        worldData.update(worldTime);
        String playerKey = mc.f_91074_.m_20149_() + "_" + worldKey;
        Long joinTime = playerJoinTimes.get(playerKey);
        if (joinTime == null) {
            joinTime = worldTime;
            playerJoinTimes.put(playerKey, joinTime);
        }
        if ((currentRealTime = System.currentTimeMillis()) - lastBlinkTime >= 5000L) {
            recVisible = !recVisible;
            lastBlinkTime = currentRealTime;
        }
        LocalDate currentDate = worldData.getCurrentDate();
        String dateText = currentDate.format(DATE_FORMATTER).toLowerCase();
        long sessionTicks = Math.max(0L, worldTime - joinTime);
        int sessionHours = (int)(sessionTicks / 1000L);
        int sessionMinutes = (int)(sessionTicks % 1000L * 60L / 1000L);
        String currentGameTime = worldData.getCurrentGameTime(worldTime);
        String timeText = String.format("%d:%02d (%s)", sessionHours, sessionMinutes, currentGameTime);
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        if (recVisible) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.5f, 1.5f, 1.5f);
            event.getGuiGraphics().m_280056_(mc.f_91062_, "REC", 5, 5, -65536, false);
            poseStack.m_85849_();
        }
        poseStack.m_85836_();
        poseStack.m_85841_(1.2f, 1.2f, 1.2f);
        int dateWidth = mc.f_91062_.m_92895_(dateText);
        float dateX = ((float)screenWidth - (float)dateWidth * 1.2f - 15.0f) / 1.2f;
        float dateY = (float)(screenHeight - 60) / 1.2f;
        event.getGuiGraphics().m_280056_(mc.f_91062_, dateText, (int)dateX, (int)dateY, -1, false);
        int timeWidth = mc.f_91062_.m_92895_(timeText);
        float timeX = ((float)screenWidth - (float)timeWidth * 1.2f - 15.0f) / 1.2f;
        float timeY = (float)(screenHeight - 45) / 1.2f;
        event.getGuiGraphics().m_280056_(mc.f_91062_, timeText, (int)timeX, (int)timeY, -1, false);
        poseStack.m_85849_();
    }

    private static String getWorldKey(ClientLevel level) {
        if (level == null) {
            return "unknown";
        }
        return level.m_46472_().m_135782_().toString();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        long worldTime = mc.f_91073_.m_46468_();
        String worldKey = CameraOverlay.getWorldKey(mc.f_91073_);
        WorldSharedData worldData = worldSharedData.get(worldKey);
        if (worldData != null) {
            worldData.update(worldTime);
        }
    }

    public static void resetCurrentWorld() {
        if (!currentWorldKey.isEmpty()) {
            worldSharedData.remove(currentWorldKey);
            playerJoinTimes.keySet().removeIf(key -> key.contains(currentWorldKey));
        }
    }

    public static void resetAll() {
        worldSharedData.clear();
        playerJoinTimes.clear();
        currentWorldKey = "";
        lastBlinkTime = 0L;
        recVisible = true;
    }

    public static String getCurrentDate() {
        if (currentWorldKey.isEmpty() || !worldSharedData.containsKey(currentWorldKey)) {
            return START_DATE.format(DATE_FORMATTER).toLowerCase();
        }
        return worldSharedData.get(currentWorldKey).getCurrentDate().format(DATE_FORMATTER).toLowerCase();
    }

    public static String getCurrentTime() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null || currentWorldKey.isEmpty()) {
            return "0:00 (00:00)";
        }
        long worldTime = mc.f_91073_.m_46468_();
        WorldSharedData worldData = worldSharedData.get(currentWorldKey);
        if (worldData == null) {
            return "0:00 (00:00)";
        }
        String playerKey = mc.f_91074_.m_20149_() + "_" + currentWorldKey;
        Long joinTime = playerJoinTimes.get(playerKey);
        if (joinTime == null) {
            return "0:00 (00:00)";
        }
        long sessionTicks = Math.max(0L, worldTime - joinTime);
        int sessionHours = (int)(sessionTicks / 1000L);
        int sessionMinutes = (int)(sessionTicks % 1000L * 60L / 1000L);
        String gameTime = worldData.getCurrentGameTime(worldTime);
        return String.format("%d:%02d (%s)", sessionHours, sessionMinutes, gameTime);
    }

    private static class WorldSharedData {
        int currentDay = 1;
        long referenceWorldTime = 0L;

        private WorldSharedData() {
        }

        void update(long worldTime) {
            int newDay = (int)(worldTime / 24000L + 1L);
            if (newDay != this.currentDay || this.referenceWorldTime == 0L) {
                this.currentDay = newDay;
                this.referenceWorldTime = worldTime - worldTime % 24000L;
            }
        }

        LocalDate getCurrentDate() {
            return START_DATE.plusDays(this.currentDay - 1);
        }

        String getCurrentGameTime(long worldTime) {
            long timeInDay = worldTime % 24000L;
            if (timeInDay < 0L) {
                timeInDay += 24000L;
            }
            int hour = (int)(timeInDay / 1000L);
            int minute = (int)(timeInDay % 1000L * 60L / 1000L);
            return String.format("%02d:%02d", hour, minute);
        }
    }
}

