/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dontlookintothefog.events;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class EvilFogEvent {
    private static final int MINUTES_FIRST_MESSAGE = 9;
    private static final int MINUTES_SECOND_MESSAGE = 10;
    private static final int MINUTES_FOG_SPAWN = 11;
    private static final int SECONDS_FOG_LIFETIME = 30;
    private static final int FIRST_MESSAGE = 10800;
    private static final int SECOND_MESSAGE = 12000;
    private static final int FOG_SPAWN = 13200;
    private static final int FOG_LIFETIME = 600;
    private static final float[] FOG_FAR_DISTANCES = new float[]{64.0f, 48.0f, 32.0f};
    private static final String[] MESSAGES = new String[]{"The fog is getting thicker", "Fog is coming", "HE IS HERE"};
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dont_look_into_the_fog", "fog_sync"), () -> "1", "1"::equals, "1"::equals);
    private static final Map<String, WorldFogData> worldFogData;
    private static final Map<UUID, ClientFogData> clientFogData;
    private static final ResourceLocation EVILFOG_ID;
    private static final Map<String, WorldInstance> worldInstances;

    public static float getFogDensity(UUID playerId) {
        ClientFogData data = clientFogData.get(playerId);
        return data != null ? data.fogDensity : 0.0f;
    }

    public static float getFogFarDistance(UUID playerId) {
        ClientFogData data = clientFogData.get(playerId);
        if (data != null && data.fogDensity > 0.0f) {
            return data.fogFarDistance * (1.0f - data.fogDensity * 0.3f);
        }
        return 64.0f;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        try {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                Entity killer;
                ServerPlayer killedPlayer = (ServerPlayer)livingEntity;
                Level level = killedPlayer.m_9236_();
                String worldKey = EvilFogEvent.getWorldKey(level);
                WorldInstance instance = worldInstances.get(worldKey);
                WorldFogData worldData = worldFogData.get(worldKey);
                if (instance != null && worldData != null && worldData.fogSpawned && worldData.fogEntityUUID != null && (killer = event.getSource().m_7640_()) != null && killer.m_20148_().equals(worldData.fogEntityUUID)) {
                    ServerLevel serverLevel;
                    Entity fogEntity;
                    if (level instanceof ServerLevel && (fogEntity = (serverLevel = (ServerLevel)level).m_8791_(worldData.fogEntityUUID)) != null) {
                        fogEntity.m_146870_();
                    }
                    instance.startFogDissipation(worldData);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in onLivingDeath: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        try {
            for (WorldInstance instance : worldInstances.values()) {
                instance.update();
            }
            for (WorldFogData worldData : worldFogData.values()) {
                if (!(worldData.fogDensity > 0.0f)) continue;
                worldData.syncToAllPlayers();
            }
            worldInstances.entrySet().removeIf(entry -> !((WorldInstance)entry.getValue()).hasActivePlayers());
            worldFogData.entrySet().removeIf(entry -> ((WorldFogData)entry.getValue()).playersInWorld.isEmpty());
        }
        catch (Exception e) {
            System.err.println("Error in onServerTick: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        try {
            ServerPlayer player = (ServerPlayer)event.player;
            Level level = player.m_9236_();
            String worldKey = EvilFogEvent.getWorldKey(level);
            worldInstances.computeIfAbsent(worldKey, k -> new WorldInstance(level)).addPlayer(player);
            WorldFogData worldData = worldFogData.computeIfAbsent(worldKey, k -> new WorldFogData());
            worldData.playersInWorld.add(player.m_20148_());
            if (worldData.fogDensity > 0.0f) {
                worldData.syncToPlayer(player.m_20148_());
            }
        }
        catch (Exception e) {
            System.err.println("Error in onPlayerTick: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        try {
            WorldFogData worldData;
            ServerPlayer player = (ServerPlayer)event.getEntity();
            String worldKey = EvilFogEvent.getWorldKey(player.m_9236_());
            WorldInstance instance = worldInstances.get(worldKey);
            if (instance != null) {
                instance.removePlayer(player);
            }
            if ((worldData = worldFogData.get(worldKey)) != null) {
                worldData.playersInWorld.remove(player.m_20148_());
            }
            clientFogData.remove(player.m_20148_());
        }
        catch (Exception e) {
            System.err.println("Error in onPlayerLogout: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        try {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            Level level = player.m_9236_();
            String worldKey = EvilFogEvent.getWorldKey(level);
            WorldFogData worldData = worldFogData.get(worldKey);
            if (worldData != null && worldData.fogDensity > 0.0f) {
                worldData.syncToPlayer(player.m_20148_());
            }
        }
        catch (Exception e) {
            System.err.println("Error in onPlayerLogin: " + e.getMessage());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            float density = EvilFogEvent.getFogDensity(minecraft.f_91074_.m_20148_());
            float farDistance = EvilFogEvent.getFogFarDistance(minecraft.f_91074_.m_20148_());
            if (density > 0.0f) {
                float nearPlane = 2.0f;
                float farPlane = farDistance;
                event.setNearPlaneDistance(nearPlane);
                event.setFarPlaneDistance(Math.max(nearPlane + 5.0f, farPlane));
                event.setCanceled(true);
            }
        }
        catch (Exception e) {
            System.err.println("Error in onRenderFog: " + e.getMessage());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ == null) {
                return;
            }
            float density = EvilFogEvent.getFogDensity(minecraft.f_91074_.m_20148_());
            if (density > 0.0f) {
                float fogIntensity = density * 0.7f;
                event.setRed(0.5f * (1.0f - fogIntensity) + 0.3f * fogIntensity);
                event.setGreen(0.5f * (1.0f - fogIntensity) + 0.3f * fogIntensity);
                event.setBlue(0.6f * (1.0f - fogIntensity) + 0.4f * fogIntensity);
            }
        }
        catch (Exception e) {
            System.err.println("Error in onFogColor: " + e.getMessage());
        }
    }

    private static String getWorldKey(Level level) {
        return level.m_46472_().m_135782_().toString();
    }

    static {
        int packetId = 0;
        CHANNEL.registerMessage(packetId++, FogDataPacket.class, FogDataPacket::encode, FogDataPacket::decode, FogDataPacket::handle);
        worldFogData = new ConcurrentHashMap<String, WorldFogData>();
        clientFogData = new ConcurrentHashMap<UUID, ClientFogData>();
        EVILFOG_ID = new ResourceLocation("dont_look_into_the_fog", "evilfog");
        worldInstances = new ConcurrentHashMap<String, WorldInstance>();
    }

    private static class ClientFogData {
        float fogDensity = 0.0f;
        float fogFarDistance = 64.0f;
        int fogPhase = 0;
        boolean hasFog = false;

        private ClientFogData() {
        }
    }

    private static class WorldInstance {
        private final Set<UUID> activePlayers = ConcurrentHashMap.newKeySet();
        private final Level world;
        private int timerTicks = 0;
        private int currentPhase = 0;
        private boolean fogSpawned = false;
        private UUID fogEntityUUID = null;
        private boolean isDissipating = false;
        private int dissipationTimer = 0;
        private boolean fogCycleCompleted = false;
        private int fogSpawnTimeTicks = 0;

        public WorldInstance(Level world) {
            this.world = world;
        }

        public void addPlayer(ServerPlayer player) {
            this.activePlayers.add(player.m_20148_());
        }

        public void removePlayer(ServerPlayer player) {
            this.activePlayers.remove(player.m_20148_());
        }

        public boolean hasActivePlayers() {
            return !this.activePlayers.isEmpty();
        }

        public void update() {
            if (!this.hasActivePlayers()) {
                this.reset();
                return;
            }
            String worldKey = EvilFogEvent.getWorldKey(this.world);
            WorldFogData worldData = worldFogData.get(worldKey);
            if (worldData == null) {
                return;
            }
            try {
                if (this.isDissipating) {
                    this.handleDissipation(worldData);
                    return;
                }
                if (this.fogCycleCompleted) {
                    if (this.timerTicks >= 19800) {
                        this.resetForNewCycle(worldData);
                    } else {
                        ++this.timerTicks;
                    }
                    return;
                }
                ++this.timerTicks;
                worldData.timerTicks = this.timerTicks;
                if (this.currentPhase == 0 && this.timerTicks >= 10800) {
                    this.broadcastMessage(MESSAGES[0]);
                    this.playCaveSounds();
                    worldData.fogDensity = 0.3f;
                    worldData.fogPhase = 1;
                    worldData.fogFarDistance = FOG_FAR_DISTANCES[0];
                    worldData.syncToAllPlayers();
                    this.currentPhase = 1;
                } else if (this.currentPhase == 1 && this.timerTicks >= 12000) {
                    this.broadcastMessage(MESSAGES[1]);
                    this.playCaveSounds();
                    worldData.fogDensity = 0.6f;
                    worldData.fogPhase = 2;
                    worldData.fogFarDistance = FOG_FAR_DISTANCES[1];
                    worldData.syncToAllPlayers();
                    this.currentPhase = 2;
                } else if (this.currentPhase == 2 && this.timerTicks >= 13200) {
                    this.broadcastMessage(MESSAGES[2]);
                    this.playCaveSounds();
                    worldData.fogDensity = 0.9f;
                    worldData.fogPhase = 3;
                    worldData.fogFarDistance = FOG_FAR_DISTANCES[2];
                    worldData.syncToAllPlayers();
                    this.currentPhase = 3;
                    this.fogSpawned = true;
                    worldData.fogSpawned = true;
                    this.fogSpawnTimeTicks = this.timerTicks;
                    this.spawnEvilfog(worldData);
                } else if (this.currentPhase == 3) {
                    this.checkFogEntity(worldData);
                    if (this.timerTicks >= this.fogSpawnTimeTicks + 600) {
                        this.startFogDissipation(worldData);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Error in WorldInstance.update: " + e.getMessage());
            }
        }

        private void checkFogEntity(WorldFogData worldData) {
            try {
                if (worldData.fogEntityUUID == null) {
                    this.startFogDissipation(worldData);
                    return;
                }
                Entity entity = ((ServerLevel)this.world).m_8791_(worldData.fogEntityUUID);
                if (entity == null || !entity.m_6084_()) {
                    worldData.fogEntityUUID = null;
                    this.startFogDissipation(worldData);
                }
            }
            catch (Exception e) {
                System.err.println("Error in checkFogEntity: " + e.getMessage());
            }
        }

        public void startFogDissipation(WorldFogData worldData) {
            if (this.isDissipating) {
                return;
            }
            try {
                Level level;
                this.isDissipating = true;
                this.dissipationTimer = 0;
                this.fogSpawned = false;
                worldData.isDissipating = true;
                worldData.fogSpawned = false;
                if (worldData.fogEntityUUID != null && (level = this.world) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Entity fogEntity = serverLevel.m_8791_(worldData.fogEntityUUID);
                    if (fogEntity != null) {
                        fogEntity.m_146870_();
                    }
                    worldData.fogEntityUUID = null;
                }
                this.broadcastMessage("The fog is dissipating...");
                worldData.syncToAllPlayers();
            }
            catch (Exception e) {
                System.err.println("Error in startFogDissipation: " + e.getMessage());
            }
        }

        private void handleDissipation(WorldFogData worldData) {
            try {
                float farDistance;
                float currentDensity;
                ++this.dissipationTimer;
                float progress = (float)this.dissipationTimer / 100.0f;
                if (progress > 1.0f) {
                    progress = 1.0f;
                }
                worldData.fogDensity = currentDensity = 0.9f * (1.0f - progress);
                if (currentDensity <= 0.01f) {
                    this.completeFogCycle(worldData);
                    return;
                }
                worldData.fogFarDistance = farDistance = FOG_FAR_DISTANCES[2] + (FOG_FAR_DISTANCES[0] - FOG_FAR_DISTANCES[2]) * progress;
                worldData.syncToAllPlayers();
            }
            catch (Exception e) {
                System.err.println("Error in handleDissipation: " + e.getMessage());
            }
        }

        private void completeFogCycle(WorldFogData worldData) {
            this.fogCycleCompleted = true;
            this.isDissipating = false;
            worldData.fogDensity = 0.0f;
            worldData.fogPhase = 0;
            worldData.isDissipating = false;
            worldData.syncToAllPlayers();
            this.broadcastMessage("The fog has completely dissipated.");
        }

        private void resetForNewCycle(WorldFogData worldData) {
            this.timerTicks = 0;
            this.currentPhase = 0;
            this.fogSpawned = false;
            this.fogEntityUUID = null;
            this.isDissipating = false;
            this.dissipationTimer = 0;
            this.fogCycleCompleted = false;
            this.fogSpawnTimeTicks = 0;
            worldData.fogDensity = 0.0f;
            worldData.fogPhase = 0;
            worldData.fogSpawned = false;
            worldData.fogEntityUUID = null;
            worldData.isDissipating = false;
            worldData.timerTicks = 0;
            worldData.syncToAllPlayers();
        }

        private void playCaveSounds() {
            try {
                for (UUID playerId : this.activePlayers) {
                    Player player = this.world.m_46003_(playerId);
                    if (player == null) continue;
                    this.world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.AMBIENT, 0.3f, 0.8f + this.world.f_46441_.m_188501_() * 0.4f);
                }
            }
            catch (Exception e) {
                System.err.println("Error in playCaveSounds: " + e.getMessage());
            }
        }

        private void broadcastMessage(String message) {
            try {
                for (UUID playerId : this.activePlayers) {
                    Player player = this.world.m_46003_(playerId);
                    if (player == null) continue;
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a77" + message)));
                }
            }
            catch (Exception e) {
                System.err.println("Error in broadcastMessage: " + e.getMessage());
            }
        }

        private void spawnEvilfog(WorldFogData worldData) {
            Level level = this.world;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            try {
                ArrayList<Player> players = new ArrayList<Player>();
                for (UUID playerId : this.activePlayers) {
                    Player player = this.world.m_46003_(playerId);
                    if (player == null) continue;
                    players.add(player);
                }
                if (players.isEmpty()) {
                    return;
                }
                Player targetPlayer = (Player)players.get(this.world.f_46441_.m_188503_(players.size()));
                BlockPos playerPos = targetPlayer.m_20183_();
                BlockPos spawnPos = this.findSpawnPositionInRadius(serverLevel, playerPos, 32);
                Optional evilfogTypeOpt = BuiltInRegistries.f_256780_.m_6612_(EVILFOG_ID);
                if (evilfogTypeOpt.isEmpty()) {
                    return;
                }
                Entity evilfog = ((EntityType)evilfogTypeOpt.get()).m_20615_((Level)serverLevel);
                if (evilfog == null) {
                    return;
                }
                double spawnX = (double)spawnPos.m_123341_() + 0.5;
                double spawnY = spawnPos.m_123342_();
                double spawnZ = (double)spawnPos.m_123343_() + 0.5;
                evilfog.m_7678_(spawnX, spawnY, spawnZ, this.world.f_46441_.m_188501_() * 360.0f, 0.0f);
                evilfog.m_6593_((Component)Component.m_237113_((String)"\u00a75FOG"));
                evilfog.m_20340_(true);
                if (serverLevel.m_7967_(evilfog)) {
                    worldData.fogEntityUUID = evilfog.m_20148_();
                    this.fogEntityUUID = evilfog.m_20148_();
                    String coordsMessage = String.format("\u00a7cFOG appeared on  %.0f %.0f %.0f", spawnX, spawnY, spawnZ);
                    this.broadcastMessage(coordsMessage);
                }
            }
            catch (Exception e) {
                System.err.println("Error in spawnEvilfog: " + e.getMessage());
            }
        }

        private BlockPos findSpawnPositionInRadius(ServerLevel level, BlockPos center, int radius) {
            for (int attempt = 0; attempt < 20; ++attempt) {
                double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
                double distance = 10.0 + level.f_46441_.m_188500_() * (double)(radius - 10);
                int x = center.m_123341_() + (int)(Math.cos(angle) * distance);
                int z = center.m_123343_() + (int)(Math.sin(angle) * distance);
                BlockPos testPos = new BlockPos(x, level.m_5736_(), z);
                BlockPos surfacePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, testPos);
                if (!this.isSafeSpawnPosition(level, surfacePos)) continue;
                return surfacePos;
            }
            return center.m_7918_(5, 0, 5);
        }

        private boolean isSafeSpawnPosition(ServerLevel level, BlockPos pos) {
            return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() <= level.m_151558_() && level.m_8055_(pos.m_7495_()).m_280296_() && level.m_8055_(pos).m_60795_() && level.m_8055_(pos.m_7494_()).m_60795_();
        }

        public void reset() {
            try {
                this.timerTicks = 0;
                this.currentPhase = 0;
                this.fogSpawned = false;
                this.fogEntityUUID = null;
                this.isDissipating = false;
                this.dissipationTimer = 0;
                this.fogCycleCompleted = false;
                this.fogSpawnTimeTicks = 0;
                String worldKey = EvilFogEvent.getWorldKey(this.world);
                WorldFogData worldData = worldFogData.get(worldKey);
                if (worldData != null) {
                    worldData.fogDensity = 0.0f;
                    worldData.fogPhase = 0;
                    worldData.fogSpawned = false;
                    worldData.fogEntityUUID = null;
                    worldData.isDissipating = false;
                    worldData.timerTicks = 0;
                    worldData.syncToAllPlayers();
                }
            }
            catch (Exception e) {
                System.err.println("Error in reset: " + e.getMessage());
            }
        }
    }

    private static class WorldFogData {
        float fogDensity = 0.0f;
        int fogPhase = 0;
        float fogFarDistance = 64.0f;
        boolean fogSpawned = false;
        UUID fogEntityUUID = null;
        boolean isDissipating = false;
        int timerTicks = 0;
        Set<UUID> playersInWorld = ConcurrentHashMap.newKeySet();

        private WorldFogData() {
        }

        public void syncToAllPlayers() {
            try {
                for (UUID playerId : this.playersInWorld) {
                    this.syncToPlayer(playerId);
                }
            }
            catch (Exception e) {
                System.err.println("Error syncing fog to all players: " + e.getMessage());
            }
        }

        public void syncToPlayer(UUID playerId) {
            try {
                ServerPlayer player;
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null && (player = server.m_6846_().m_11259_(playerId)) != null && !player.m_9236_().m_5776_()) {
                    CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new FogDataPacket(this.fogDensity, this.fogPhase, this.fogFarDistance, this.fogDensity > 0.0f));
                }
            }
            catch (Exception e) {
                System.err.println("Error syncing fog to player " + String.valueOf(playerId) + ": " + e.getMessage());
            }
        }
    }

    public static class FogDataPacket {
        private final float fogDensity;
        private final int fogPhase;
        private final float fogFarDistance;
        private final boolean hasFog;

        public FogDataPacket(float fogDensity, int fogPhase, float fogFarDistance, boolean hasFog) {
            this.fogDensity = fogDensity;
            this.fogPhase = fogPhase;
            this.fogFarDistance = fogFarDistance;
            this.hasFog = hasFog;
        }

        public void encode(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.fogDensity);
            buffer.writeInt(this.fogPhase);
            buffer.writeFloat(this.fogFarDistance);
            buffer.writeBoolean(this.hasFog);
        }

        public static FogDataPacket decode(FriendlyByteBuf buffer) {
            return new FogDataPacket(buffer.readFloat(), buffer.readInt(), buffer.readFloat(), buffer.readBoolean());
        }

        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                try {
                    if (((NetworkEvent.Context)context.get()).getDirection().getReceptionSide().isClient()) {
                        Minecraft client = Minecraft.m_91087_();
                        if (client.f_91074_ != null) {
                            UUID playerId = client.f_91074_.m_20148_();
                            ClientFogData data = clientFogData.computeIfAbsent(playerId, k -> new ClientFogData());
                            data.fogDensity = this.fogDensity;
                            data.fogPhase = this.fogPhase;
                            data.fogFarDistance = this.fogFarDistance;
                            data.hasFog = this.hasFog;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Error handling fog packet: " + e.getMessage());
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

