/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.tag;

import com.benbenlaw.core.tag.ModdedTagBuilder;
import com.benbenlaw.core.tag.ResourceNames;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class CommonTags {
    private static final Map<String, Map<ResourceType, TagKey<Item>>> TAGS = new HashMap<String, Map<ResourceType, TagKey<Item>>>();

    public static void init() {
        List<String> resources = CommonTags.getResourceNames();
        for (String resource : resources) {
            CommonTags.registerResourceTags(resource);
            CommonTags.registerRawStorageBlockTags(resource);
        }
    }

    private static List<String> getResourceNames() {
        return Arrays.stream(ResourceNames.class.getFields()).filter(field -> field.getType() == String.class).map(field -> {
            try {
                return (String)field.get(null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private static void registerResourceTags(String resource) {
        EnumMap<ResourceType, TagKey<Item>> tags = new EnumMap<ResourceType, TagKey<Item>>(ResourceType.class);
        for (ResourceType type : ResourceType.values()) {
            tags.put(type, ModdedTagBuilder.createNeoFabricItemTag(String.format("%s/%s", type.path, resource)));
        }
        TAGS.put(resource, tags);
    }

    private static void registerRawStorageBlockTags(String resource) {
        Map<ResourceType, TagKey<Item>> tags = TAGS.get(resource);
        if (tags != null) {
            tags.put(ResourceType.RAW_STORAGE_BLOCKS, ModdedTagBuilder.createNeoFabricItemTag(String.format("storage_blocks/raw_%s", resource)));
        }
    }

    public static TagKey<Item> getTag(String resource, ResourceType type) {
        return TAGS.get(resource).get((Object)type);
    }

    public static enum ResourceType {
        NUGGETS("nuggets"),
        INGOTS("ingots"),
        STORAGE_BLOCKS("storage_blocks"),
        ORES("ores"),
        RAW_MATERIALS("raw_materials"),
        RAW_STORAGE_BLOCKS("storage_blocks/raw_"),
        PLATES("plates"),
        DUSTS("dusts"),
        GEARS("gears"),
        RODS("rods"),
        GEMS("gems"),
        WIRES("wires");

        private final String path;

        private ResourceType(String path) {
            this.path = path;
        }
    }
}

