/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.integration.fish;

import com.benbenlaw.resourcefish.entities.ResourceFishEntities;
import com.benbenlaw.resourcefish.integration.JEIResourceFishPlugin;
import com.benbenlaw.resourcefish.integration.fish.FishIngredient;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FishIngredientHelper
implements IIngredientHelper<FishIngredient> {
    public IIngredientType<FishIngredient> getIngredientType() {
        return JEIResourceFishPlugin.FISH_INGREDIENT_TYPE;
    }

    public String getDisplayName(FishIngredient ingredient) {
        return ingredient.getFishType().toString();
    }

    public String getUniqueId(FishIngredient ingredient, UidContext context) {
        return ingredient.getFishType().toString();
    }

    public String getDisplayModId(FishIngredient ingredient) {
        return ingredient.getFishType().getNamespace();
    }

    public ResourceLocation getResourceLocation(FishIngredient fishIngredient) {
        return fishIngredient.getFishType();
    }

    public FishIngredient copyIngredient(FishIngredient ingredient) {
        return new FishIngredient(ingredient.getFishType(), ResourceFishEntities.RESOURCE_FISH.get());
    }

    public String getErrorInfo(@Nullable FishIngredient ingredient) {
        if (ingredient == null) {
            return "FishIngredient:null";
        }
        if (ingredient.getFishType() == null) {
            return "FishIngredient:entityType_null";
        }
        return ingredient.getFishType().toString();
    }
}

