/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.resourcefish.screen;

import com.benbenlaw.core.screen.util.CoreSlotTextures;
import com.benbenlaw.core.screen.util.slot.CoreSlot;
import com.benbenlaw.core.screen.util.slot.ResultSlot;
import com.benbenlaw.resourcefish.block.ResourceFishBlocks;
import com.benbenlaw.resourcefish.block.entity.CaviarProcessorBlockEntity;
import com.benbenlaw.resourcefish.screen.ResourceFishMenuTypes;
import com.benbenlaw.resourcefish.util.ResourceFishTags;
import com.mojang.datafixers.util.Pair;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CaviarProcessorMenu
extends AbstractContainerMenu {
    protected CaviarProcessorBlockEntity blockEntity;
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    public final Map<Integer, Point> slotPositions = new HashMap<Integer, Point>();
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 22;

    public CaviarProcessorMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(16));
    }

    public CaviarProcessorMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)ResourceFishMenuTypes.CAVIAR_PROCESSOR_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.blockEntity = (CaviarProcessorBlockEntity)this.level.getBlockEntity(blockPos);
        this.data = data;
        CaviarProcessorBlockEntity entity = (CaviarProcessorBlockEntity)this.level.getBlockEntity(blockPos);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        assert (entity != null);
        int xStart = 8;
        int yStart = 17;
        int xOffset = 18;
        int yOffset = 18;
        for (int i = 0; i < 8; ++i) {
            this.createRecipeSlot(entity, i, xStart + i % 4 * xOffset, yStart + i / 4 * yOffset);
            this.slotPositions.put(i, new Point(xStart + i % 4 * xOffset, yStart + i / 4 * yOffset));
        }
        this.createUpgradeSlot(entity, 8, 17, 53);
        this.createUpgradeSlot(entity, 9, 35, 53);
        this.createUpgradeSlot(entity, 10, 53, 53);
        int xStartOutput = 98;
        int yStartOutput = 17;
        int slotCount = 11;
        int totalSlots = 12;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                int currentSlot = row * 4 + col;
                if (currentSlot == totalSlots - 1) continue;
                int xPos = xStartOutput + col * xOffset;
                int yPos = yStartOutput + row * yOffset;
                this.addSlot((Slot)new ResultSlot((IItemHandler)entity.getItemStackHandler(), slotCount++, xPos, yPos, 64));
            }
        }
        this.addDataSlots(data);
    }

    private void createUpgradeSlot(CaviarProcessorBlockEntity entity, int slot, int x, int y) {
        this.addSlot((Slot)new CoreSlot(this, (IItemHandler)entity.getItemStackHandler(), slot, x, y){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)CoreSlotTextures.UPGRADE_SLOT);
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ResourceFishTags.Items.UPGRADES);
            }
        });
    }

    private void createRecipeSlot(CaviarProcessorBlockEntity entity, int slot, int x, int y) {
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)entity.getItemStackHandler(), slot, x, y){

            public boolean mayPlace(ItemStack stack) {
                return !stack.is(ResourceFishTags.Items.UPGRADES);
            }
        });
    }

    public boolean isCrafting() {
        return this.data.get(0) > 0;
    }

    public int getScaledProgress(int slotIndex) {
        int progress = this.data.get(slotIndex);
        int maxProgress = this.data.get(slotIndex + 8);
        int progressBarWidth = 19;
        return maxProgress != 0 && progress != 0 ? progress * progressBarWidth / maxProgress : 0;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 58, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 58) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return CaviarProcessorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.blockPos), (Player)player, (Block)((Block)ResourceFishBlocks.CAVIAR_PROCESSOR.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

