/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.client;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5455;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import net.pixeldreamstudios.attributepanel.client.AttributeDescriptionProvider;
import net.pixeldreamstudios.attributepanel.client.AttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.client.StatEntry;
import net.pixeldreamstudios.attributepanel.compat.CuriosCompat;
import net.pixeldreamstudios.attributepanel.compat.IconLeadingCompat;
import net.pixeldreamstudios.attributepanel.compat.TrinketsCompat;
import net.pixeldreamstudios.attributepanel.config.AttributesPanelConfig;
import net.spell_engine.api.item.set.EquipmentSet;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class CompactAttributePanelDrawable
implements class_4068,
class_364,
class_6379 {
    private final AttributePanelDrawable root;
    private static final int HEADER_AFTER_GAP = 10;
    private static final float DEFAULT_FONT_SCALE = 0.55f;
    private static final float HEADER_FONT_SCALE = 1.0f;
    private static final int ROW_H_TEXT = 9;
    private static final int HEADER_ICON_SIZE = 9;
    private static final int ATTR_ICON_SIZE = 9;
    private static final int TEX_ICON_SRC_PX = 16;
    private static final int DIVIDER_TEXTURE_W = 64;
    private static final int DIVIDER_TEXTURE_H = 5;
    private static final int DIVIDER_PADDING = 4;
    private static final int DIVIDER_TOTAL_H = 9;
    private static final int BULLET_SIZE = 3;
    private static final int DEFAULT_SIDE_PADDING = 15;
    private static final int PADDING_TOP = 20;
    private static final int PADDING_BOTTOM = 6;
    private static final int SCROLLBAR_GAP = 3;
    private static final float SCROLLBAR_W = 3.15f;
    private static final int SCROLL_STEP_PX = 18;
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/gui.png");
    private static final class_2960 DIVIDER_TEXTURE = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/divider.png");
    private static final class_2960 PERMA = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/perma.png");
    private static final class_2960 EQUIPPED = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/equipped.png");
    private static final class_2960 DD_POWER_ICON = class_2960.method_60655((String)"dungeon_difficulty", (String)"textures/symbol/power_level.png");
    private static final class_2960 FTB_QUEST_BOOK_ICON = class_2960.method_60655((String)"ftbquests", (String)"textures/item/book.png");
    private static final class_2960 INFO_ICON = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/info.png");
    private static final class_2960 CHANGED = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/changed.png");
    private static final int INFO_ICON_SIZE = 12;
    private static final class_2960 SEARCH_ICON = class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/gui/search.png");
    private static final int SEARCH_ICON_SIZE = 12;
    private boolean searchVisible = false;
    private boolean searchFocused = false;
    private String searchText = "";
    private static final int SEARCH_BAR_H = 14;
    private static final int SEARCH_BAR_MARGIN = 6;
    private final List<Item> items = new ArrayList<Item>();
    private final List<Integer> prefixHeights = new ArrayList<Integer>();
    private static final int ICON_VALUE_GAP = 5;
    private int scrollPx = 0;
    private static final int BULLET_Y_NUDGE = -3;
    private boolean draggingBar = false;
    private int dragGrabOffset = 0;
    private static final DecimalFormatSymbols DFS = new DecimalFormatSymbols(Locale.US);
    private static final ThreadLocal<DecimalFormat> NUM_FMT = ThreadLocal.withInitial(() -> {
        DecimalFormat df = new DecimalFormat("#.###", DFS);
        df.setGroupingUsed(false);
        return df;
    });
    private boolean hoveringInfoIcon = false;
    private int globalTooltipScrollOffset = 0;
    private static final int GLOBAL_TOOLTIP_SCROLL_STEP = 10;
    private TooltipRenderData cachedTooltipData = null;
    private int caret = 0;
    private int textScrollPx = 0;
    private int selStart = -1;
    private int selEnd = -1;
    private boolean hasFocus = false;

    public CompactAttributePanelDrawable(AttributePanelDrawable root) {
        this.root = root;
    }

    private boolean isSearching() {
        return this.searchText != null && !this.searchText.isBlank();
    }

    private static String fmtValue(StatEntry stat, boolean inBonusesGroup) {
        double v;
        if (stat.isNaN()) {
            return inBonusesGroup ? "" : stat.bonusCount() + " bonuses";
        }
        double d = v = stat.percent() ? stat.current() * 100.0 : stat.current();
        if (Math.abs(v) < 1.0E-9) {
            v = 0.0;
        }
        String s = NUM_FMT.get().format(v);
        return stat.percent() ? s + "%" : s;
    }

    private float fontScale() {
        AttributesPanelConfig.CompactSettings cfg = AttributesPanelConfig.INSTANCE.compact;
        if (cfg != null && cfg.textScale > 0.0f) {
            return cfg.textScale;
        }
        return 0.55f;
    }

    private int sidePadding() {
        AttributesPanelConfig.CompactSettings cfg = AttributesPanelConfig.INSTANCE.compact;
        if (cfg != null) {
            return cfg.sidePadding;
        }
        return 15;
    }

    private int iconColW() {
        return (int)Math.ceil(9.0f * this.fontScale());
    }

    private boolean isLightTextTheme() {
        AttributesPanelConfig.CompactSettings cfg = AttributesPanelConfig.INSTANCE.compact;
        return cfg != null && cfg.textTheme == AttributesPanelConfig.TextTheme.LIGHT;
    }

    private int colorBody() {
        return this.isLightTextTheme() ? 0x1E1E1E : 0xFFFFFF;
    }

    private int colorHeader() {
        return this.isLightTextTheme() ? 1120295 : 0xFFFFFF;
    }

    private int colorMuted() {
        return this.isLightTextTheme() ? 7041664 : 0xAAAAAA;
    }

    private int colorBullet() {
        return this.isLightTextTheme() ? 0x2D2D2D : 0xFFFFFF;
    }

    private int colorSearchText() {
        return this.isLightTextTheme() ? 0x1E1E1E : 0xFFFFFF;
    }

    private int colorSearchPlaceholder() {
        return this.isLightTextTheme() ? 0x888888 : 0xCCCCCC;
    }

    private int colorCaretFill() {
        return this.isLightTextTheme() ? -16777216 : -1;
    }

    private int colorSelectionFill() {
        return this.isLightTextTheme() ? 0x66333333 : 0x66FFFFFF;
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        int idx;
        class_327 font = this.root.mc().field_1772;
        int bgX = this.root.left() - 16;
        int bgY = this.root.top();
        int bgW = this.root.panelWidth() + 16;
        int bgH = this.root.panelHeight();
        ctx.method_25290(BACKGROUND_TEXTURE, bgX, bgY, 0.0f, 0.0f, bgW, bgH, bgW, bgH);
        this.buildLayout();
        int padX = this.sidePadding();
        int innerX = bgX + padX;
        int innerW = bgW - padX * 2;
        int innerY = bgY + 20;
        int innerH = Math.max(0, bgH - 26);
        int contentH = this.totalContentHeight();
        int maxOffset = Math.max(0, contentH - innerH);
        if (this.scrollPx > maxOffset) {
            this.scrollPx = maxOffset;
        }
        if (this.scrollPx < 0) {
            this.scrollPx = 0;
        }
        int iconsY = bgY + 9;
        int searchX = bgX + 7;
        ctx.method_25290(SEARCH_ICON, searchX, iconsY, 0.0f, 0.0f, 12, 12, 12, 12);
        if (mouseX >= searchX && mouseX <= searchX + 12 && mouseY >= iconsY && mouseY <= iconsY + 12) {
            this.root.enqueueTooltip(List.of(class_2561.method_43469((String)"attributepanel.search.tooltip", (Object[])new Object[]{"Search Attributes"})), List.of(class_1799.field_8037), mouseX, mouseY);
        }
        int infoX = bgX + bgW - 12 - 7;
        ctx.method_25290(INFO_ICON, infoX, iconsY, 0.0f, 0.0f, 12, 12, 12, 12);
        boolean bl = this.hoveringInfoIcon = mouseX >= infoX && mouseX <= infoX + 12 && mouseY >= iconsY && mouseY <= iconsY + 12;
        if (this.hoveringInfoIcon) {
            this.drawGlobalBonusTooltip(ctx, mouseX, mouseY);
        } else {
            this.globalTooltipScrollOffset = 0;
            this.cachedTooltipData = null;
        }
        if (this.searchVisible) {
            int b;
            int a;
            int barW = bgW;
            int barH = 14;
            int barX = bgX;
            int barY = bgY - barH - 6;
            ctx.method_25294(barX, barY, barX + barW, barY + barH, -872415232);
            ctx.method_25294(barX, barY, barX + barW, barY + 1, -5592406);
            ctx.method_25294(barX, barY + barH - 1, barX + barW, barY + barH, -5592406);
            ctx.method_25294(barX, barY, barX + 1, barY + barH, -5592406);
            ctx.method_25294(barX + barW - 1, barY, barX + barW, barY + barH, -5592406);
            font = this.root.mc().field_1772;
            int textX = barX + 6;
            Objects.requireNonNull(font);
            int textY = barY + (barH - 9) / 2;
            int visibleW = Math.max(1, barW - 12);
            int caretClamped = Math.max(0, Math.min(this.caret, this.searchText.length()));
            if (this.searchText.isEmpty()) {
                this.textScrollPx = 0;
            }
            int textW = font.method_1727(this.searchText);
            int caretPx = font.method_1727(this.searchText.substring(0, caretClamped));
            int maxScroll = Math.max(0, textW - visibleW);
            if (caretPx - this.textScrollPx > visibleW) {
                this.textScrollPx = caretPx - visibleW;
            }
            if (caretPx - this.textScrollPx < 0) {
                this.textScrollPx = caretPx;
            }
            if (this.textScrollPx < 0) {
                this.textScrollPx = 0;
            }
            if (this.textScrollPx > maxScroll) {
                this.textScrollPx = maxScroll;
            }
            String toShow = this.searchText.isBlank() ? "Search\u2026" : this.searchText;
            int color = this.searchText.isBlank() ? this.colorSearchPlaceholder() : this.colorSearchText();
            ctx.method_44379(barX + 1, barY + 1, barX + barW - 1, barY + barH - 1);
            if (!this.searchText.isBlank() && this.hasSelection() && (a = Math.min(this.selA(), this.searchText.length())) != (b = Math.min(this.selB(), this.searchText.length()))) {
                int beforeW = font.method_1727(this.searchText.substring(0, a));
                int selW = font.method_1727(this.searchText.substring(a, b));
                int sx0 = textX + beforeW - this.textScrollPx;
                int sx1 = sx0 + selW;
                ctx.method_25294(sx0, barY + 3, sx1, barY + barH - 3, this.colorSelectionFill());
            }
            int drawX = textX - this.textScrollPx;
            ctx.method_51433(font, toShow, drawX, textY, color, false);
            if (this.searchFocused) {
                int caretDrawX = textX + caretPx - this.textScrollPx;
                ctx.method_25294(caretDrawX, barY + 3, caretDrawX + 1, barY + barH - 3, this.colorCaretFill());
            }
            ctx.method_44380();
        }
        if (this.items.isEmpty()) {
            this.drawEmptyState(ctx, font, innerX, innerW, innerY);
            return;
        }
        ctx.method_44379(innerX, innerY, innerX + innerW, innerY + innerH);
        int y = innerY - (this.scrollPx - this.prefixAt(idx)) + (this.isSearching() ? 5 : 0);
        for (idx = this.firstVisibleIndex(this.scrollPx); idx < this.items.size(); ++idx) {
            Item it = this.items.get(idx);
            if (y + it.height > innerY + innerH) break;
            switch (it.type.ordinal()) {
                case 0: {
                    this.drawDivider(ctx, innerX, innerW, y);
                    break;
                }
                case 1: {
                    this.drawHeader(ctx, font, innerX, innerW, y, it.header);
                    break;
                }
                case 2: {
                    this.drawStat(ctx, font, innerX, y, it.stat);
                    if (mouseX < innerX || mouseX > innerX + innerW || mouseY < y || mouseY > y + 9) break;
                    this.handleStatHover(font, innerX, y, it.stat, mouseX, mouseY);
                }
            }
            y += it.height;
        }
        ctx.method_44380();
        this.drawScrollbar(ctx, bgX, bgY, bgW, innerY, innerH, contentH);
    }

    private void drawEmptyState(class_332 ctx, class_327 font, int innerX, int innerW, int innerY) {
        String msg = this.isSearching() ? "No attributes match \"" + this.searchText + "\"" : "No attributes";
        int wrapWidth = Math.max(1, innerW - 8);
        int x = innerX + 4;
        int y = innerY + 7;
        class_5250 component = class_2561.method_43470((String)msg);
        List lines = font.method_1728((class_5348)component, wrapWidth);
        for (class_5481 line : lines) {
            ctx.method_51430(font, line, x, y, this.colorMuted(), true);
            Objects.requireNonNull(font);
            y += 9 + 2;
        }
    }

    private class_2960 resolveAttrIcon(class_2960 attrId, AttributesPanelConfig.CompactSettings cfg) {
        if (attrId == null || cfg == null) {
            return null;
        }
        for (AttributesPanelConfig.HeaderDef headerDef : cfg.headers) {
            if (headerDef == null || headerDef.attributes == null) continue;
            for (AttributesPanelConfig.AttributeSpec spec : headerDef.attributes) {
                class_2960 id;
                class_2960 icon;
                if (spec == null || spec.id == null || spec.id.isBlank() || (icon = CompactAttributePanelDrawable.tryIdentifier(spec.icon)) == null || !(spec.id.contains("*") ? CompactAttributePanelDrawable.globToPattern(spec.id).matcher(attrId.toString()).matches() : (id = CompactAttributePanelDrawable.tryIdentifier(spec.id)) != null && id.equals((Object)attrId))) continue;
                return icon;
            }
        }
        return null;
    }

    private void handleStatHover(class_327 font, int innerX, int y, StatRow row, int mouseX, int mouseY) {
        String rawName = row.stat.name().getString();
        NameSplit split = CompactAttributePanelDrawable.splitLeadingIcon(rawName);
        int iconLeft = innerX;
        int rowY0 = y;
        int rowY1 = y + 9;
        float fs = this.fontScale();
        int iconW = this.iconColW();
        if (row.inBonusesGroup) {
            boolean overValue;
            String bonusText = split.cleanName + " (" + row.stat.bonusCount() + " bonus" + (row.stat.bonusCount() == 1 ? "" : "es") + ")";
            int nameLeft = iconLeft + iconW + 5;
            int cleanNameW = (int)Math.ceil((float)font.method_1727(split.cleanName) * fs);
            int spaceW = (int)Math.ceil((float)font.method_1727(" ") * fs);
            int openParenW = (int)Math.ceil((float)font.method_1727("(") * fs);
            int valuePartLeft = nameLeft + cleanNameW + spaceW + openParenW;
            String bonusCountText = row.stat.bonusCount() + " bonus" + (row.stat.bonusCount() == 1 ? "" : "es") + ")";
            int valuePartW = (int)Math.ceil((float)font.method_1727(bonusCountText) * fs);
            int iconX0 = iconLeft;
            int iconX1 = iconLeft + iconW;
            int nameX0 = nameLeft;
            int nameX1 = nameLeft + cleanNameW;
            int valueX0 = valuePartLeft;
            int valueX1 = valuePartLeft + valuePartW;
            boolean overIcon = mouseX >= iconX0 && mouseX <= iconX1 && mouseY >= rowY0 && mouseY <= rowY1;
            boolean overName = mouseX >= nameX0 && mouseX <= nameX1 && mouseY >= rowY0 && mouseY <= rowY1;
            boolean bl = overValue = mouseX >= valueX0 && mouseX <= valueX1 && mouseY >= rowY0 && mouseY <= rowY1;
            if (overIcon || overName) {
                this.showDescriptionTooltip(row.stat, mouseX, mouseY);
            } else if (overValue) {
                this.showCalculationTooltip(row.stat, mouseX, mouseY);
            }
        } else {
            boolean overName;
            String valueStr = CompactAttributePanelDrawable.fmtValue(row.stat, row.inBonusesGroup);
            int valueLeft = iconLeft + iconW + 5;
            int valueW = (int)Math.ceil((float)font.method_1727(valueStr) * fs);
            int spaceW = (int)Math.ceil((float)font.method_1727(" ") * fs);
            int nameW = (int)Math.ceil((float)font.method_1727(split.cleanName) * fs);
            int nameLeft = valueLeft + valueW + spaceW;
            int iconX0 = iconLeft;
            int iconX1 = iconLeft + iconW;
            int valueX0 = valueLeft;
            int valueX1 = valueLeft + valueW;
            int nameX0 = nameLeft;
            int nameX1 = nameLeft + nameW;
            boolean overIcon = mouseX >= iconX0 && mouseX <= iconX1 && mouseY >= rowY0 && mouseY <= rowY1;
            boolean overValue = mouseX >= valueX0 && mouseX <= valueX1 && mouseY >= rowY0 && mouseY <= rowY1;
            boolean bl = overName = mouseX >= nameX0 && mouseX <= nameX1 && mouseY >= rowY0 && mouseY <= rowY1;
            if (overIcon || overName) {
                this.showDescriptionTooltip(row.stat, mouseX, mouseY);
            } else if (overValue) {
                this.showCalculationTooltip(row.stat, mouseX, mouseY);
            }
        }
    }

    private void showDescriptionTooltip(StatEntry stat, int mouseX, int mouseY) {
        AttributeDescriptionProvider.TooltipContents tip = AttributeDescriptionProvider.getTooltip((class_1320)stat.attribute().comp_349());
        this.root.enqueueTooltip(tip.lines(), tip.icons(), mouseX, mouseY);
    }

    private void showCalculationTooltip(StatEntry stat, int mouseX, int mouseY) {
        boolean hasAnyModifiers;
        class_310 client = this.root.mc();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        boolean shiftDown = GLFW.glfwGetKey((long)client.method_22683().method_4490(), (int)client.field_1690.field_1832.method_1429().method_1444()) == 1;
        class_1324 instance = player.method_5996(stat.attribute());
        if (instance == null) {
            return;
        }
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        ArrayList<class_1799> icons = new ArrayList<class_1799>();
        ArrayList<class_2960> texIcons = new ArrayList<class_2960>();
        class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)stat.attribute().comp_349()));
        String idStr = attrId == null ? "" : attrId.toString();
        boolean isBase100Percent = AttributesPanelConfig.INSTANCE.percentAttributesBase100.contains(idStr);
        double rawBase = instance.method_6201();
        double rawFinal = instance.method_6194();
        boolean isNaN = Double.isNaN(rawBase) || Double.isNaN(rawFinal);
        Function<Double, String> fmtPct = d -> {
            if (Math.abs(d - (double)Math.round(d)) < 0.01) {
                return String.format("%d%%", (int)Math.round(d));
            }
            return String.format("%.2f%%", d);
        };
        if (!isNaN) {
            if (isBase100Percent) {
                if (Math.abs(rawBase) < 0.001) {
                    lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.base", (Object[])new Object[]{fmtPct.apply(0.0)}));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                    lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.final", (Object[])new Object[]{fmtPct.apply(rawFinal * 100.0)}));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                } else {
                    double percentChange = (rawFinal - rawBase) / rawBase * 100.0;
                    lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.base", (Object[])new Object[]{String.format("%s (%.2f)", fmtPct.apply(0.0), rawBase)}));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                    lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.final", (Object[])new Object[]{String.format("%s (%.2f)", fmtPct.apply(percentChange), rawFinal)}));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
            } else {
                lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.base", (Object[])new Object[]{String.format("%.2f", rawBase)}));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
                lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.final", (Object[])new Object[]{String.format("%.2f", rawFinal)}));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
            }
        }
        double flat = 0.0;
        double multBase = 0.0;
        double multTotal = 0.0;
        double puffFlat = 0.0;
        double puffBase = 0.0;
        double puffTotal = 0.0;
        boolean hasPuffish = false;
        ArrayList<Double> flatParts = new ArrayList<Double>();
        ArrayList<Double> baseMultParts = new ArrayList<Double>();
        ArrayList<Double> totalMultParts = new ArrayList<Double>();
        ArrayList<Record> unmatchedAccessorySources = new ArrayList<Record>();
        if (TrinketsCompat.isLoaded()) {
            unmatchedAccessorySources.addAll(TrinketsCompat.getTrinketModifierSources((class_1657)player));
        }
        if (CuriosCompat.isLoaded()) {
            unmatchedAccessorySources.addAll(CuriosCompat.getCurioModifierSources((class_1657)player));
        }
        boolean bl = hasAnyModifiers = !instance.method_6195().isEmpty();
        if (!instance.method_6195().isEmpty()) {
            if (!lines.isEmpty()) {
                lines.add((class_2561)class_2561.method_43473());
                icons.add(class_1799.field_8037);
                texIcons.add(null);
            }
            lines.add((class_2561)class_2561.method_43471((String)"attributepanel.message.modifiers").method_27692(class_124.field_1054));
            icons.add(class_1799.field_8037);
            texIcons.add(null);
            for (class_1322 mod : instance.method_6195()) {
                String p;
                Set<String> ignoredArmorNames;
                class_1304[] path;
                boolean foundSource;
                class_2960 texIcon;
                class_1799 iconStack;
                class_5250 displayName;
                boolean usedCustomName;
                String customName;
                Object opText;
                class_124 color;
                class_2960 rawId;
                block117: {
                    class_2960 guess;
                    String[] pathParts;
                    String lowerPath;
                    String[] texParts;
                    String fullPath;
                    String[] parts;
                    rawId = mod.comp_2447();
                    if (rawId.method_12836().equals("tiered") && (parts = (fullPath = rawId.method_12832()).split("/")).length >= 3 && parts[parts.length - 1].contains("_")) {
                        rawId = class_2960.method_60655((String)"tiered", (String)parts[parts.length - 1]);
                    }
                    if (rawId.method_12836().equals("puffish_skills")) {
                        hasPuffish = true;
                        switch (mod.comp_2450()) {
                            case field_6328: {
                                puffFlat += mod.comp_2449();
                                break;
                            }
                            case field_6330: {
                                puffBase += mod.comp_2449();
                                break;
                            }
                            case field_6331: {
                                puffTotal += mod.comp_2449();
                            }
                        }
                        continue;
                    }
                    switch (mod.comp_2450()) {
                        case field_6328: {
                            double v2 = mod.comp_2449();
                            flat += v2;
                            flatParts.add(v2);
                            color = v2 >= 0.0 ? class_124.field_1060 : class_124.field_1061;
                            opText = (v2 >= 0.0 ? "+" : "") + String.format("%.2f", v2);
                            break;
                        }
                        case field_6330: {
                            double v3 = mod.comp_2449();
                            multBase += v3;
                            baseMultParts.add(v3);
                            int p2 = (int)Math.round(v3 * 100.0);
                            color = p2 >= 0 ? class_124.field_1060 : class_124.field_1061;
                            opText = (p2 >= 0 ? "+" : "") + p2 + "% Base";
                            break;
                        }
                        case field_6331: {
                            double v4 = mod.comp_2449();
                            multTotal += v4;
                            totalMultParts.add(v4);
                            int p3 = (int)Math.round(v4 * 100.0);
                            color = p3 >= 0 ? class_124.field_1060 : class_124.field_1061;
                            opText = (p3 >= 0 ? "+" : "") + p3 + "% Total";
                            break;
                        }
                        default: {
                            color = class_124.field_1080;
                            opText = "?   ";
                        }
                    }
                    String fullPath2 = rawId.method_12832();
                    String[] idParts = fullPath2.split("\\.", 2);
                    class_2960 modId = class_2960.method_60655((String)rawId.method_12836(), (String)idParts[0]);
                    customName = idParts.length > 1 ? idParts[1] : null;
                    usedCustomName = false;
                    displayName = class_2561.method_43470((String)AttributePanelDrawable.formatModifierId(modId));
                    iconStack = class_1799.field_8037;
                    texIcon = null;
                    foundSource = false;
                    if (rawId.method_12836().equals("texture") && (texParts = fullPath2.split("\\.")).length >= 4) {
                        String textureNamespace = texParts[0];
                        StringBuilder texPathBuilder = new StringBuilder("textures");
                        for (int i = 1; i < texParts.length - 1; ++i) {
                            texPathBuilder.append("/").append(texParts[i]);
                        }
                        texPathBuilder.append(".png");
                        String customNameFromPath = texParts[texParts.length - 1];
                        texIcon = class_2960.method_60655((String)textureNamespace, (String)texPathBuilder.toString());
                        String pretty = Arrays.stream(customNameFromPath.split("_")).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                        displayName = class_2561.method_43470((String)pretty).method_27692(class_124.field_1076);
                        usedCustomName = true;
                        foundSource = true;
                    }
                    class_5250 enchDisplayName = null;
                    class_1799 enchIconStack = class_1799.field_8037;
                    boolean enchantParsed = false;
                    path = rawId.method_12832();
                    String string = lowerPath = path == null ? "" : path.toLowerCase(Locale.ROOT);
                    if (lowerPath.startsWith("enchantment.") || lowerPath.startsWith("enchantment/") || lowerPath.contains("enchantment")) {
                        Object enchKey;
                        int sep;
                        Object possible = path;
                        int idxDot = path.indexOf(46);
                        int idxSlash = path.indexOf(47);
                        if (idxDot >= 0 && path.startsWith("enchantment.")) {
                            possible = path.substring("enchantment.".length());
                        } else if (idxSlash >= 0 && path.startsWith("enchantment/")) {
                            possible = path.substring("enchantment/".length());
                        } else if (path.startsWith("enchantment") && (sep = Math.max(path.indexOf(46), path.indexOf(47))) >= 0 && sep + 1 < path.length()) {
                            possible = path.substring(sep + 1);
                        }
                        int stop = ((String)possible).length();
                        int s1 = ((String)possible).indexOf(47);
                        int s2 = ((String)possible).indexOf(46);
                        if (s1 >= 0) {
                            stop = Math.min(stop, s1);
                        }
                        if (s2 >= 0) {
                            stop = Math.min(stop, s2);
                        }
                        Object object = enchKey = stop > 0 && stop <= ((String)possible).length() ? ((String)possible).substring(0, stop) : possible;
                        if (enchKey != null && !((String)enchKey).isBlank()) {
                            try {
                                class_5321 enchantKey;
                                class_5455 drm;
                                class_2378 enchantmentRegistry;
                                Optional entryOpt;
                                class_2960 enchId = class_2960.method_60655((String)rawId.method_12836(), (String)enchKey);
                                if (this.root.mc().field_1724 != null && this.root.mc().field_1724.method_37908() != null && (entryOpt = (enchantmentRegistry = (drm = this.root.mc().field_1724.method_37908().method_30349()).method_30530(class_7924.field_41265)).method_40264(enchantKey = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)enchId))).isPresent()) {
                                    class_6880.class_6883 enchEntry = (class_6880.class_6883)entryOpt.get();
                                    int lvl = Math.max(1, (int)Math.round(Math.abs(mod.comp_2449())));
                                    enchIconStack = class_1772.method_7808((class_1889)new class_1889((class_6880)enchEntry, lvl));
                                    enchDisplayName = class_1887.method_8179((class_6880)enchEntry, (int)lvl).method_27661().method_27692(class_124.field_1075);
                                    enchantParsed = true;
                                }
                            }
                            catch (Exception enchId) {
                                // empty catch block
                            }
                        }
                    }
                    if (foundSource) {
                        lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                        icons.add(iconStack);
                        texIcons.add(texIcon);
                        continue;
                    }
                    for (class_1304 slot : class_1304.values()) {
                        class_1799 stack = player.method_6118(slot);
                        if (stack.method_7960()) continue;
                        boolean[] matched = new boolean[]{false};
                        class_9285 comp = (class_9285)stack.method_57824(class_9334.field_49636);
                        if (comp != null) {
                            for (Object entry : comp.comp_2393()) {
                                if (!entry.comp_2397().method_57286(slot) || !entry.comp_2396().comp_2447().equals((Object)mod.comp_2447()) || !entry.comp_2395().equals(stat.attribute())) continue;
                                matched[0] = true;
                                break;
                            }
                        }
                        if (!matched[0]) {
                            Object entry;
                            class_9285 defaultMods = stack.method_7909().method_7844();
                            entry = defaultMods.comp_2393().iterator();
                            while (entry.hasNext()) {
                                class_9285.class_9287 entry2 = (class_9285.class_9287)entry.next();
                                if (!entry2.comp_2397().method_57286(slot) || !entry2.comp_2396().comp_2447().equals((Object)mod.comp_2447()) || !entry2.comp_2395().equals(stat.attribute())) continue;
                                matched[0] = true;
                                break;
                            }
                        }
                        if (!matched[0]) continue;
                        iconStack = stack;
                        try {
                            if (!usedCustomName) {
                                displayName = stack.method_7964().method_27661();
                            }
                        }
                        catch (Exception defaultMods) {
                            // empty catch block
                        }
                        foundSource = true;
                        break;
                    }
                    if (!foundSource && enchantParsed) {
                        class_5250 useName = enchDisplayName != null ? enchDisplayName : displayName;
                        class_1799 useIcon = !enchIconStack.method_7960() ? enchIconStack : iconStack;
                        lines.add((class_2561)useName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                        icons.add(useIcon);
                        texIcons.add(null);
                        foundSource = true;
                        continue;
                    }
                    if (!foundSource && !"dungeon_difficulty".equals(rawId.method_12836()) && !"morequesttypes".equals(rawId.method_12836()) && (pathParts = rawId.method_12832().split("\\.", 2)[0].split("/")).length > 0 && class_7923.field_41178.method_10250(guess = class_2960.method_60655((String)rawId.method_12836(), (String)pathParts[pathParts.length - 1]))) {
                        class_1792 item = (class_1792)class_7923.field_41178.method_10223(guess);
                        iconStack = new class_1799((class_1935)item);
                        displayName = iconStack.method_7964().method_27661().method_27692(iconStack.method_7932().method_58413());
                        foundSource = true;
                    }
                    if (!foundSource) {
                        try {
                            String rawPath = rawId.method_12832().toLowerCase(Locale.ROOT);
                            if (!rawPath.contains("set_bonus")) break block117;
                            ArrayList<EquipmentSet.SourcedItemStack> sourced = new ArrayList<EquipmentSet.SourcedItemStack>();
                            for (class_1304 slot : class_1304.values()) {
                                class_1799 s2 = player.method_6118(slot);
                                if (s2 == null || s2.method_7960()) continue;
                                sourced.add(new EquipmentSet.SourcedItemStack(s2, slot.method_5923()));
                            }
                            if (TrinketsCompat.isLoaded()) {
                                try {
                                    for (TrinketsCompat.TrinketModifierSource src : TrinketsCompat.getTrinketModifierSources((class_1657)player)) {
                                        sourced.add(new EquipmentSet.SourcedItemStack(src.stack(), "trinket"));
                                    }
                                }
                                catch (Exception item) {
                                    // empty catch block
                                }
                            }
                            if (CuriosCompat.isLoaded()) {
                                try {
                                    for (CuriosCompat.CurioModifierSource src : CuriosCompat.getCurioModifierSources((class_1657)player)) {
                                        sourced.add(new EquipmentSet.SourcedItemStack(src.stack(), "curio"));
                                    }
                                }
                                catch (Exception item) {
                                    // empty catch block
                                }
                            }
                            List results = EquipmentSet.collectFrom(sourced, (class_1937)player.method_37908());
                            for (EquipmentSet.Result res : results) {
                                String rawDefName;
                                class_5250 setNameText;
                                class_1799 chosen;
                                List setItems;
                                class_2960 setId;
                                class_6880 setEntry = res.set();
                                if (!setEntry.method_40230().isPresent() || !(setId = ((class_5321)setEntry.method_40230().get()).method_29177()).method_12836().equals(rawId.method_12836()) || (setItems = res.items()) == null || setItems.isEmpty()) continue;
                                int idx = (int)(System.currentTimeMillis() / 1000L % (long)setItems.size());
                                iconStack = chosen = (class_1799)setItems.get(idx);
                                try {
                                    String tkey = EquipmentSet.translationKey((class_6880)setEntry);
                                    setNameText = class_2561.method_43471((String)tkey);
                                    if (setNameText.getString().equals(tkey)) {
                                        rawDefName = ((EquipmentSet.Definition)setEntry.comp_349()).name();
                                        setNameText = rawDefName != null && !rawDefName.isBlank() ? class_2561.method_43470((String)rawDefName) : class_2561.method_43470((String)setId.method_12832());
                                    }
                                }
                                catch (Exception e) {
                                    rawDefName = "";
                                    try {
                                        rawDefName = ((EquipmentSet.Definition)setEntry.comp_349()).name();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    setNameText = rawDefName != null && !rawDefName.isBlank() ? class_2561.method_43470((String)rawDefName) : class_2561.method_43470((String)setId.method_12832());
                                }
                                displayName = setNameText.method_27661().method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" Set").method_27692(class_124.field_1075));
                                foundSource = true;
                                break;
                            }
                        }
                        catch (Exception rawPath) {
                            // empty catch block
                        }
                    }
                }
                if (!(customName == null || customName.isBlank() || "dungeon_difficulty".equals(rawId.method_12836()) || "morequesttypes".equals(rawId.method_12836()) || (ignoredArmorNames = Set.of("helmet", "chestplate", "leggings", "boots")).contains(customName.toLowerCase(Locale.ROOT)))) {
                    String pretty = Arrays.stream(customName.split("_")).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    displayName = class_2561.method_43470((String)pretty).method_27692(class_124.field_1076);
                    usedCustomName = true;
                }
                if (!foundSource) {
                    Iterator it = unmatchedAccessorySources.iterator();
                    while (it.hasNext()) {
                        Object source = it.next();
                        class_1799 sourceStack = null;
                        class_1322 sourceMod = null;
                        class_6880<class_1320> sourceAttr = null;
                        if (source instanceof TrinketsCompat.TrinketModifierSource) {
                            TrinketsCompat.TrinketModifierSource trinket = (TrinketsCompat.TrinketModifierSource)source;
                            sourceStack = trinket.stack();
                            sourceMod = trinket.modifier();
                            sourceAttr = trinket.attribute();
                        } else if (source instanceof CuriosCompat.CurioModifierSource) {
                            CuriosCompat.CurioModifierSource curio = (CuriosCompat.CurioModifierSource)source;
                            sourceStack = curio.stack();
                            sourceMod = curio.modifier();
                            sourceAttr = curio.attribute();
                        }
                        if (sourceAttr == null || !((class_1320)sourceAttr.comp_349()).equals(stat.attribute().comp_349()) || sourceMod == null || sourceMod.comp_2450() != mod.comp_2450() || !(Math.abs(sourceMod.comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        iconStack = sourceStack;
                        try {
                            displayName = iconStack.method_7964().method_27661().method_27692(iconStack.method_7932().method_58413());
                        }
                        catch (Exception e) {
                            displayName = class_2561.method_43470((String)"Unknown Accessory").method_27692(class_124.field_1080);
                        }
                        foundSource = true;
                        it.remove();
                        break;
                    }
                }
                if (!foundSource) {
                    for (class_1293 se : player.method_6026()) {
                        class_1322 pm;
                        class_1291 effect = (class_1291)se.method_5579().comp_349();
                        int amp = se.method_5578();
                        HashMap map = new HashMap();
                        effect.method_55650(amp, (attribute, modifier) -> map.put((class_1320)attribute.comp_349(), modifier));
                        if (!map.containsKey(stat.attribute().comp_349()) || (pm = (class_1322)map.get(stat.attribute().comp_349())).comp_2450() != mod.comp_2450() || !(Math.abs(pm.comp_2449() - mod.comp_2449()) < 1.0E-4)) continue;
                        displayName = class_2561.method_43471((String)effect.method_5567());
                        iconStack = this.root.createColoredPotionItem(effect);
                        foundSource = true;
                        break;
                    }
                }
                if ("dungeon_difficulty".equals(rawId.method_12836())) {
                    displayName = class_2561.method_43470((String)"Power Boost").method_27692(class_124.field_1075);
                    lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                    icons.add(class_1799.field_8037);
                    texIcons.add(DD_POWER_ICON);
                    continue;
                }
                if ("morequesttypes".equals(rawId.method_12836())) {
                    displayName = class_2561.method_43470((String)"Quest Reward").method_27692(class_124.field_1075);
                    lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                    icons.add(class_1799.field_8037);
                    texIcons.add(FTB_QUEST_BOOK_ICON);
                    continue;
                }
                if ("reskillable".equals(rawId.method_12836())) {
                    String[] skillNames = new String[]{"mining", "gathering", "attack", "defense", "building", "farming", "agility", "magic"};
                    String skillName = null;
                    for (String skill : skillNames) {
                        if (!path.equals(skill)) continue;
                        skillName = skill;
                        break;
                    }
                    if (skillName != null) {
                        String prettySkill = skillName.substring(0, 1).toUpperCase(Locale.ROOT) + skillName.substring(1).toLowerCase(Locale.ROOT);
                        displayName = class_2561.method_43470((String)(prettySkill + " Skill")).method_27692(class_124.field_1075);
                        try {
                            class_2960 iconLocation = class_2960.method_60655((String)"kevs_attributes_panel", (String)("textures/reskillable_compat/" + skillName + ".png"));
                            lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                            icons.add(class_1799.field_8037);
                            texIcons.add(iconLocation);
                            continue;
                        }
                        catch (Exception iconLocation) {
                            // empty catch block
                        }
                    }
                    if (path.equals("health_bonus")) {
                        displayName = class_2561.method_43470((String)"Total Level Bonus").method_27692(class_124.field_1075);
                        lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                        icons.add(class_1799.field_8037);
                        texIcons.add(class_2960.method_60655((String)"kevs_attributes_panel", (String)"textures/reskillable_compat/health_bonus.png"));
                        continue;
                    }
                }
                if ("apotheosis".equals(rawId.method_12836())) {
                    String apothPath = rawId.method_12832();
                    String prettyName = null;
                    if (apothPath.contains("_modifier_apothic_attributes")) {
                        String beforeModifier = apothPath.split("_modifier_apothic_attributes")[0];
                        int lastSlash = beforeModifier.lastIndexOf(47);
                        if (lastSlash >= 0) {
                            beforeModifier = beforeModifier.substring(lastSlash + 1);
                        }
                        prettyName = Arrays.stream(beforeModifier.split("_")).filter(s -> !s.isBlank()).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    }
                    if (prettyName != null) {
                        displayName = class_2561.method_43470(prettyName).method_27692(class_124.field_1076);
                        lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                        icons.add(class_1799.field_8037);
                        try {
                            texIcon = class_2960.method_60655((String)"apotheosis", (String)"textures/items/sigils/socketing.png");
                            texIcons.add(texIcon);
                        }
                        catch (Exception e) {
                            texIcons.add(null);
                        }
                        continue;
                    }
                }
                boolean printedCustom = false;
                if (rawId.method_12836().equals("rpg-systems") && (p = rawId.method_12832()).startsWith("title/")) {
                    boolean perma;
                    String[] seg = p.split("/");
                    boolean bl2 = perma = seg.length > 1 && "perma".equals(seg[1]);
                    String titlePathSlug = perma ? (seg.length >= 4 ? seg[3] : "unknown") : (seg.length >= 3 ? seg[2] : "unknown");
                    String prettyTitle = Arrays.stream(titlePathSlug.split("_")).filter(s -> !s.isBlank()).map(s -> s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
                    class_5250 line = class_2561.method_43470((String)prettyTitle).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                    lines.add((class_2561)line);
                    icons.add(class_1799.field_8037);
                    texIcons.add(perma ? PERMA : EQUIPPED);
                    printedCustom = true;
                }
                if (printedCustom) continue;
                if (rawId.method_12836().equals("tiered")) {
                    String[] pp = rawId.method_12832().split("_");
                    String tier = pp.length > 0 ? pp[0].substring(0, 1).toUpperCase() + pp[0].substring(1).toLowerCase() : "Tiered";
                    lines.add((class_2561)class_2561.method_43470((String)(tier + " Bonus:    ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(class_124.field_1060)));
                    icons.add(new class_1799((class_1935)class_1802.field_8782));
                    texIcons.add(null);
                    continue;
                }
                lines.add((class_2561)displayName.method_27661().method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)opText).method_27692(color)));
                icons.add(iconStack);
                texIcons.add(texIcon);
            }
            if (hasPuffish) {
                lines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.skill_tree_bonus").method_27692(class_124.field_1075));
                icons.add(class_1799.field_8037);
                texIcons.add(null);
                if (puffFlat != 0.0) {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("- %+,.2f", puffFlat)).method_27692(class_124.field_1060));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                if (puffBase != 0.0) {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Base", (int)(puffBase * 100.0))).method_27692(class_124.field_1060));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
                if (puffTotal != 0.0) {
                    lines.add((class_2561)class_2561.method_43470((String)String.format("- %+d%% Total", (int)(puffTotal * 100.0))).method_27692(class_124.field_1060));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
            }
        }
        if (!hasAnyModifiers) {
            lines.add((class_2561)class_2561.method_43470((String)"None").method_27692(class_124.field_1080));
            icons.add(class_1799.field_8037);
            texIcons.add(null);
        }
        if (!isNaN) {
            boolean hasChanges;
            boolean bl3 = hasChanges = Math.abs(rawFinal - rawBase) > 0.001;
            if (hasChanges) {
                lines.add((class_2561)class_2561.method_43473());
                icons.add(class_1799.field_8037);
                texIcons.add(null);
                if (shiftDown) {
                    lines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.calculated").method_27692(class_124.field_1063));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                    if (isBase100Percent) {
                        if (Math.abs(rawBase) < 0.001) {
                            if (!flatParts.isEmpty()) {
                                String sum = flatParts.stream().map(v -> (String)fmtPct.apply(v * 100.0)).reduce((a, b) -> a + " + " + b).orElse(fmtPct.apply(0.0));
                                lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %s + (%s) = %s", fmtPct.apply(0.0), sum, fmtPct.apply(rawFinal * 100.0))).method_27692(class_124.field_1080));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                            }
                            lines.add((class_2561)class_2561.method_43470((String)("= " + fmtPct.apply(rawFinal * 100.0))).method_27692(class_124.field_1060));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                        } else {
                            String sum;
                            double basePlusAdd = rawBase + flat;
                            double afterBaseMult = multBase != 0.0 ? basePlusAdd * (1.0 + multBase) : basePlusAdd;
                            double finalValue = multTotal != 0.0 ? afterBaseMult * (1.0 + multTotal) : afterBaseMult;
                            lines.add((class_2561)class_2561.method_43470((String)String.format("Base: %.2f (%s)", rawBase, fmtPct.apply(0.0))).method_27692(class_124.field_1080));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                            if (!flatParts.isEmpty()) {
                                sum = flatParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                                double pct = (basePlusAdd - rawBase) / rawBase * 100.0;
                                lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f + (%s) = %.2f (%s)", rawBase, sum, basePlusAdd, fmtPct.apply(pct))).method_27692(class_124.field_1080));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                            }
                            if (!baseMultParts.isEmpty()) {
                                sum = baseMultParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                                double pct = (afterBaseMult - rawBase) / rawBase * 100.0;
                                lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f (%s)", basePlusAdd, sum, afterBaseMult, fmtPct.apply(pct))).method_27692(class_124.field_1080));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                            }
                            if (!totalMultParts.isEmpty()) {
                                sum = totalMultParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                                double pct = (finalValue - rawBase) / rawBase * 100.0;
                                lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f (%s)", afterBaseMult, sum, finalValue, fmtPct.apply(pct))).method_27692(class_124.field_1080));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                            }
                            double finalPct = (rawFinal - rawBase) / rawBase * 100.0;
                            lines.add((class_2561)class_2561.method_43470((String)String.format("= %.2f (%s)", rawFinal, fmtPct.apply(finalPct))).method_27692(class_124.field_1060));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                        }
                    } else {
                        double finalValue;
                        double base = rawBase;
                        double basePlusAdd = base + flat;
                        double afterBaseMult = multBase != 0.0 ? basePlusAdd * (1.0 + multBase) : basePlusAdd;
                        double d2 = finalValue = multTotal != 0.0 ? afterBaseMult * (1.0 + multTotal) : afterBaseMult;
                        if (!flatParts.isEmpty()) {
                            String sum = flatParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                            lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f + (%s) = %.2f", base, sum, basePlusAdd)).method_27692(class_124.field_1080));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                        } else {
                            lines.add((class_2561)class_2561.method_43470((String)String.format("= %.2f", base)).method_27692(class_124.field_1080));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                        }
                        if (!baseMultParts.isEmpty()) {
                            String sum = baseMultParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                            lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", basePlusAdd, sum, afterBaseMult)).method_27692(class_124.field_1080));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                        }
                        if (!totalMultParts.isEmpty()) {
                            String sum = totalMultParts.stream().map(v -> String.format("%.2f", v)).reduce((a, b) -> a + " + " + b).orElse("0.00");
                            lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %s) = %.2f", afterBaseMult, sum, finalValue)).method_27692(class_124.field_1080));
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                        }
                        lines.add((class_2561)class_2561.method_43470((String)("= " + String.format("%.2f", finalValue))).method_27692(class_124.field_1060));
                        icons.add(class_1799.field_8037);
                        texIcons.add(null);
                        double actualFinal = rawFinal;
                        double delta = actualFinal - finalValue;
                        if (Math.abs(delta) > 0.001 && finalValue > 0.001) {
                            double pct = Math.abs(delta) / finalValue;
                            lines.add((class_2561)class_2561.method_43473());
                            icons.add(class_1799.field_8037);
                            texIcons.add(null);
                            if (delta > 0.0) {
                                lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.indirect_bonus", (Object[])new Object[]{String.format("%.2f", delta)}).method_27692(class_124.field_1077));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                                lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 + %.2f) = %.2f", finalValue, pct, actualFinal)).method_27692(class_124.field_1080));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                            } else {
                                lines.add((class_2561)class_2561.method_43469((String)"attributepanel.tooltip.indirect_decrease", (Object[])new Object[]{String.format("%.2f", -delta)}).method_27692(class_124.field_1061));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                                lines.add((class_2561)class_2561.method_43470((String)String.format("\u27f6 %.2f \u00d7 (1.00 - %.2f) = %.2f", finalValue, pct, actualFinal)).method_27692(class_124.field_1080));
                                icons.add(class_1799.field_8037);
                                texIcons.add(null);
                            }
                        }
                    }
                } else {
                    lines.add((class_2561)class_2561.method_43471((String)"attributepanel.tooltip.hold_shift").method_27692(class_124.field_1080));
                    icons.add(class_1799.field_8037);
                    texIcons.add(null);
                }
            }
        }
        this.root.enqueueTooltipRich(lines, icons, texIcons, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int bgX = this.root.left() - 16;
        int bgY = this.root.top();
        int bgW = this.root.panelWidth() + 16;
        int iconsY = bgY + 9;
        int searchX = bgX + 7;
        if (mouseX >= (double)searchX && mouseX <= (double)(searchX + 12) && mouseY >= (double)iconsY && mouseY <= (double)(iconsY + 12)) {
            boolean bl = this.searchVisible = !this.searchVisible;
            if (this.searchVisible) {
                this.method_25365(true);
            } else {
                this.method_25365(false);
            }
            return true;
        }
        if (this.searchVisible) {
            int barW = bgW;
            int barH = 14;
            int barX = bgX;
            int barY = bgY - barH - 6;
            if (mouseX >= (double)barX && mouseX <= (double)(barX + barW) && mouseY >= (double)barY && mouseY <= (double)(barY + barH)) {
                this.method_25365(true);
                return true;
            }
            this.method_25365(false);
        }
        BarGeom g = this.computeBarGeom();
        if (!g.visible) {
            return false;
        }
        int left = (int)Math.floor(g.x);
        int right = (int)Math.ceil(g.x + g.w);
        if (mouseX >= (double)left && mouseX <= (double)right && mouseY >= (double)g.y && mouseY <= (double)(g.y + g.h)) {
            if (mouseY >= (double)g.knobY && mouseY <= (double)(g.knobY + g.knobH)) {
                this.draggingBar = true;
                this.dragGrabOffset = (int)(mouseY - (double)g.knobY);
                return true;
            }
            int desired = (int)mouseY - g.y - g.knobH / 2;
            this.scrollPx = this.offsetFromBarPosition(desired, g);
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.searchVisible || !this.searchFocused) {
            return false;
        }
        if (chr == '\n' || chr == '\r') {
            return true;
        }
        if (chr >= ' ' && chr != '\u007f') {
            this.replaceSelectionWith(String.valueOf(chr));
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        String clip;
        if (!this.searchVisible || !this.searchFocused) {
            return false;
        }
        boolean ctrl = class_437.method_25441();
        boolean shift = class_437.method_25442();
        if (keyCode == 65 && ctrl) {
            this.selectAll();
            return true;
        }
        if (keyCode == 86 && ctrl && (clip = this.root.mc().field_1774.method_1460()) != null && !clip.isEmpty()) {
            this.replaceSelectionWith(clip);
            this.scrollPx = 0;
            return true;
        }
        if (keyCode == 259 && ctrl) {
            if (this.hasSelection()) {
                this.replaceSelectionWith("");
            } else {
                int a = this.prevWord(this.caret);
                if (a != this.caret) {
                    this.searchText = this.searchText.substring(0, a) + this.searchText.substring(this.caret);
                    this.caret = a;
                    this.clearSelection();
                }
            }
            this.clampCaret();
            this.scrollPx = 0;
            return true;
        }
        if (keyCode == 261 && ctrl) {
            if (this.hasSelection()) {
                this.replaceSelectionWith("");
            } else {
                int b = this.nextWord(this.caret);
                if (b != this.caret) {
                    this.searchText = this.searchText.substring(0, this.caret) + this.searchText.substring(b);
                    this.clearSelection();
                }
            }
            this.clampCaret();
            this.scrollPx = 0;
            return true;
        }
        if (keyCode == 259) {
            if (this.hasSelection()) {
                this.replaceSelectionWith("");
            } else if (this.caret > 0 && !this.searchText.isEmpty()) {
                this.searchText = this.searchText.substring(0, this.caret - 1) + this.searchText.substring(this.caret);
                --this.caret;
                this.clearSelection();
            }
            this.clampCaret();
            this.scrollPx = 0;
            return true;
        }
        if (keyCode == 261) {
            if (this.hasSelection()) {
                this.replaceSelectionWith("");
            } else if (this.caret < this.searchText.length()) {
                this.searchText = this.searchText.substring(0, this.caret) + this.searchText.substring(this.caret + 1);
            }
            this.clampCaret();
            this.clearSelection();
            this.scrollPx = 0;
            return true;
        }
        if (keyCode == 263) {
            int newPos = ctrl ? this.prevWord(this.caret) : Math.max(0, this.caret - 1);
            this.moveCaretTo(newPos, shift);
            return true;
        }
        if (keyCode == 262) {
            int newPos = ctrl ? this.nextWord(this.caret) : Math.min(this.searchText.length(), this.caret + 1);
            this.moveCaretTo(newPos, shift);
            return true;
        }
        if (keyCode == 268) {
            this.moveCaretTo(0, shift);
            return true;
        }
        if (keyCode == 269) {
            this.moveCaretTo(this.searchText.length(), shift);
            return true;
        }
        if (keyCode == 256) {
            if (!this.searchText.isEmpty()) {
                this.searchText = "";
                this.caret = 0;
                this.clearSelection();
                this.scrollPx = 0;
            } else {
                this.searchVisible = false;
                this.method_25365(false);
            }
            return true;
        }
        return keyCode == 257 || keyCode == 335;
    }

    private boolean hasSelection() {
        return this.selStart >= 0 && this.selEnd >= 0 && this.selStart != this.selEnd;
    }

    private void clearSelection() {
        this.selEnd = -1;
        this.selStart = -1;
    }

    private void selectAll() {
        this.selStart = 0;
        this.selEnd = this.searchText.length();
        this.caret = this.searchText.length();
    }

    private int selA() {
        return Math.min(this.selStart, this.selEnd);
    }

    private int selB() {
        return Math.max(this.selStart, this.selEnd);
    }

    private void clampCaret() {
        this.caret = Math.max(0, Math.min(this.caret, this.searchText.length()));
    }

    private void moveCaretTo(int pos, boolean extend) {
        this.caret = Math.max(0, Math.min(pos, this.searchText.length()));
        if (extend) {
            if (!this.hasSelection()) {
                this.selStart = this.caret;
                this.selEnd = this.caret;
            }
            this.selEnd = this.caret;
        } else {
            this.clearSelection();
        }
    }

    private void replaceSelectionWith(String insert) {
        if (this.hasSelection()) {
            int a = this.selA();
            int b = this.selB();
            this.searchText = this.searchText.substring(0, a) + insert + this.searchText.substring(b);
            this.caret = a + insert.length();
            this.clearSelection();
        } else {
            this.searchText = this.searchText.substring(0, this.caret) + insert + this.searchText.substring(this.caret);
            this.caret += insert.length();
        }
        this.scrollPx = 0;
    }

    private int prevWord(int from) {
        int i;
        for (i = Math.max(0, Math.min(from, this.searchText.length())); i > 0 && this.searchText.charAt(i - 1) == ' '; --i) {
        }
        while (i > 0 && this.searchText.charAt(i - 1) != ' ') {
            --i;
        }
        return i;
    }

    private int nextWord(int from) {
        int i;
        int n = this.searchText.length();
        for (i = Math.max(0, Math.min(from, n)); i < n && this.searchText.charAt(i) != ' '; ++i) {
        }
        while (i < n && this.searchText.charAt(i) == ' ') {
            ++i;
        }
        return i;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingBar) {
            this.draggingBar = false;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        if (!this.draggingBar || button != 0) {
            return false;
        }
        BarGeom g = this.computeBarGeom();
        if (!g.visible) {
            return false;
        }
        int desired = (int)(mouseY - (double)g.y - (double)this.dragGrabOffset);
        this.scrollPx = this.offsetFromBarPosition(desired, g);
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        boolean insideBar;
        int bgX = this.root.left() - 16;
        int bgY = this.root.top();
        int bgW = this.root.panelWidth() + 16;
        int bgH = this.root.panelHeight();
        int iconsY = bgY + 9;
        int infoX = bgX + bgW - 12 - 7;
        if (this.hoveringInfoIcon && mouseX >= (double)infoX && mouseX <= (double)(infoX + 12) && mouseY >= (double)iconsY && mouseY <= (double)(iconsY + 12)) {
            int deltaPx = verticalAmount > 0.0 ? -10 : 10;
            this.globalTooltipScrollOffset += deltaPx;
            if (this.globalTooltipScrollOffset < 0) {
                this.globalTooltipScrollOffset = 0;
            }
            return true;
        }
        int innerH = Math.max(0, bgH - 26);
        BarGeom g = this.computeBarGeom();
        int left = (int)Math.floor(g.x);
        int right = (int)Math.ceil(g.x + g.w);
        boolean insidePanel = mouseX >= (double)bgX && mouseX <= (double)(bgX + bgW) && mouseY >= (double)bgY && mouseY <= (double)(bgY + bgH);
        boolean bl = insideBar = g.visible && mouseX >= (double)left && mouseX <= (double)right && mouseY >= (double)g.y && mouseY <= (double)(g.y + g.h);
        if (!insidePanel && !insideBar) {
            return false;
        }
        int contentH = this.totalContentHeight();
        int maxOffset = Math.max(0, contentH - innerH);
        int deltaPx = verticalAmount > 0.0 ? -18 : 18;
        int next = Math.max(0, Math.min(this.scrollPx + deltaPx, maxOffset));
        boolean changed = next != this.scrollPx;
        this.scrollPx = next;
        return changed;
    }

    private void buildLayout() {
        class_2960 icon;
        boolean bl;
        boolean bl2;
        this.items.clear();
        this.prefixHeights.clear();
        List<StatEntry> stats = this.root.getCachedStats();
        if (stats.isEmpty()) {
            return;
        }
        if (AttributesPanelConfig.INSTANCE.compact == null) {
            AttributesPanelConfig.INSTANCE.compact = AttributesPanelConfig.CompactSettings.defaultPreset();
        }
        AttributesPanelConfig.CompactSettings cfg = AttributesPanelConfig.INSTANCE.compact;
        if (this.isSearching()) {
            String q = this.searchText.trim().toLowerCase(Locale.ROOT);
            AttributesPanelConfig.CompactSettings finalCfg = cfg;
            stats = stats.stream().filter(se -> {
                String name = se.name().getString().toLowerCase(Locale.ROOT);
                class_2960 id = class_7923.field_41190.method_10221((Object)((class_1320)se.attribute().comp_349()));
                String idStr = id == null ? "" : id.toString().toLowerCase(Locale.ROOT);
                return name.contains(q) || idStr.contains(q);
            }).sorted(Comparator.comparingInt(se -> this.orderScore(class_7923.field_41190.method_10221((Object)((class_1320)se.attribute().comp_349())), finalCfg)).thenComparing(se -> se.name().getString())).collect(Collectors.toList());
            for (StatEntry statEntry : stats) {
                class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)statEntry.attribute().comp_349()));
                class_2960 icon2 = this.resolveAttrIcon(attrId, cfg);
                if (statEntry.isNaN()) {
                    boolean hasChanges = this.hasModifiers(statEntry);
                    if (icon2 == null && hasChanges) {
                        icon2 = CHANGED;
                    }
                    this.items.add(icon2 != null ? Item.statBonus(statEntry, icon2) : Item.statBonusBullet(statEntry));
                    continue;
                }
                if (icon2 == null && this.hasModifiers(statEntry)) {
                    icon2 = CHANGED;
                }
                this.items.add(icon2 != null ? Item.stat(statEntry, icon2) : Item.statBullet(statEntry));
            }
            int acc = 0;
            for (Item it : this.items) {
                this.prefixHeights.add(acc);
                acc += it.height;
            }
            return;
        }
        if (stats.isEmpty()) {
            return;
        }
        HashMap<class_2960, StatEntry> byId = new HashMap<class_2960, StatEntry>();
        for (StatEntry s : stats) {
            class_2960 class_29602 = class_7923.field_41190.method_10221((Object)((class_1320)s.attribute().comp_349()));
            if (class_29602 == null) continue;
            byId.put(class_29602, s);
        }
        cfg = AttributesPanelConfig.INSTANCE.compact;
        if (cfg == null) {
            cfg = AttributesPanelConfig.CompactSettings.defaultPreset();
        }
        List<Pattern> globalBlacklist = CompactAttributePanelDrawable.compilePatterns(cfg.globalBlacklist);
        HashSet<class_2960> assigned = new HashSet<class_2960>();
        boolean bl3 = true;
        for (AttributesPanelConfig.HeaderDef headerDef : cfg.headers) {
            HeaderLayout headerLayout = this.resolveHeader(headerDef, byId, globalBlacklist, assigned);
            if (headerLayout.stats.isEmpty()) continue;
            if (!bl2) {
                this.items.add(Item.divider());
            }
            bl2 = false;
            this.items.add(Item.header(headerLayout));
            for (StatEntry se3 : headerLayout.stats) {
                class_2960 icon3 = headerLayout.iconFor(se3);
                if (icon3 == null && this.hasModifiers(se3)) {
                    icon3 = CHANGED;
                }
                this.items.add(Item.stat(se3, icon3));
            }
        }
        List remaining = byId.entrySet().stream().filter(e -> !assigned.contains(e.getKey())).map(Map.Entry::getValue).filter(se -> !CompactAttributePanelDrawable.matchesAny(globalBlacklist, class_7923.field_41190.method_10221((Object)((class_1320)se.attribute().comp_349())))).sorted(Comparator.comparing(se -> se.name().getString())).collect(Collectors.toList());
        List bonuses = remaining.stream().filter(StatEntry::isNaN).collect(Collectors.toList());
        List normal = remaining.stream().filter(se -> !se.isNaN()).collect(Collectors.toList());
        if (!bonuses.isEmpty() && !cfg.disableBonusesHeader) {
            if (!bl2) {
                this.items.add(Item.divider());
            }
            bl = false;
            HeaderLayout bonusHeader = new HeaderLayout();
            bonusHeader.headerText = cfg.bonusesHeaderName == null || cfg.bonusesHeaderName.isBlank() ? "Bonuses" : cfg.bonusesHeaderName;
            bonusHeader.headerIcon = CompactAttributePanelDrawable.tryIdentifier(cfg.bonusesHeaderIcon);
            bonusHeader.perAttrIcon = Collections.emptyMap();
            bonusHeader.stats = Collections.emptyList();
            this.items.add(Item.header(bonusHeader));
            for (StatEntry se4 : bonuses) {
                class_2960 attrId = class_7923.field_41190.method_10221((Object)((class_1320)se4.attribute().comp_349()));
                icon = this.resolveAttrIcon(attrId, cfg);
                boolean hasChanges = this.hasModifiers(se4);
                if (icon == null && hasChanges) {
                    icon = CHANGED;
                }
                this.items.add(icon != null ? Item.statBonus(se4, icon) : Item.statBonusBullet(se4));
            }
        }
        if (!normal.isEmpty() && !cfg.disableOtherHeader) {
            if (!bl) {
                this.items.add(Item.divider());
            }
            HeaderLayout other = new HeaderLayout();
            other.headerText = cfg.otherHeaderName == null || cfg.otherHeaderName.isBlank() ? "Other" : cfg.otherHeaderName;
            other.headerIcon = CompactAttributePanelDrawable.tryIdentifier(cfg.otherHeaderIcon);
            other.perAttrIcon = Collections.emptyMap();
            other.stats = normal;
            this.items.add(Item.header(other));
            for (StatEntry se2 : normal) {
                class_2960 id = class_7923.field_41190.method_10221((Object)((class_1320)se2.attribute().comp_349()));
                icon = this.resolveAttrIcon(id, cfg);
                if (icon == null && this.hasModifiers(se2)) {
                    icon = CHANGED;
                }
                if (icon != null) {
                    this.items.add(Item.stat(se2, icon));
                    continue;
                }
                this.items.add(Item.statBullet(se2));
            }
        }
        int acc = 0;
        for (Item it : this.items) {
            this.prefixHeights.add(acc);
            acc += it.height;
        }
    }

    private boolean hasModifiers(StatEntry stat) {
        class_310 client = this.root.mc();
        class_746 player = client.field_1724;
        if (player == null) {
            return false;
        }
        class_1324 instance = player.method_5996(stat.attribute());
        if (instance == null) {
            return false;
        }
        return !instance.method_6195().isEmpty();
    }

    public boolean wantsKeys() {
        return this.searchVisible && this.searchFocused;
    }

    public boolean handleCharTyped(char c, int mods) {
        return this.method_25400(c, mods);
    }

    public boolean handleKeyPressed(int key, int sc, int mods) {
        return this.method_25404(key, sc, mods);
    }

    private HeaderLayout resolveHeader(AttributesPanelConfig.HeaderDef def, Map<class_2960, StatEntry> byId, List<Pattern> globalBlacklist, Set<class_2960> assigned) {
        HeaderLayout out = new HeaderLayout();
        this.parseHeaderLabel(def.header, out);
        List<Pattern> localBlacklist = CompactAttributePanelDrawable.compilePatterns(def.blacklist);
        HashSet<class_2960> addedHere = new HashSet<class_2960>();
        if (def.attributes != null) {
            for (AttributesPanelConfig.AttributeSpec spec : def.attributes) {
                if (spec == null || spec.id == null || spec.id.isBlank()) continue;
                class_2960 iconId = CompactAttributePanelDrawable.tryIdentifier(spec.icon);
                if (spec.id.contains("*")) {
                    Pattern pat = CompactAttributePanelDrawable.globToPattern(spec.id);
                    List matches = byId.entrySet().stream().filter(e -> !assigned.contains(e.getKey())).filter(e -> !addedHere.contains(e.getKey())).filter(e -> !CompactAttributePanelDrawable.matchesAny(globalBlacklist, (class_2960)e.getKey())).filter(e -> !CompactAttributePanelDrawable.matchesAny(localBlacklist, (class_2960)e.getKey())).filter(e -> pat.matcher(((class_2960)e.getKey()).toString()).matches()).sorted(Comparator.comparing(e -> ((StatEntry)e.getValue()).name().getString())).collect(Collectors.toList());
                    for (Map.Entry e2 : matches) {
                        out.stats.add((StatEntry)e2.getValue());
                        addedHere.add((class_2960)e2.getKey());
                        assigned.add((class_2960)e2.getKey());
                        if (iconId == null) continue;
                        out.perAttrIcon.put((class_2960)e2.getKey(), iconId);
                    }
                    continue;
                }
                class_2960 id = CompactAttributePanelDrawable.tryIdentifier(spec.id);
                if (id == null || !byId.containsKey(id) || assigned.contains(id) || CompactAttributePanelDrawable.matchesAny(globalBlacklist, id) || CompactAttributePanelDrawable.matchesAny(localBlacklist, id)) continue;
                out.stats.add(byId.get(id));
                addedHere.add(id);
                assigned.add(id);
                if (iconId == null) continue;
                out.perAttrIcon.put(id, iconId);
            }
        }
        return out;
    }

    private int orderScore(class_2960 id, AttributesPanelConfig.CompactSettings cfg) {
        if (id == null || cfg == null || cfg.headers == null) {
            return Integer.MAX_VALUE;
        }
        int hIdx = 0;
        for (AttributesPanelConfig.HeaderDef def : cfg.headers) {
            if (def == null || def.attributes == null) {
                ++hIdx;
                continue;
            }
            int sIdx = 0;
            for (AttributesPanelConfig.AttributeSpec spec : def.attributes) {
                class_2960 exact;
                Pattern p;
                if (spec == null || spec.id == null || spec.id.isBlank()) {
                    ++sIdx;
                    continue;
                }
                if (spec.id.contains("*") ? (p = CompactAttributePanelDrawable.globToPattern(spec.id)).matcher(id.toString()).matches() : (exact = CompactAttributePanelDrawable.tryIdentifier(spec.id)) != null && exact.equals((Object)id)) {
                    return hIdx * 10000 + sIdx * 100;
                }
                ++sIdx;
            }
            ++hIdx;
        }
        return 0x7FFFFFFE;
    }

    private static boolean matchesAny(List<Pattern> patterns, class_2960 id) {
        if (id == null || patterns == null) {
            return false;
        }
        String s = id.toString();
        for (Pattern p : patterns) {
            if (!p.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    private static List<Pattern> compilePatterns(List<String> globs) {
        ArrayList<Pattern> out = new ArrayList<Pattern>();
        if (globs == null) {
            return out;
        }
        for (String g : globs) {
            if (g == null || g.isBlank()) continue;
            out.add(CompactAttributePanelDrawable.globToPattern(g));
        }
        return out;
    }

    private static Pattern globToPattern(String glob) {
        String escaped = Pattern.quote(glob).replace("\\*", ".*");
        return Pattern.compile("^" + escaped + "$");
    }

    private static class_2960 tryIdentifier(String s) {
        if (s == null || s.isBlank()) {
            return null;
        }
        try {
            return class_2960.method_60654((String)s);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void parseHeaderLabel(String header, HeaderLayout out) {
        if (header == null) {
            out.headerText = null;
            out.headerIcon = null;
            return;
        }
        String h = header.trim();
        int lb = h.indexOf(91);
        int rb = h.indexOf(93);
        if (lb >= 0 && rb > lb) {
            String before = h.substring(0, lb).trim();
            String inside = h.substring(lb + 1, rb).trim();
            out.headerText = before.isEmpty() ? null : before;
            out.headerIcon = CompactAttributePanelDrawable.tryIdentifier(inside);
        } else if (h.startsWith("[") && h.endsWith("]") && h.length() > 2) {
            String inside = h.substring(1, h.length() - 1).trim();
            out.headerText = null;
            out.headerIcon = CompactAttributePanelDrawable.tryIdentifier(inside);
        } else {
            out.headerText = h.isBlank() ? null : h;
            out.headerIcon = null;
        }
    }

    private void drawDivider(class_332 ctx, int innerX, int innerW, int y) {
        int center = innerX + innerW / 2;
        int dividerX = center - 32;
        dividerX = Math.max(innerX, Math.min(dividerX, innerX + innerW - 64));
        int dividerY = y + 2;
        ctx.method_25290(DIVIDER_TEXTURE, dividerX, dividerY, 0.0f, 0.0f, 64, 5, 64, 5);
    }

    private void drawHeader(class_332 ctx, class_327 font, int innerX, int innerW, int y, HeaderLayout header) {
        int drawY;
        int drawX;
        int startX;
        class_310 mc = class_310.method_1551();
        class_3300 rm = mc.method_1478();
        boolean haveText = header.headerText != null && !header.headerText.isBlank();
        boolean iconRequested = header.headerIcon != null;
        boolean iconAvailable = false;
        if (iconRequested) {
            iconAvailable = rm.method_14486(header.headerIcon).isPresent();
        }
        String missingMarker = "[cant find texture]";
        int textW = haveText ? (int)Math.ceil((float)font.method_1727(header.headerText) * 1.0f) : 0;
        int iconW = iconAvailable ? 12 : 0;
        int missingW = 0;
        int missingGap = 0;
        if (iconRequested && !iconAvailable) {
            if (haveText) {
                missingGap = 6;
                missingW = (int)Math.ceil((float)font.method_1727("[cant find texture]") * 1.0f);
            } else {
                missingW = (int)Math.ceil((float)font.method_1727("[cant find texture]") * 1.0f);
            }
        }
        int totalW = iconAvailable ? iconW + textW : (iconRequested ? (haveText ? textW + missingGap + missingW : missingW) : textW);
        int x = startX = innerX + Math.max(0, (innerW - totalW) / 2);
        if (iconAvailable) {
            ctx.method_25290(header.headerIcon, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
            x += 12;
        }
        if (haveText) {
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(1.0f, 1.0f, 1.0f);
            drawX = (int)((float)x / 1.0f);
            drawY = (int)((float)y / 1.0f);
            ctx.method_51433(font, header.headerText, drawX, drawY, this.colorHeader(), true);
            ctx.method_51448().method_22909();
            x += (int)Math.ceil((float)font.method_1727(header.headerText) * 1.0f);
        }
        if (iconRequested && !iconAvailable) {
            if (haveText) {
                x += missingGap;
            }
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(1.0f, 1.0f, 1.0f);
            drawX = (int)((float)x / 1.0f);
            drawY = (int)((float)y / 1.0f);
            ctx.method_51433(font, "[cant find texture]", drawX, drawY, this.colorMuted(), true);
            ctx.method_51448().method_22909();
        }
    }

    private void drawStat(class_332 ctx, class_327 font, int innerX, int y, StatRow statRow) {
        String rawName = statRow.stat.name().getString();
        String translationKey = class_2561.method_43471((String)((class_1320)statRow.stat.attribute().comp_349()).method_26830()).getString();
        IconLeadingCompat.IconSplit split = IconLeadingCompat.extractIconWithFallback(rawName, translationKey);
        int iconLeft = innerX;
        float fs = this.fontScale();
        if (statRow.inBonusesGroup) {
            int glyphW = (int)Math.ceil((float)font.method_1727(split.leadingIcon) * fs);
            int drawXpx = iconLeft + Math.max(0, (this.iconColW() - glyphW) / 2);
            if (split.hasIcon()) {
                ctx.method_51448().method_22903();
                ctx.method_51448().method_22905(fs, fs, 1.0f);
                int drawX = (int)((float)drawXpx / fs);
                int drawY = (int)((float)y / fs);
                ctx.method_51433(font, split.leadingIcon, drawX, drawY, 0xFFFFFF, true);
                ctx.method_51448().method_22909();
            } else if (statRow.icon != null) {
                float s = fs * 0.5625f;
                int iconDrawW = Math.round(9.0f * fs);
                int drawXpx2 = iconLeft + Math.max(0, (this.iconColW() - iconDrawW) / 2);
                ctx.method_51448().method_22903();
                ctx.method_51448().method_22905(s, s, 1.0f);
                int drawX = (int)Math.floor((float)drawXpx2 / s);
                int drawY = (int)Math.floor((float)(y - 1) / s);
                ctx.method_25290(statRow.icon, drawX, drawY, 0.0f, 0.0f, 16, 16, 16, 16);
                ctx.method_51448().method_22909();
            } else if (statRow.bullet) {
                int bx = iconLeft + Math.max(0, (this.iconColW() - 3) / 2);
                int by = y + Math.max(0, 3) + -3;
                ctx.method_25294(bx, by, bx + 3, by + 3, 0xFF000000 | this.colorBullet());
            }
            int nameLeft = iconLeft + this.iconColW() + 5;
            String bonusText = split.cleanName + " (" + statRow.stat.bonusCount() + " bonus" + (statRow.stat.bonusCount() == 1 ? "" : "es") + ")";
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(fs, fs, 1.0f);
            int nDrawX = (int)((float)nameLeft / fs);
            int drawY = (int)((float)y / fs);
            ctx.method_51433(font, bonusText, nDrawX, drawY, this.colorBody(), true);
            ctx.method_51448().method_22909();
        } else {
            int valueLeft = iconLeft + this.iconColW() + 5;
            if (split.hasIcon()) {
                int glyphW = (int)Math.ceil((float)font.method_1727(split.leadingIcon) * fs);
                int drawXpx = iconLeft + Math.max(0, (this.iconColW() - glyphW) / 2);
                ctx.method_51448().method_22903();
                ctx.method_51448().method_22905(fs, fs, 1.0f);
                int drawX = (int)((float)drawXpx / fs);
                int drawY = (int)((float)y / fs);
                ctx.method_51433(font, split.leadingIcon, drawX, drawY, 0xFFFFFF, true);
                ctx.method_51448().method_22909();
            } else if (statRow.icon != null) {
                float s = fs * 0.5625f;
                int iconDrawW = Math.round(9.0f * fs);
                int drawXpx = iconLeft + Math.max(0, (this.iconColW() - iconDrawW) / 2);
                ctx.method_51448().method_22903();
                ctx.method_51448().method_22905(s, s, 1.0f);
                int drawX = (int)Math.floor((float)drawXpx / s);
                int drawY = (int)Math.floor((float)(y - 1) / s);
                ctx.method_25290(statRow.icon, drawX, drawY, 0.0f, 0.0f, 16, 16, 16, 16);
                ctx.method_51448().method_22909();
            } else if (statRow.bullet) {
                int bx = iconLeft + Math.max(0, (this.iconColW() - 3) / 2);
                int by = y + Math.max(0, 3) + -3;
                ctx.method_25294(bx, by, bx + 3, by + 3, 0xFF000000 | this.colorBullet());
            }
            String valueStr = CompactAttributePanelDrawable.fmtValue(statRow.stat, statRow.inBonusesGroup);
            int valueW = (int)Math.ceil((float)font.method_1727(valueStr) * fs);
            int spaceW = (int)Math.ceil((float)font.method_1727(" ") * fs);
            int nameLeft = valueLeft + valueW + spaceW;
            ctx.method_51448().method_22903();
            ctx.method_51448().method_22905(fs, fs, 1.0f);
            int vDrawX = (int)((float)valueLeft / fs);
            int drawY = (int)((float)y / fs);
            ctx.method_51433(font, valueStr, vDrawX, drawY, this.colorBody(), true);
            int nDrawX = (int)((float)nameLeft / fs);
            ctx.method_51433(font, split.cleanName, nDrawX, drawY, this.colorBody(), true);
            ctx.method_51448().method_22909();
        }
    }

    private static boolean isIconGlyph(int cp) {
        return CompactAttributePanelDrawable.isBMPPUA(cp) || CompactAttributePanelDrawable.isCJKCompat(cp) || CompactAttributePanelDrawable.isPlanePUA(cp);
    }

    private static boolean isBMPPUA(int cp) {
        return cp >= 57344 && cp <= 63743;
    }

    private static boolean isCJKCompat(int cp) {
        return cp >= 63744 && cp <= 64255;
    }

    private static boolean isPlanePUA(int cp) {
        return cp >= 983040 && cp <= 1048573 || cp >= 0x100000 && cp <= 1114109;
    }

    private static NameSplit splitLeadingIcon(String s) {
        if (s == null) {
            return new NameSplit("", null);
        }
        String noCodes = CompactAttributePanelDrawable.stripSectionCodes(s);
        StringBuilder clean = new StringBuilder(noCodes.length());
        String leadingIcon = null;
        boolean tookIcon = false;
        int i = 0;
        while (i < noCodes.length()) {
            int cp = noCodes.codePointAt(i);
            int len = Character.charCount(cp);
            if (CompactAttributePanelDrawable.isIconGlyph(cp)) {
                int cp2;
                if (!tookIcon) {
                    leadingIcon = new String(Character.toChars(cp));
                }
                tookIcon = true;
                i += len;
                while (i < noCodes.length() && Character.isWhitespace(cp2 = noCodes.codePointAt(i))) {
                    i += Character.charCount(cp2);
                }
                continue;
            }
            clean.appendCodePoint(cp);
            i += len;
        }
        return new NameSplit(clean.toString().stripLeading(), leadingIcon);
    }

    private static String stripSectionCodes(String s) {
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '\u00a7') {
                if (i + 1 < s.length() && (s.charAt(i + 1) == 'x' || s.charAt(i + 1) == 'X')) {
                    i += 2;
                    for (int k = 0; k < 6 && i + 1 < s.length() && s.charAt(i) == '\u00a7'; ++k) {
                        i += 2;
                    }
                    continue;
                }
                i = Math.min(i + 2, s.length());
                continue;
            }
            int cp = s.codePointAt(i);
            out.appendCodePoint(cp);
            i += Character.charCount(cp);
        }
        return out.toString();
    }

    private int totalContentHeight() {
        if (this.items.isEmpty()) {
            return 0;
        }
        int last = this.prefixHeights.get(this.prefixHeights.size() - 1);
        return last + this.items.get((int)(this.items.size() - 1)).height;
    }

    private int prefixAt(int index) {
        if (index <= 0) {
            return 0;
        }
        if (index >= this.prefixHeights.size()) {
            return this.totalContentHeight();
        }
        return this.prefixHeights.get(index);
    }

    private int firstVisibleIndex(int offsetPx) {
        int lo = 0;
        int hi = Math.max(0, this.prefixHeights.size() - 1);
        while (lo < hi) {
            int mid = lo + hi + 1 >>> 1;
            if (this.prefixHeights.get(mid) <= offsetPx) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        if (lo >= this.items.size()) {
            lo = Math.max(0, this.items.size() - 1);
        }
        if (!this.prefixHeights.isEmpty() && this.prefixHeights.get(lo) > offsetPx) {
            return 0;
        }
        return lo;
    }

    private void drawScrollbar(class_332 ctx, int bgX, int bgY, int bgW, int innerY, int innerH, int contentH) {
        BarGeom g = this.computeBarGeom(bgX, bgY, bgW, innerY, innerH, contentH);
        if (!g.visible) {
            return;
        }
        int left = (int)Math.floor(g.x);
        int right = (int)Math.ceil(g.x + g.w);
        ctx.method_25294(left, g.y, right, g.y + g.h, 0x66000000);
        ctx.method_25294(left, g.knobY, right, g.knobY + g.knobH, -855638017);
    }

    private BarGeom computeBarGeom() {
        int bgX = this.root.left() - 16;
        int bgY = this.root.top();
        int bgW = this.root.panelWidth() + 16;
        int bgH = this.root.panelHeight();
        int innerY = bgY + 20;
        int innerH = Math.max(0, bgH - 26);
        int contentH = this.totalContentHeight();
        return this.computeBarGeom(bgX, bgY, bgW, innerY, innerH, contentH);
    }

    private BarGeom computeBarGeom(int bgX, int bgY, int bgW, int innerY, int innerH, int contentH) {
        BarGeom g = new BarGeom();
        g.x = (float)(bgX + bgW + 3) - 6.3f;
        g.y = innerY - 8;
        g.w = 3.15f;
        g.h = Math.max(1, innerH);
        if (contentH <= innerH || contentH <= 0) {
            g.visible = false;
            return g;
        }
        g.visible = true;
        g.knobH = Math.max(8, (int)((float)g.h * ((float)innerH / (float)contentH)));
        int maxOffsetPx = contentH - innerH;
        int offsetPx = Math.max(0, Math.min(this.scrollPx, maxOffsetPx));
        float pos = maxOffsetPx <= 0 ? 0.0f : (float)offsetPx / (float)maxOffsetPx;
        g.knobY = g.y + (int)((float)(g.h - g.knobH) * pos);
        g.maxOffsetPx = maxOffsetPx;
        return g;
    }

    private int offsetFromBarPosition(int desiredKnobTop, BarGeom g) {
        int track = Math.max(1, g.h - g.knobH);
        int clampedTop = Math.max(0, Math.min(desiredKnobTop, track));
        float ratio = (float)clampedTop / (float)track;
        return Math.round(ratio * (float)g.maxOffsetPx);
    }

    private void drawGlobalBonusTooltip(class_332 ctx, int mouseX, int mouseY) {
        class_746 player = this.root.mc().field_1724;
        if (player == null) {
            return;
        }
        if (this.cachedTooltipData == null) {
            TreeMap<String, Double> flatMap = new TreeMap<String, Double>();
            TreeMap<String, Double> baseMultMap = new TreeMap<String, Double>();
            TreeMap<String, Double> totalMultMap = new TreeMap<String, Double>();
            for (class_6880 entry : class_7923.field_41190.method_40270().toList()) {
                class_1320 attr = (class_1320)entry.comp_349();
                class_1324 instance = player.method_5996(entry);
                if (instance == null || instance.method_6195().isEmpty()) continue;
                String attrName = class_2561.method_43471((String)attr.method_26830()).getString();
                for (class_1322 mod : instance.method_6195()) {
                    double value = mod.comp_2449();
                    if (Math.abs(value) < 1.0E-4) continue;
                    switch (mod.comp_2450()) {
                        case field_6328: {
                            flatMap.merge(attrName, value, Double::sum);
                            break;
                        }
                        case field_6330: {
                            baseMultMap.merge(attrName, value, Double::sum);
                            break;
                        }
                        case field_6331: {
                            totalMultMap.merge(attrName, value, Double::sum);
                        }
                    }
                }
            }
            ArrayList<class_2561> allLines = new ArrayList<class_2561>();
            ArrayList<class_1799> allIcons = new ArrayList<class_1799>();
            allLines.add((class_2561)class_2561.method_43471((String)"attributepanel.message.bonuses").method_27692(class_124.field_1065));
            allIcons.add(class_1799.field_8037);
            boolean addedAny = false;
            for (String attr : flatMap.keySet()) {
                double value = (Double)flatMap.get(attr);
                allLines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+,.2f", attr, value)).method_27692(class_124.field_1060));
                allIcons.add(class_1799.field_8037);
                addedAny = true;
            }
            for (String attr : baseMultMap.keySet()) {
                double value = (Double)baseMultMap.get(attr);
                allLines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Base", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
                allIcons.add(class_1799.field_8037);
                addedAny = true;
            }
            for (String attr : totalMultMap.keySet()) {
                double value = (Double)totalMultMap.get(attr);
                allLines.add((class_2561)class_2561.method_43470((String)String.format("- %s: %+d%% Total", attr, (int)(value * 100.0))).method_27692(class_124.field_1060));
                allIcons.add(class_1799.field_8037);
                addedAny = true;
            }
            if (!addedAny) {
                allLines.add((class_2561)class_2561.method_43470((String)"No active modifiers").method_27692(class_124.field_1080));
                allIcons.add(class_1799.field_8037);
            }
            class_327 font = this.root.mc().field_1772;
            int screenHeight = this.root.mc().method_22683().method_4502();
            Objects.requireNonNull(font);
            int lineHeight = 9 + 2;
            int maxWidth = 0;
            for (class_2561 line : allLines) {
                int w = font.method_27525((class_5348)line);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            int tooltipWidth = maxWidth + 16;
            int maxVisibleLines = Math.min(20, (screenHeight - mouseY - 20) / lineHeight);
            int tooltipHeight = Math.min(allLines.size(), maxVisibleLines) * lineHeight;
            this.cachedTooltipData = new TooltipRenderData(allLines, allIcons, tooltipWidth, tooltipHeight, maxVisibleLines, allLines.size());
        }
        class_327 font = this.root.mc().field_1772;
        Objects.requireNonNull(font);
        int lineHeight = 9 + 2;
        if (this.cachedTooltipData.totalLines <= this.cachedTooltipData.maxVisibleLines) {
            this.globalTooltipScrollOffset = 0;
            this.root.enqueueTooltip(this.cachedTooltipData.allLines, this.cachedTooltipData.allIcons, mouseX, mouseY);
        } else {
            int maxScroll = Math.max(0, (this.cachedTooltipData.totalLines - this.cachedTooltipData.maxVisibleLines) * lineHeight);
            if (this.globalTooltipScrollOffset > maxScroll) {
                this.globalTooltipScrollOffset = maxScroll;
            }
            if (this.globalTooltipScrollOffset < 0) {
                this.globalTooltipScrollOffset = 0;
            }
            int startLine = this.globalTooltipScrollOffset / lineHeight;
            int endLine = Math.min(this.cachedTooltipData.totalLines, startLine + this.cachedTooltipData.maxVisibleLines);
            ArrayList<class_2561> visibleLines = new ArrayList<class_2561>();
            ArrayList<class_1799> visibleIcons = new ArrayList<class_1799>(this.cachedTooltipData.allIcons.subList(startLine, endLine));
            int paddingNeeded = this.cachedTooltipData.tooltipWidth;
            for (int i = startLine; i < endLine; ++i) {
                class_2561 line = this.cachedTooltipData.allLines.get(i);
                int currentWidth = font.method_27525((class_5348)line);
                int neededPadding = paddingNeeded - currentWidth - 16;
                if (neededPadding > 0) {
                    int spaces = neededPadding / font.method_1727(" ") + 1;
                    String padding = " ".repeat(spaces);
                    class_5250 paddedLine = line.method_27661().method_10852((class_2561)class_2561.method_43470((String)padding));
                    visibleLines.add((class_2561)paddedLine);
                    continue;
                }
                visibleLines.add(line);
            }
            this.root.enqueueTooltip(visibleLines, visibleIcons, mouseX, mouseY);
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY - 12;
            int contentHeight = this.cachedTooltipData.totalLines * lineHeight;
            int visibleHeight = this.cachedTooltipData.tooltipHeight;
            if (contentHeight > visibleHeight) {
                float scrollbarH = visibleHeight;
                float knobH = Math.max(20.0f, scrollbarH * ((float)visibleHeight / (float)contentHeight));
                float scrollRatio = (float)this.globalTooltipScrollOffset / (float)maxScroll;
                float knobY = (float)tooltipY + (scrollbarH - knobH) * scrollRatio;
                int scrollbarX = tooltipX + this.cachedTooltipData.tooltipWidth + 2;
                ctx.method_25294(scrollbarX, tooltipY, scrollbarX + 3, tooltipY + (int)scrollbarH, 0x66000000);
                ctx.method_25294(scrollbarX, (int)knobY, scrollbarX + 3, (int)(knobY + knobH), -855638017);
            }
        }
    }

    public void method_25365(boolean focused) {
        this.hasFocus = focused;
        boolean bl = this.searchFocused = focused && this.searchVisible;
        if (this.searchFocused) {
            this.caret = this.searchText.length();
            this.clearSelection();
        }
    }

    public boolean method_25370() {
        return this.hasFocus;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    private static class TooltipRenderData {
        List<class_2561> allLines;
        List<class_1799> allIcons;
        int tooltipWidth;
        int tooltipHeight;
        int maxVisibleLines;
        int totalLines;

        TooltipRenderData(List<class_2561> allLines, List<class_1799> allIcons, int tooltipWidth, int tooltipHeight, int maxVisibleLines, int totalLines) {
            this.allLines = allLines;
            this.allIcons = allIcons;
            this.tooltipWidth = tooltipWidth;
            this.tooltipHeight = tooltipHeight;
            this.maxVisibleLines = maxVisibleLines;
            this.totalLines = totalLines;
        }
    }

    private static class Item {
        final ItemType type;
        final int height;
        HeaderLayout header;
        StatRow stat;

        private Item(ItemType t, int height) {
            this.type = t;
            this.height = height;
        }

        static Item divider() {
            return new Item(ItemType.DIVIDER, 9);
        }

        static Item header(HeaderLayout h) {
            Item it = new Item(ItemType.HEADER, 19);
            it.header = h;
            return it;
        }

        static Item stat(StatEntry se, class_2960 icon) {
            Item it = new Item(ItemType.STAT, 9);
            it.stat = new StatRow(se, icon, icon == null, false);
            return it;
        }

        static Item statBullet(StatEntry se) {
            Item it = new Item(ItemType.STAT, 9);
            it.stat = new StatRow(se, null, true, false);
            return it;
        }

        static Item statBonus(StatEntry se, class_2960 icon) {
            Item it = new Item(ItemType.STAT, 9);
            it.stat = new StatRow(se, icon, icon == null, true);
            return it;
        }

        static Item statBonusBullet(StatEntry se) {
            Item it = new Item(ItemType.STAT, 9);
            it.stat = new StatRow(se, null, true, true);
            return it;
        }
    }

    private static enum ItemType {
        DIVIDER,
        HEADER,
        STAT;

    }

    private static class HeaderLayout {
        String headerText;
        class_2960 headerIcon;
        List<StatEntry> stats = new ArrayList<StatEntry>();
        Map<class_2960, class_2960> perAttrIcon = new HashMap<class_2960, class_2960>();

        private HeaderLayout() {
        }

        class_2960 iconFor(StatEntry s) {
            class_2960 id = class_7923.field_41190.method_10221((Object)((class_1320)s.attribute().comp_349()));
            return id != null ? this.perAttrIcon.get(id) : null;
        }
    }

    private static class StatRow {
        final StatEntry stat;
        final class_2960 icon;
        final boolean bullet;
        final boolean inBonusesGroup;

        StatRow(StatEntry se, class_2960 icon) {
            this(se, icon, false, false);
        }

        StatRow(StatEntry se, class_2960 icon, boolean bullet, boolean inBonusesGroup) {
            this.stat = se;
            this.icon = icon;
            this.bullet = bullet;
            this.inBonusesGroup = inBonusesGroup;
        }
    }

    private static final class NameSplit {
        final String cleanName;
        final String leadingIcon;

        NameSplit(String cleanName, String leadingIcon) {
            this.cleanName = cleanName;
            this.leadingIcon = leadingIcon;
        }
    }

    private static final class BarGeom {
        float x;
        float w;
        int y;
        int h;
        int knobY;
        int knobH;
        int maxOffsetPx;
        boolean visible;

        private BarGeom() {
        }
    }
}

