/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1320;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.pixeldreamstudios.attributepanel.client.AttributePanelDrawable;
import net.pixeldreamstudios.attributepanel.client.StatEntry;
import net.pixeldreamstudios.attributepanel.compat.IconLeadingCompat;

@Environment(value=EnvType.CLIENT)
class VanillaAttributePanelDrawable {
    private final AttributePanelDrawable root;
    private static final class_2960 NAME_BG = class_2960.method_60655((String)"minecraft", (String)"textures/block/light_gray_concrete.png");
    private static final class_2960 VALUE_BG = class_2960.method_60655((String)"minecraft", (String)"textures/block/gray_concrete.png");

    VanillaAttributePanelDrawable(AttributePanelDrawable root) {
        this.root = root;
    }

    void render(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 font = this.root.mc().field_1772;
        int rowHeight = 24;
        int padding = 2;
        int visibleRows = 6;
        int totalPages = (int)Math.ceil((float)this.root.getCachedStats().size() / (float)visibleRows);
        this.root.setCurrentPage(Math.min(this.root.getCurrentPage(), Math.max(totalPages - 1, 0)));
        if (this.root.getShowOnlyChanged() && this.root.getCachedStats().isEmpty()) {
            String noStatsText = "No changed attributes";
            int textWidth = font.method_1727(noStatsText);
            context.method_51433(font, noStatsText, this.root.left() + (this.root.panelWidth() - textWidth) / 2, this.root.top() + 8, 0xAAAAAA, false);
            this.drawVanillaButtons(context, font, mouseX, mouseY, this.root.top() + this.root.panelHeight() - 12);
            return;
        }
        int startIndex = this.root.getCurrentPage() * visibleRows;
        int endIndex = Math.min(startIndex + visibleRows, this.root.getCachedStats().size());
        int rowY = this.root.top() + padding;
        int hoverIndex = -1;
        for (int i = startIndex; i < endIndex; ++i) {
            int color;
            Object valueStr;
            String topLine;
            StatEntry stat = this.root.getCachedStats().get(i);
            int rowIndex = i - startIndex;
            int yOffset = rowY + rowIndex * rowHeight;
            String rawName = stat.name().getString();
            String translationKey = class_2561.method_43471((String)((class_1320)stat.attribute().comp_349()).method_26830()).getString();
            IconLeadingCompat.IconSplit split = IconLeadingCompat.extractIconWithFallback(rawName, translationKey);
            String statName = split.cleanName;
            int maxNameWidth = this.root.panelWidth() / 2 - 8;
            Object bottomLine = null;
            if (font.method_1727(statName) <= maxNameWidth) {
                topLine = statName;
            } else {
                topLine = font.method_27523(statName, maxNameWidth);
                String remainder = statName.substring(topLine.length()).trim();
                if (!remainder.isEmpty()) {
                    bottomLine = font.method_27523(remainder, maxNameWidth);
                    if (font.method_1727(remainder) > maxNameWidth) {
                        while (font.method_1727((String)bottomLine + "...") > maxNameWidth && ((String)bottomLine).length() > 0) {
                            bottomLine = ((String)bottomLine).substring(0, ((String)bottomLine).length() - 1);
                        }
                        bottomLine = (String)bottomLine + "...";
                    }
                }
            }
            int nameX = this.root.left() + 15;
            int valueX = this.root.left() + this.root.panelWidth() - 12;
            int nameY = yOffset + (rowHeight - 8) / 2;
            if (split.hasIcon()) {
                context.method_51433(font, split.leadingIcon, nameX, nameY, 3813155, false);
                nameX += font.method_1727(split.leadingIcon + " ");
            }
            if (bottomLine == null) {
                context.method_51433(font, topLine, nameX, nameY, 3813155, false);
            } else {
                context.method_51433(font, topLine, nameX, yOffset + 4, 3813155, false);
                context.method_51433(font, (String)bottomLine, nameX, yOffset + 12, 7167048, false);
            }
            Object object = valueStr = stat.percent() ? String.format("%d%%", (int)(stat.current() * 100.0)) : String.format("%.2f", stat.current());
            int n = stat.isChanged() ? (stat.current() > stat.base() ? 0x55FF55 : 0xFF5555) : (color = 0xAAAAAA);
            valueStr = (String)valueStr + (stat.isChanged() ? (stat.current() > stat.base() ? " \u2191" : " \u2193") : "");
            int valueY = yOffset + (rowHeight - 8) / 2;
            context.method_51433(font, (String)valueStr, this.root.left() + this.root.panelWidth() - 4 - font.method_1727((String)valueStr), valueY, color, false);
            context.method_25294(this.root.left(), yOffset + rowHeight - 1, this.root.left() + this.root.panelWidth(), yOffset + rowHeight, -12303292);
            if (mouseX < this.root.left() || mouseX > this.root.left() + this.root.panelWidth() || mouseY < yOffset || mouseY > yOffset + rowHeight) continue;
            hoverIndex = i;
        }
        this.drawVanillaTooltipButton(context, font, hoverIndex, mouseX, mouseY, rowHeight, padding);
    }

    boolean mouseClicked(double mouseX, double mouseY, int button) {
        int btnY = this.root.top() + this.root.panelHeight() - 12;
        String prevText = "\u00ab Prev";
        String nextText = "Next \u00bb";
        String checkLabel = "[ " + (this.root.getShowOnlyChanged() ? "\u2713" : " ") + " ]";
        int spacing = 12;
        class_327 font = this.root.mc().field_1772;
        int prevWidth = font.method_1727(prevText);
        int checkWidth = font.method_1727(checkLabel);
        int nextWidth = font.method_1727(nextText);
        int centerX = this.root.left() + this.root.panelWidth() / 2;
        int prevX = centerX - checkWidth / 2 - spacing - prevWidth;
        int checkX = centerX - checkWidth / 2;
        int nextX = centerX + checkWidth / 2 + spacing;
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, prevX, btnY, prevWidth, 10)) {
            if (this.root.getCurrentPage() > 0) {
                this.root.setCurrentPage(this.root.getCurrentPage() - 1);
            }
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 0.5f);
            }
            return true;
        }
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, nextX, btnY, nextWidth, 10)) {
            int totalPages = (int)Math.ceil((float)this.root.getCachedStats().size() / 6.0f);
            if (this.root.getCurrentPage() < totalPages - 1) {
                this.root.setCurrentPage(this.root.getCurrentPage() + 1);
            }
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 0.5f);
            }
            return true;
        }
        if (AttributePanelDrawable.mouseIn((int)mouseX, (int)mouseY, checkX, btnY, checkWidth, 10)) {
            this.root.setShowOnlyChanged(!this.root.getShowOnlyChanged());
            this.root.setCurrentPage(0);
            this.root.cacheStats();
            if (this.root.mc().field_1724 != null) {
                this.root.mc().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.5f, 0.5f);
            }
            return true;
        }
        return false;
    }

    private void drawVanillaButtons(class_332 context, class_327 font, int mouseX, int mouseY, int btnY) {
        String prevText = "\u00ab Prev";
        String nextText = "Next \u00bb";
        String checkLabel = "[ " + (this.root.getShowOnlyChanged() ? "\u2713" : " ") + " ]";
        int spacing = 12;
        int buttonHeight = 10;
        int prevWidth = font.method_1727(prevText);
        int checkWidth = font.method_1727(checkLabel);
        int nextWidth = font.method_1727(nextText);
        int centerX = this.root.left() + this.root.panelWidth() / 2;
        int prevX = centerX - checkWidth / 2 - spacing - prevWidth;
        int checkX = centerX - checkWidth / 2;
        int nextX = centerX + checkWidth / 2 + spacing;
        context.method_51433(font, prevText, prevX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, prevX, btnY, prevWidth, buttonHeight) ? 0xFFFFFF : 0xAAAAAA, false);
        context.method_51433(font, checkLabel, checkX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, checkX, btnY, checkWidth, buttonHeight) ? 0xFFFFFF : 0xAAAAAA, false);
        context.method_51433(font, nextText, nextX, btnY, AttributePanelDrawable.mouseIn(mouseX, mouseY, nextX, btnY, nextWidth, buttonHeight) ? 0xFFFFFF : 0xAAAAAA, false);
    }

    private void drawVanillaTooltipButton(class_332 context, class_327 font, int hoverIndex, int mouseX, int mouseY, int rowHeight, int padding) {
        this.root.drawTooltipContent(context, font, hoverIndex, mouseX, mouseY, rowHeight, padding);
        int btnY = this.root.top() + this.root.panelHeight() - 12;
        this.drawVanillaButtons(context, font, mouseX, mouseY, btnY);
    }
}

