/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.command.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.pixeldreamstudios.attributepanel.compat.TrinketsCompat;
import net.pixeldreamstudios.attributepanel.network.NetworkManager;
import net.pixeldreamstudios.attributepanel.network.payload.RequestAttributeSnapshotPayload;

public class AttributeSnapshotCommandImpl {
    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> AttributeSnapshotCommandImpl.registerCommand((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    public static void registerAttributeCheck() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> AttributeSnapshotCommandImpl.registerAttributeCheckCommand((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"attributesnapshot").then(ClientCommandManager.argument((String)"target", (ArgumentType)StringArgumentType.word()).executes(ctx -> AttributeSnapshotCommandImpl.execute((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"target")))));
    }

    private static void registerAttributeCheckCommand(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        SuggestionProvider attributeSuggestions = (context, builder) -> {
            class_7923.field_41190.method_10235().forEach(id -> builder.suggest(id.toString()));
            return builder.buildFuture();
        };
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"attributepanel").then(ClientCommandManager.argument((String)"attribute", (ArgumentType)StringArgumentType.greedyString()).suggests(attributeSuggestions).executes(ctx -> AttributeSnapshotCommandImpl.executeAttributeCheck((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"attribute")))));
    }

    private static int execute(CommandContext<FabricClientCommandSource> ctx, String targetName) {
        class_746 player = ((FabricClientCommandSource)ctx.getSource()).getPlayer();
        RequestAttributeSnapshotPayload payload = new RequestAttributeSnapshotPayload(targetName);
        NetworkManager.sendToServer(payload);
        player.method_43496((class_2561)class_2561.method_43470((String)("Requested attribute snapshot for: " + targetName)).method_27692(class_124.field_1080));
        return 1;
    }

    private static int executeAttributeCheck(CommandContext<FabricClientCommandSource> ctx, String attributeId) {
        class_2960 attrResourceLocation;
        class_746 player = ((FabricClientCommandSource)ctx.getSource()).getPlayer();
        try {
            attrResourceLocation = class_2960.method_60654((String)attributeId);
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Invalid attribute ID: " + attributeId)).method_27692(class_124.field_1061));
            return 0;
        }
        class_6880.class_6883 attrHolder = class_7923.field_41190.method_55841(attrResourceLocation).orElse(null);
        if (attrHolder == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("Attribute not found: " + attributeId)).method_27692(class_124.field_1061));
            return 0;
        }
        class_1320 attribute = (class_1320)attrHolder.comp_349();
        class_1324 instance = player.method_5996((class_6880)attrHolder);
        if (instance == null) {
            player.method_43496((class_2561)class_2561.method_43470((String)("You don't have this attribute:  " + attributeId)).method_27692(class_124.field_1061));
            return 0;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)"=== Modifiers for:  ").method_10852((class_2561)class_2561.method_43471((String)attribute.method_26830())).method_27693(" ===").method_27692(class_124.field_1065));
        player.method_43496((class_2561)class_2561.method_43470((String)("Base Value: " + String.format("%.2f", instance.method_6201()))).method_27692(class_124.field_1054));
        player.method_43496((class_2561)class_2561.method_43470((String)("Final Value: " + String.format("%.2f", instance.method_6194()))).method_27692(class_124.field_1075));
        Set modifiers = instance.method_6195();
        if (modifiers.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43470((String)"No modifiers found.").method_27692(class_124.field_1080));
            return 1;
        }
        player.method_43496((class_2561)class_2561.method_43470((String)""));
        player.method_43496((class_2561)class_2561.method_43470((String)"Modifiers:").method_27692(class_124.field_1054));
        HashMap<class_1322.class_1323, List> grouped = new HashMap<class_1322.class_1323, List>();
        for (class_1322 mod : modifiers) {
            grouped.computeIfAbsent(mod.comp_2450(), k -> new ArrayList()).add(mod);
        }
        if (grouped.containsKey(class_1322.class_1323.field_6328)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"  Flat Additions:").method_27692(class_124.field_1060));
            for (class_1322 mod : (List)grouped.get(class_1322.class_1323.field_6328)) {
                AttributeSnapshotCommandImpl.displayModifier(player, mod, (class_6880<class_1320>)attrHolder);
            }
        }
        if (grouped.containsKey(class_1322.class_1323.field_6330)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"  Base Multipliers:").method_27692(class_124.field_1078));
            for (class_1322 mod : (List)grouped.get(class_1322.class_1323.field_6330)) {
                AttributeSnapshotCommandImpl.displayModifier(player, mod, (class_6880<class_1320>)attrHolder);
            }
        }
        if (grouped.containsKey(class_1322.class_1323.field_6331)) {
            player.method_43496((class_2561)class_2561.method_43470((String)"  Total Multipliers:").method_27692(class_124.field_1076));
            for (class_1322 mod : (List)grouped.get(class_1322.class_1323.field_6331)) {
                AttributeSnapshotCommandImpl.displayModifier(player, mod, (class_6880<class_1320>)attrHolder);
            }
        }
        return 1;
    }

    private static void displayModifier(class_746 player, class_1322 mod, class_6880<class_1320> attrHolder) {
        String opText = AttributeSnapshotCommandImpl.formatModifier(mod);
        String source = AttributeSnapshotCommandImpl.guessSource(mod.comp_2447(), player, attrHolder);
        player.method_43496((class_2561)class_2561.method_43470((String)("    \u2022 " + opText)).method_10852((class_2561)class_2561.method_43470((String)(" - " + source)).method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(" (ID: " + String.valueOf(mod.comp_2447()) + ")")).method_27692(class_124.field_1063)).method_27692(class_124.field_1068));
    }

    private static String guessSource(class_2960 modId, class_746 player, class_6880<class_1320> attrHolder) {
        String namespace = modId.method_12836();
        String path = modId.method_12832();
        if (TrinketsCompat.isLoaded()) {
            List<TrinketsCompat.TrinketModifierSource> trinketMods = TrinketsCompat.getTrinketModifierSources((class_1657)player);
            for (TrinketsCompat.TrinketModifierSource source : trinketMods) {
                if (!source.attribute().equals(attrHolder) || !source.modifier().comp_2447().equals((Object)modId)) continue;
                return "Trinket:  " + source.stack().method_7964().getString() + " [" + source.slotType() + "]";
            }
        }
        for (class_1293 effectInstance : player.method_6026()) {
            class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
            if (!path.contains("effect") && !path.contains(effect.method_5567())) continue;
            return "Effect: " + class_2561.method_43471((String)effect.method_5567()).getString();
        }
        return switch (namespace) {
            case "minecraft" -> "Vanilla";
            case "tiered" -> "Tiered Item";
            case "puffish_skills" -> "Puffish Skills";
            case "rpg-systems" -> "RPG Systems";
            case "reskillable" -> "Reskillable";
            case "dungeon_difficulty" -> "Dungeon Difficulty";
            case "morequesttypes" -> "Quest Reward";
            default -> "Mod: " + namespace;
        };
    }

    private static String formatModifier(class_1322 mod) {
        return switch (mod.comp_2450()) {
            default -> throw new MatchException(null, null);
            case class_1322.class_1323.field_6328 -> String.format("%+.2f", mod.comp_2449());
            case class_1322.class_1323.field_6330 -> String.format("%+d%% Base", (int)(mod.comp_2449() * 100.0));
            case class_1322.class_1323.field_6331 -> String.format("%+d%% Total", (int)(mod.comp_2449() * 100.0));
        };
    }
}

