/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.attributepanel.compat.fabric;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.pixeldreamstudios.attributepanel.compat.TrinketsCompat;

public class TrinketsCompatImpl {
    public static boolean isLoaded() {
        return FabricLoader.getInstance().isModLoaded("trinkets");
    }

    public static List<TrinketsCompat.TrinketModifierSource> getTrinketModifierSourcesImpl(class_1657 player) {
        ArrayList<TrinketsCompat.TrinketModifierSource> results = new ArrayList<TrinketsCompat.TrinketModifierSource>();
        Optional optComponent = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optComponent.isEmpty()) {
            return results;
        }
        TrinketComponent component = (TrinketComponent)optComponent.get();
        List equipped = component.getEquipped(stack -> true);
        for (class_3545 pair : equipped) {
            SlotReference ref = (SlotReference)pair.method_15442();
            class_1799 stack2 = (class_1799)pair.method_15441();
            if (stack2.method_7960()) continue;
            String slotType = ref.inventory().getSlotType().getName();
            Multimap modifiers = TrinketModifiers.get((class_1799)stack2, (SlotReference)ref, (class_1309)player);
            Collection entries = modifiers.entries();
            for (Map.Entry entry : entries) {
                class_6880 attribute = (class_6880)entry.getKey();
                class_1322 modifier = (class_1322)entry.getValue();
                class_2960 rawId = modifier.comp_2447();
                results.add(new TrinketsCompat.TrinketModifierSource(stack2, modifier, (class_6880<class_1320>)attribute, rawId, slotType));
            }
        }
        return results;
    }

    public static List<class_1799> getAllEquippedTrinkets(class_1657 player) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        Optional optComponent = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optComponent.isEmpty()) {
            return results;
        }
        List equipped = ((TrinketComponent)optComponent.get()).getEquipped(stack -> true);
        for (class_3545 pair : equipped) {
            class_1799 stack2 = (class_1799)pair.method_15441();
            if (stack2.method_7960()) continue;
            results.add(stack2);
        }
        return results;
    }

    public static boolean isEquippedAsTrinket(class_1657 player, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        Optional optComponent = TrinketsApi.getTrinketComponent((class_1309)player);
        if (optComponent.isEmpty()) {
            return false;
        }
        List equipped = ((TrinketComponent)optComponent.get()).getEquipped(itemStack -> true);
        for (class_3545 pair : equipped) {
            class_1799 equippedStack = (class_1799)pair.method_15441();
            if (!class_1799.method_7973((class_1799)stack, (class_1799)equippedStack)) continue;
            return true;
        }
        return false;
    }
}

