/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1058;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4074;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.pixeldreamstudios.attributepanel.api.AttributePanelAPI;
import net.pixeldreamstudios.showmeyourbuild.Showmeyourbuild;
import net.pixeldreamstudios.showmeyourbuild.client.BonusDataStore;
import net.pixeldreamstudios.showmeyourbuild.client.LiveEffectStore;
import net.pixeldreamstudios.showmeyourbuild.client.SkillTreeSnapshotLoader;
import net.pixeldreamstudios.showmeyourbuild.client.gui.ReadOnlySkillsScreen;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.AccessorySlotRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.BonusesPanelRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.BuildViewModelRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.PlayerSnapshot;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.PotionEffectRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.SlotRenderer;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatsViewRenderer;
import net.pixeldreamstudios.showmeyourbuild.network.CategoryCache;
import net.pixeldreamstudios.showmeyourbuild.network.payload.OpenSkillsPayload;
import net.pixeldreamstudios.showmeyourbuild.network.payload.RequestLiveEffectsPayload;
import net.pixeldreamstudios.showmeyourbuild.util.ModCompat;
import net.puffish.skillsmod.client.data.ClientCategoryData;

@Environment(value=EnvType.CLIENT)
public class BuildViewScreen
extends class_437 {
    public PlayerSnapshot.SnapshotData snapshot = null;
    private long statsToggleTime = 0L;
    private static final int BOUNCE_HEIGHT = 5;
    private long lastEffectRequestTime = 0L;
    private boolean wasHoveringPotions = false;
    private static final long EFFECT_REQUEST_COOLDOWN_MS = 1000L;
    public static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/gui/gui2.png");
    public static final class_2960 SLOT_BACKGROUND = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/gui/slot_gui.png");
    public static final class_2960 SLOT_BACKGROUND_ACCESSORY = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/gui/slot_gui3.png");
    public static final class_2960 SKILL_BUTTON = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/button/sword16x16.png");
    public static final class_2960 STATS_BUTTON = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/button/stat_button.png");
    public static final class_2960 STATS_SLOT = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/gui/stat_slot.png");
    public static final class_2960 BUILD_BUTTON = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/button/bag.png");
    public static final class_2960 POTIONS_VIEWER = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/button/potions.png");
    public static final class_2960 BONUSES_VIEWER = class_2960.method_60655((String)"showmeyourbuild", (String)"textures/button/apple.png");
    public final class_1657 player;
    private boolean showPotionOverlay = false;
    private boolean showBonusPanel = false;
    private final String localPlayerName = class_310.method_1551().method_1548().method_1676();
    public class_1657 snapshotPlayer = null;
    public class_1799[] armorStacks = null;
    public class_1799 mainHand = class_1799.field_8037;
    public class_1799 offHand = class_1799.field_8037;
    public String displayNameOverride = null;
    public float modelYaw = 0.0f;
    public boolean dragging = false;
    public double lastMouseX;
    private ViewMode currentView = ViewMode.BUILD;

    public BuildViewScreen(class_1657 player) {
        super((class_2561)class_2561.method_43470((String)"Build Viewer"));
        this.player = player;
        this.displayNameOverride = player.method_5477().getString();
        this.armorStacks = (class_1799[])player.method_31548().field_7548.toArray((Object[])new class_1799[0]);
        this.mainHand = player.method_6047();
        this.offHand = player.method_6079();
        if (ModCompat.ATTRIBUTE_PANEL_LOADED) {
            class_2487 attrNbt = AttributePanelAPI.getAttributeSnapshot((class_1657)player);
            StatsViewRenderer.setLiveTargetPlayer(player);
            StatsViewRenderer.loadAttributes(attrNbt);
            BonusDataStore.loadFromNbt(attrNbt);
        }
    }

    public BuildViewScreen(class_2487 data) {
        this(data.method_10558("Name"), data);
    }

    public BuildViewScreen(String playerName, class_2487 data) {
        super((class_2561)class_2561.method_43470((String)"Build Viewer"));
        this.player = class_310.method_1551().field_1724;
        this.snapshot = PlayerSnapshot.fromNbt(data, playerName, this.player);
        if (data.method_10573("Attributes", 10)) {
            class_2487 attrNbt = data.method_10562("Attributes");
            StatsViewRenderer.loadAttributes(attrNbt, true);
            BonusDataStore.loadFromNbt(attrNbt);
        }
        this.snapshotPlayer = this.snapshot.player();
        this.armorStacks = this.snapshot.armor();
        this.mainHand = this.snapshot.mainHand();
        this.offHand = this.snapshot.offHand();
        this.displayNameOverride = playerName;
        if (ModCompat.PUFFISH_LOADED && data.method_10545("Skills")) {
            class_2487 skillData = data.method_10562("Skills");
            Map<class_2960, ClientCategoryData> categories = SkillTreeSnapshotLoader.load(skillData);
            CategoryCache.clear();
            categories.values().forEach(CategoryCache::put);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        long now;
        boolean hoveringSkill;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        super.method_25394(context, mouseX, mouseY, delta);
        class_1657 target = this.snapshotPlayer != null ? this.snapshotPlayer : this.player;
        List accessoriesToRender = null;
        int accessoryCount = 0;
        if (this.snapshot != null) {
            accessoriesToRender = this.snapshot.accessories();
            accessoryCount = accessoriesToRender != null ? accessoriesToRender.size() : 0;
        } else if (ModCompat.TRINKETS_LOADED) {
            accessoriesToRender = TrinketsApi.getTrinketComponent((class_1309)this.player).map(c -> c.getAllEquipped().stream().map(p -> (class_1799)p.method_15441()).toList()).orElse(null);
            accessoryCount = accessoriesToRender != null ? accessoriesToRender.size() : 0;
        }
        boolean hasAccessories = accessoryCount > 0;
        int accessoryRows = (int)Math.ceil((double)Math.min(accessoryCount, 20) / 10.0);
        int extraHeight = 0;
        if (accessoryRows > 1) {
            extraHeight = 25;
        } else if (accessoryRows == 1) {
            extraHeight = 15;
        }
        int baseHeight = 152;
        int textureHeight = baseHeight + extraHeight;
        int verticalOffset = -textureHeight / 2;
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        context.method_25290(BACKGROUND_TEXTURE, centerX - 128, centerY + verticalOffset, 0.0f, 0.0f, 256, textureHeight, 256, textureHeight);
        int skillBtnX = centerX - 120 + 5;
        int skillBtnY = centerY + verticalOffset + 20;
        int skillBtnSize = 16;
        boolean bl = hoveringSkill = mouseX >= skillBtnX && mouseX < skillBtnX + skillBtnSize && mouseY >= skillBtnY && mouseY < skillBtnY + skillBtnSize;
        if (hoveringSkill) {
            RenderSystem.setShaderColor((float)1.25f, (float)1.25f, (float)1.25f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)SKILL_BUTTON);
        context.method_25290(SKILL_BUTTON, skillBtnX, skillBtnY, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (hoveringSkill & ModCompat.PUFFISH_LOADED) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.showmeyourbuild.skills"), mouseX, mouseY);
        } else if (hoveringSkill & !ModCompat.PUFFISH_LOADED) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.showmeyourbuild.install_puffish_skills"), mouseX, mouseY);
        }
        int statsBtnX = centerX + 120 - 21;
        int statsBtnY = centerY + verticalOffset + 20;
        int statsBtnSize = 16;
        boolean hoveringStats = mouseX >= statsBtnX && mouseX < statsBtnX + statsBtnSize && mouseY >= statsBtnY && mouseY < statsBtnY + statsBtnSize;
        RenderSystem.setShaderColor((float)(hoveringStats ? 1.25f : 1.0f), (float)(hoveringStats ? 1.25f : 1.0f), (float)(hoveringStats ? 1.25f : 1.0f), (float)1.0f);
        class_2960 rightButtonIcon = this.currentView == ViewMode.BUILD ? STATS_BUTTON : BUILD_BUTTON;
        RenderSystem.setShaderTexture((int)0, (class_2960)rightButtonIcon);
        context.method_25290(rightButtonIcon, statsBtnX, statsBtnY, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (hoveringStats) {
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)(this.currentView == ViewMode.BUILD ? "gui.showmeyourbuild.stats" : "gui.showmeyourbuild.build")), mouseX, mouseY);
        }
        int adjustedCenterY = centerY + verticalOffset + 76;
        boolean hoveringPotions = false;
        if (this.currentView == ViewMode.BUILD) {
            SlotRenderer.renderSlots(context, this.player, this.snapshotPlayer, this.armorStacks, this.snapshot != null ? this.mainHand : this.player.method_6047(), this.snapshot != null ? this.offHand : this.player.method_6079(), centerX, adjustedCenterY, this.field_22793, mouseX, mouseY);
            if (hasAccessories) {
                int accessoryAreaTop = adjustedCenterY + 57;
                int accessoryAreaHeight = 40;
                int accessoryAreaCenterY = accessoryAreaTop + accessoryAreaHeight / 2;
                AccessorySlotRenderer.render(context, target, accessoriesToRender, centerX, accessoryAreaCenterY, this.field_22793, mouseX, mouseY);
            }
            int potionsBtnX = centerX + 120 - 21;
            int potionsBtnY = centerY - textureHeight / 2 + 48;
            hoveringPotions = mouseX >= potionsBtnX && mouseX < potionsBtnX + 16 && mouseY >= potionsBtnY && mouseY < potionsBtnY + 16;
            RenderSystem.setShaderColor((float)(hoveringPotions ? 1.25f : 1.0f), (float)(hoveringPotions ? 1.25f : 1.0f), (float)(hoveringPotions ? 1.25f : 1.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)POTIONS_VIEWER);
            context.method_25290(POTIONS_VIEWER, potionsBtnX, potionsBtnY, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int bonusBtnX = centerX - 120 + 5;
            int bonusBtnY = centerY - textureHeight / 2 + 48;
            boolean hoveringBonus = mouseX >= bonusBtnX && mouseX < bonusBtnX + 16 && mouseY >= bonusBtnY && mouseY < bonusBtnY + 16;
            RenderSystem.setShaderColor((float)(hoveringBonus ? 1.25f : 1.0f), (float)(hoveringBonus ? 1.25f : 1.0f), (float)(hoveringBonus ? 1.25f : 1.0f), (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)BONUSES_VIEWER);
            context.method_25290(BONUSES_VIEWER, bonusBtnX, bonusBtnY, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (hoveringBonus) {
                context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.showmeyourbuild.attribute_bonuses"), mouseX, mouseY);
            }
            if (this.showBonusPanel) {
                if (this.snapshot == null && ModCompat.ATTRIBUTE_PANEL_LOADED) {
                    class_2487 liveAttrs = AttributePanelAPI.getAttributeSnapshot((class_1657)this.player);
                    StatsViewRenderer.loadAttributes(liveAttrs);
                }
                int bonusPanelWidth = 100;
                int panelX = centerX - 128 - 100 - 4;
                int panelY = bonusBtnY;
                BonusesPanelRenderer.render(context, panelX, panelY, 100, this.field_22793, mouseX, mouseY);
            }
            BuildViewModelRenderer.drawEntity(centerX, adjustedCenterY + 55, 50, this.modelYaw, this.snapshotPlayer != null ? this.snapshotPlayer : this.player);
            if (this.snapshot != null) {
                String name = this.displayNameOverride != null ? this.displayNameOverride : this.player.method_5477().getString();
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.showmeyourbuild.player_build", (Object[])new Object[]{name}), centerX - this.field_22793.method_27525((class_5348)class_2561.method_43469((String)"gui.showmeyourbuild.player_build", (Object[])new Object[]{name})) / 2, adjustedCenterY - 55, 0xFFFFFF);
            }
        } else if (this.currentView == ViewMode.STATS) {
            if (this.snapshot == null && ModCompat.ATTRIBUTE_PANEL_LOADED) {
                class_2487 attrNbt = AttributePanelAPI.getAttributeSnapshot((class_1657)this.player);
                StatsViewRenderer.loadAttributes(attrNbt);
                BonusDataStore.loadFromNbt(attrNbt);
            }
            StatsViewRenderer.render(context, centerX, centerY, this.field_22793, mouseX, mouseY);
            long elapsed = System.currentTimeMillis() - this.statsToggleTime;
            int duration = 10000;
            if (elapsed < 10000L) {
                float bouncePhase = (float)(elapsed % 1000L) / 1000.0f;
                double bounce = Math.sin((double)bouncePhase * Math.PI * 2.0) * 5.0;
                float alphaRatio = 1.0f - (float)elapsed / 10000.0f;
                alphaRatio = class_3532.method_15363((float)alphaRatio, (float)0.0f, (float)1.0f);
                int alpha = (int)(alphaRatio * 255.0f);
                int color = alpha << 24 | 0xFFFFFF;
                String msg = class_2561.method_43471((String)"gui.showmeyourbuild.scroll_for_more").getString();
                int msgWidth = this.field_22793.method_1727(msg);
                int n = centerX - msgWidth / 2;
                int msgY = centerY + 90 + (int)bounce;
                context.method_25303(this.field_22793, msg, n, msgY, color);
            }
        }
        if (hoveringPotions && this.snapshotPlayer == null && !this.displayNameOverride.equals(this.localPlayerName) && (now = System.currentTimeMillis()) - this.lastEffectRequestTime > 1000L) {
            this.lastEffectRequestTime = now;
            ClientPlayNetworking.send((class_8710)new RequestLiveEffectsPayload(this.displayNameOverride));
        }
        if (hoveringPotions) {
            if (!this.wasHoveringPotions) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14978, (float)1.0f, (float)1.0f));
            }
            class_1657 effectSource = this.snapshotPlayer != null ? this.snapshotPlayer : this.player;
            boolean isSnapshot = this.snapshotPlayer != null;
            List<Object> effects = this.snapshotPlayer == null && !this.displayNameOverride.equals(this.localPlayerName) ? LiveEffectStore.get(this.displayNameOverride) : effectSource.method_6026().stream().toList();
            if (!effects.isEmpty()) {
                class_4074 spriteManager = class_310.method_1551().method_18505();
                int x = mouseX + 12;
                int y = mouseY;
                int iconSize = 18;
                int padding = 4;
                int lineHeight = 20;
                int maxTextWidth = 0;
                for (class_1293 class_12932 : effects) {
                    class_1291 statusEffect = (class_1291)class_12932.method_5579().comp_349();
                    String name = class_2561.method_43471((String)statusEffect.method_5567()).getString();
                    int amp = class_12932.method_5578() + 1;
                    String string = PotionEffectRenderer.formatDuration(class_12932.method_5584(), isSnapshot);
                    String fullText = name + " " + amp + " (" + string + ")";
                    maxTextWidth = Math.max(maxTextWidth, this.field_22793.method_1727(fullText));
                }
                int boxWidth = 22 + maxTextWidth + padding * 2;
                int n = effects.size() * lineHeight + padding * 2;
                int screenWidth = this.field_22789;
                int screenHeight = this.field_22790;
                if (x + boxWidth > screenWidth) {
                    x = screenWidth - boxWidth - 4;
                }
                if (y + n > screenHeight) {
                    y = screenHeight - n - 4;
                }
                context.method_25296(x - padding, y - padding, x - padding + boxWidth, y - padding + n, -267382768, -267382768);
                for (class_1293 class_12933 : effects) {
                    class_6880 statusEffectEntry = class_12933.method_5579();
                    class_1291 statusEffect = (class_1291)statusEffectEntry.comp_349();
                    class_1058 sprite = spriteManager.method_18663(statusEffectEntry);
                    String name = class_2561.method_43471((String)statusEffect.method_5567()).getString();
                    int amp = class_12933.method_5578() + 1;
                    String duration = PotionEffectRenderer.formatDuration(class_12933.method_5584(), isSnapshot);
                    if (sprite != null) {
                        RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
                        context.method_25298(x, y + 1, 0, iconSize, iconSize, sprite);
                    }
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)(name + " " + amp + " (" + duration + ")")), x + 22, y + 6, 0xFFFFFF, false);
                    y += lineHeight;
                }
            } else {
                context.method_51438(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.showmeyourbuild.no_active_effects"), mouseX, mouseY);
            }
        }
        this.wasHoveringPotions = hoveringPotions;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (AccessorySlotRenderer.mouseClicked((int)mouseX, (int)mouseY)) {
            return true;
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int accessoryCount = 0;
        if (this.snapshot != null) {
            accessoryCount = this.snapshot.accessories() != null ? this.snapshot.accessories().size() : 0;
        } else if (ModCompat.TRINKETS_LOADED) {
            accessoryCount = TrinketsApi.getTrinketComponent((class_1309)this.player).map(c -> c.getAllEquipped().size()).orElse(0);
        }
        int accessoryRows = (int)Math.ceil((double)Math.min(accessoryCount, 20) / 10.0);
        int extraHeight = accessoryRows > 1 ? 25 : (accessoryRows == 1 ? 15 : 0);
        int baseHeight = 152;
        int textureHeight = baseHeight + extraHeight;
        int verticalOffset = -textureHeight / 2;
        if (ModCompat.PUFFISH_LOADED) {
            int skillBtnX = centerX - 120 + 5;
            int skillBtnY = centerY + verticalOffset + 20;
            if (button == 0 && mouseX >= (double)skillBtnX && mouseX < (double)(skillBtnX + 16) && mouseY >= (double)skillBtnY && mouseY < (double)(skillBtnY + 16)) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)Showmeyourbuild.SWORD_UNSHEATH, (float)1.0f, (float)1.0f));
                if (this.snapshot != null) {
                    Map<class_2960, ClientCategoryData> preloadedCategories = CategoryCache.getAll();
                    Optional<class_2960> maybeFirst = preloadedCategories.keySet().stream().findFirst();
                    ReadOnlySkillsScreen.open(preloadedCategories.values().stream().toList(), maybeFirst);
                } else {
                    ClientPlayNetworking.send((class_8710)new OpenSkillsPayload(this.displayNameOverride));
                }
                return true;
            }
        }
        int statsBtnX = centerX + 120 - 21;
        int statsBtnY = centerY + verticalOffset + 20;
        if (button == 0 && mouseX >= (double)statsBtnX && mouseX < (double)(statsBtnX + 16) && mouseY >= (double)statsBtnY && mouseY < (double)(statsBtnY + 16)) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_17481, (float)1.0f, (float)1.0f));
            boolean switchingToStats = this.currentView == ViewMode.BUILD;
            ViewMode viewMode = this.currentView = switchingToStats ? ViewMode.STATS : ViewMode.BUILD;
            if (switchingToStats) {
                this.statsToggleTime = System.currentTimeMillis();
            }
            return true;
        }
        if (this.currentView == ViewMode.STATS) {
            StatsViewRenderer.handleClick((int)mouseX, (int)mouseY, centerX, centerY);
            return true;
        }
        int bonusBtnX = centerX - 120 + 5;
        int bonusBtnY = centerY - textureHeight / 2 + 48;
        if (mouseX >= (double)bonusBtnX && mouseX < (double)(bonusBtnX + 16) && mouseY >= (double)bonusBtnY && mouseY < (double)(bonusBtnY + 16)) {
            this.showBonusPanel = !this.showBonusPanel;
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_15119, (float)0.8f, (float)1.2f));
            return true;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            this.dragging = true;
            this.lastMouseX = mouseX;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.currentView == ViewMode.STATS) {
            StatsViewRenderer.handleScroll(verticalAmount);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.dragging = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging && button == 0) {
            this.modelYaw += (float)(mouseX - this.lastMouseX) * 0.5f;
            this.lastMouseX = mouseX;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25421() {
        return false;
    }

    private static enum ViewMode {
        BUILD,
        STATS;

    }
}

