/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.showmeyourbuild.client.renderer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.pixeldreamstudios.showmeyourbuild.client.BonusDataStore;
import net.pixeldreamstudios.showmeyourbuild.client.renderer.stats.StatsViewRenderer;

@Environment(value=EnvType.CLIENT)
public class BonusesPanelRenderer {
    public static void render(class_332 context, int anchorX, int anchorY, int maxWidth, class_327 textRenderer, int mouseX, int mouseY) {
        Map<class_2561, Double> condensedBonuses = BonusDataStore.getCondensedBonusesFrom(StatsViewRenderer.getCurrentAttributes());
        float scale = 0.75f;
        int padding = 6;
        int spacingBetween = 6;
        Objects.requireNonNull(textRenderer);
        int scaledFontHeight = (int)(9.0f * scale);
        int lineHeight = scaledFontHeight + 4;
        int panelWidth = maxWidth;
        int panelHeight = condensedBonuses.size() * lineHeight + padding * 2;
        context.method_25296(anchorX, anchorY, anchorX + panelWidth, anchorY + panelHeight, -267382768, -267382768);
        context.method_25294(anchorX, anchorY, anchorX + panelWidth, anchorY + 1, -11184811);
        context.method_25294(anchorX, anchorY + panelHeight - 1, anchorX + panelWidth, anchorY + panelHeight, -11184811);
        context.method_25294(anchorX, anchorY, anchorX + 1, anchorY + panelHeight, -11184811);
        context.method_25294(anchorX + panelWidth - 1, anchorY, anchorX + panelWidth, anchorY + panelHeight, -11184811);
        int y = anchorY + padding;
        class_4587 matrices = context.method_51448();
        int row = 0;
        for (Map.Entry<class_2561, Double> entry : condensedBonuses.entrySet()) {
            boolean mouseOverRow;
            boolean wasTruncated;
            class_2561 labelText = entry.getKey();
            String fullLabel = labelText.getString();
            double value = entry.getValue();
            int color = value > 0.0 ? 65280 : 0xFF5555;
            String valueStr = String.format("%+,.2f", value);
            int valuePixelWidth = (int)((float)textRenderer.method_1727(valueStr) * scale);
            int totalInnerWidth = (int)((float)(panelWidth - padding * 2) / scale);
            int maxLabelWidth = totalInnerWidth - valuePixelWidth - (int)((float)spacingBetween / scale);
            Object trimmedLabel = fullLabel;
            boolean bl = wasTruncated = textRenderer.method_1727(fullLabel) > maxLabelWidth;
            if (wasTruncated) {
                String ellipsis = "\u2026";
                int ellipsisWidth = textRenderer.method_1727(ellipsis);
                trimmedLabel = textRenderer.method_27523(fullLabel, maxLabelWidth - ellipsisWidth) + ellipsis;
            }
            if (row % 2 == 1) {
                context.method_25294(anchorX + 1, y, anchorX + panelWidth - 1, y + lineHeight - 1, 0x10FFFFFF);
            }
            matrices.method_22903();
            matrices.method_46416((float)(anchorX + padding), (float)y + (float)(lineHeight - scaledFontHeight) / 2.0f, 0.0f);
            matrices.method_22905(scale, scale, 1.0f);
            context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)trimmedLabel), 0, 0, color, false);
            int valueX = totalInnerWidth - valuePixelWidth;
            context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)valueStr), valueX, 0, color, false);
            matrices.method_22909();
            int mouseRelativeX = mouseX - anchorX - padding;
            int mouseRelativeY = mouseY - y;
            boolean bl2 = mouseOverRow = mouseX >= anchorX + 1 && mouseX < anchorX + panelWidth - 1 && mouseY >= y && mouseY < y + lineHeight;
            if (mouseOverRow && (float)mouseRelativeX / scale < (float)textRenderer.method_1727((String)trimmedLabel)) {
                context.method_51434(textRenderer, List.of(class_2561.method_43470((String)fullLabel)), mouseX, mouseY);
            }
            y += lineHeight;
            ++row;
        }
    }
}

